/*
   Copyright (C) 1998  Ulric Eriksson <ulric@edu.stockholm.se>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the Licence, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Foundation, Inc., 59 Temple Place - Suite 330, Boston,
   MA 02111-1307, USA.
 */

/* 
 * SiagP.h - Private definitions for Siag widget
 * 
 */

#ifndef _XawSiagP_h
#define _XawSiagP_h

/***********************************************************************
 *
 * Siag Widget Private Data
 *
 ***********************************************************************/

#include "Siag.h"
#include <X11/Xmu/Converters.h>

/* New fields for the Siag widget class record */
typedef struct {int empty;} SiagClassPart;

/* Full class record declaration */
typedef struct _SiagClassRec {
    CoreClassPart	core_class;
    CompositeClassPart  composite_class;
    SiagClassPart	siag_class;
} SiagClassRec;

extern SiagClassRec siagClassRec;

/* New fields for the Siag widget record */
typedef struct {
    /* resources */
    Dimension   h_space, v_space;

#if 0	/* Box stuff */
    /* private state */
    Dimension	preferred_width, preferred_height;
    Dimension	last_query_width, last_query_height;
    XtGeometryMask last_query_mode;
#endif
} SiagPart;


/****************************************************************
 *
 * Full instance record declaration
 *
 ****************************************************************/

typedef struct _SiagRec {
    CorePart	    core;
    CompositePart   composite;
    SiagPart 	    siag;
} SiagRec;

#endif /* _XawSiagP_h */
