/***************************************************************
LanceMan's quickplot --- a fast interactive 2D plotter

Copyright (C) 1998  Lance Arsenault

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; version 2
of the License.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

***********************************************************************/
/* $Id: option.h,v 1.2 1998/03/10 04:15:55 lance Exp $ */
#include <unistd.h>
#include "GNUgetopt.h"

/* There are standard Xt options and QuickPlot options
 * If you add options you better check for conflicts
 */

struct XtOpt {
  const char *arg;
  short num_vals;
};

/***********************************/
/************ Xt options ***********/
/***********************************/

/* this is the first unique combination of characters of the Intrinsics
 * built-in command line options, i.e. just enough characters so
 * that they don't look like quickplot short_options[] below and you
 * can tell them apart from each other.
 */

static struct XtOpt XtOptions[] = 
{
  { "-ba" , 1 },      /* background */
  { "-bg" , 1 },      /* background (other form) */
  { "-fo" , 1 },      /* foreground */
  { "-fg" , 1 },
  { "-borderc" , 1 }, /* borderColor */
  { "-bd" , 1 },
  { "-borderw" , 1 }, /* borderWidth */
  { "-bw" , 1 },
  { "-d" , 1 },       /* display */
  { "-fo" , 1 },      /* font */
  { "-fn" , 1 },
  { "-g" , 1 },       /* geometry */
  { "-i" , 0 },       /* iconic */
  { "-na" , 1 },       /* name */
  { "-t" , 1 },       /* title */
  { "-r" , 0 },       /* reverse Video */
  { "+r" , 0 },       /* no reverse Video */
  { "-se" , 1 },      /* selection timeout */
  { "-sy" , 0 },      /* synchronous */
  { "+s" , 0 },       /* disable synchronous */
  { "-xn" , 1 },      /* Applcation national language */
  { "-xr" , 1 },      /* resource declaration */
  { "-xt" , 1 },      /* xtsessionID - session ID - used to communicate with SM */
  { NULL , 0 }
};

/***********************************/
/****** QuickPlot options **********/
/***********************************/

static struct option long_options[] =
{
  {"binary", 0, 0, 'b'},
  {"function-plot", 1, 0, 'f'},
  {"help", 0, 0, 'h'},
  {"labels", 1, 0, 'l'},
  {"no-lines", 0, 0, 'n'},
  {"phase-plot", 1, 0, 'p'},
  {"no-pixmap", 0, 0, 'X'},
  {"same-scale", 0, 0, 's'},
  {"verbose", 0, 0, 'v'},
  {"black-and-white", 0, 0, 'B'},
  {"label-seperator", 1, 0, 'L'},
  {"pipe", 0, 0, 'P'},
  {"read-labels", 0, 0, 'R'},
  {"skip-lines", 1, 0, 'S'},
  {"version", 0, 0, 'V'},
  {0, 0, 0, 0}
};

static char * short_options  = {"bf:hl:np:svBL:NPRS:VX"};
