/***************************************************************
LanceMan's quickplot --- a fast interactive 2D plotter

Copyright (C) 1998  Lance Arsenault

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; version 2
of the License.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

***********************************************************************/
/* $Id: get_options.c,v 1.2 1998/03/10 04:15:55 lance Exp $ */
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <assert.h>

#include "data.h"
#include "option.h"
#include "version.h"

extern void usage(const char *argv0, FILE *fileptr);
extern int  add_plots_list(Plot *plot,
			   const char *plot_list,
			   int plot_options);
extern void read_in_data(int argc, const char **argv, Plot *plot);
extern int get_num_lines_to_skip(Plot *plot, const char *optarg);

void make_default_plots_list(Plot *plot)
{
  char s[64];
  int i;

  for(i=1;i<plot->dim;i++)
    {
      sprintf(s,"%d %d ",i,0);
      if(add_plots_list(plot,s,0))/* function plots */
	{
	  fprintf(stderr,
	      "quickplot ERROR: invalid OPTION -f \"%s\"\n",s);
	  fprintf(stderr,
	      "Opps the programmer messed up make_default_plots_list() in %s\n\n",
	      __FILE__);
	  exit(1);
	}
    }
}

static void print_version(const char *argv0, FILE *fileptr)
{
  char host[265];
  host[0] = '\0';

  (void) gethostname(host,255);
  fprintf(fileptr,
	  "LANCEMAN's quickplot\n  version: %s\n  compiled %s on: %s\n\nCopyright (C) 1998 Lance Arsenault\nquickplot comes with ABSOLUTELY NO WARRANTY.\nThis is free software, and you are welcome to\nredistribute it under certain conditions.\nIt is Licensed under the GNU GENERAL PUBLIC LICENSE, Version 2, June 1991.\n",
	  LANCEMAN_VERSION,__DATE__,host);
}


void get_options(int argc, char **argv, Plot *plot)
{
  FILE *ptrin;

  if(argc < 2)
    return;

  while (1)
    {
      int c;
      int option_index = 1;

      c = GNUgetopt_long (argc, argv, short_options,
	       long_options, &option_index);

      if (c == -1)
	break;
      
      switch (c)
	{
	case 'b':
	  plot->flag |= BINARY_DATA;
	   break;
	case 'f':
	  if(add_plots_list(plot,optarg,0))
	    {
	      fprintf(stderr,
		      "quickplot ERROR: invalid OPTION -f \"%s\"\n",optarg);
	      fprintf(stderr,
		      "  there must be an even number of non-negitive integers\n seperated by space in this option argument\n\n");
	      usage(argv[0],stderr);
	      exit(1);
	    }
	  break;
	case 'h':
	  usage(argv[0],stderr);
	  exit(1);
	  break;
	case 'l':
	  if(plot->labels == NULL)
	    {
	      plot->flag |= LABELS;
	      assert(NULL != (plot->labels = (char *) malloc((strlen(optarg) +1)
							  *sizeof(char))));
	      plot->labels[0] = '\0';
	    }
	  else
	    assert(NULL != (plot->labels = (char *)
			    realloc((void *) plot->labels ,
				    (strlen(plot->labels)+strlen(optarg)+1)
				    *sizeof(char))));
	  (void) strcpy(&(plot->labels[strlen(plot->labels)]),optarg);
	  /*printf("plot->labels = <%s>\n",plot->labels);*/
	  break;
	case 'n':
	  plot->flag |= NO_LINES;
	  break;
	case 'p':
	  if(add_plots_list(plot,optarg,PHASE_PLOT))
	    {
	      fprintf(stderr,
		      "quickplot ERROR: invalid OPTION -p \"%s\"\n",optarg);
	      fprintf(stderr,
		      "  there must be an even number of non-negitive integers\n seperated by space in this option argument\n\n");
	      usage(argv[0],stderr);
	      exit(1);
	    }
	  break;
	case 's':
	  plot->flag |= SAME_SCALE;
	  break;
	case 'v':
	  plot->flag |= VERBOSE;
	  break;
	case 'B':
	  plot->flag |= BLACK_WHITE;
	  break;
	case 'L':
	  if(strlen(optarg) > 1)
	    {
	      fprintf(stderr,
		    "quickplot ERROR: invalid OPTION -L\"%s\": The label seperator must be one charactor long\n",optarg);
	      exit(1);
	    }
	  plot->label_seperator = optarg[0];
	  break;
	case 'P':
	  plot->flag |= PIPE_IN;
	  break;
	case 'R':
	  plot->flag |= READ_LABELS;
	  break;
	case 'S':
	  if(get_num_lines_to_skip(plot,optarg))
	    {
	      fprintf(stderr,
		      "quickplot ERROR: invalid OPTION -S \"%s\"\n",optarg);
	      fprintf(stderr,
		      "  this option arguement must be a positive integer\n");
	      exit(0);
	    }
	  break;
	case 'V':
	  print_version(argv[0],stderr);
	  exit(0);
	  break;
	case 'X':
	  plot->flag |= NO_PIXMAP0;
	  break;
	case ':':
	  fprintf(stderr,"quickplot ERROR: missing argument to option -%c \n", c);
	  usage(argv[0],stderr);
	  exit(1);
	  break;
	case '?':
	default:
	  /*  fprintf(stderr,"quickplot ERROR: option case '?'\n");
	  usage(argv[0],stderr);
	  exit(1);*/
	  break;
	}
    }
}
