/*
 * Copyright (c) 1997,1998 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Mon Sep 28 17:18:44 EDT 1998 */

#include <fftw-int.h>
#include <fftw.h>

/* Generated by: ./genfft -magic-alignment-check -magic-twiddle-load-all -magic-variables 4 -magic-loopi -hc2hc-forward 8 */

/*
 * This function contains 128 FP additions, 54 FP multiplications,
 * (or, 111 additions, 37 multiplications, 17 fused multiply/add),
 * 37 stack variables, and 64 memory accesses
 */
static const fftw_real K707106781 = FFTW_KONST(+0.707106781186547524400844362104849039284835938);

/*
 * Generator Id's : 
 * $Id: exprdag.ml,v 1.35 1998/09/25 19:14:16 athena Exp $
 * $Id: fft.ml,v 1.40 1998/09/14 14:43:06 fftw Exp $
 * $Id: to_c.ml,v 1.23 1998/09/14 14:43:08 fftw Exp $
 */

void fftw_hc2hc_forward_8(fftw_real *A, const fftw_complex *W, int iostride, int m, int dist)
{
     int i;
     fftw_real *X;
     fftw_real *Y;
     X = A;
     Y = A + (8 * iostride);
     {
	  fftw_real tmp137;
	  fftw_real tmp141;
	  fftw_real tmp147;
	  fftw_real tmp153;
	  fftw_real tmp140;
	  fftw_real tmp150;
	  fftw_real tmp144;
	  fftw_real tmp152;
	  ASSERT_ALIGNED_DOUBLE();
	  {
	       fftw_real tmp135;
	       fftw_real tmp136;
	       fftw_real tmp145;
	       fftw_real tmp146;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp135 = X[0];
	       tmp136 = X[4 * iostride];
	       tmp137 = tmp135 + tmp136;
	       tmp141 = tmp135 - tmp136;
	       tmp145 = X[7 * iostride];
	       tmp146 = X[3 * iostride];
	       tmp147 = tmp145 - tmp146;
	       tmp153 = tmp145 + tmp146;
	  }
	  {
	       fftw_real tmp138;
	       fftw_real tmp139;
	       fftw_real tmp142;
	       fftw_real tmp143;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp138 = X[2 * iostride];
	       tmp139 = X[6 * iostride];
	       tmp140 = tmp138 + tmp139;
	       tmp150 = tmp138 - tmp139;
	       tmp142 = X[iostride];
	       tmp143 = X[5 * iostride];
	       tmp144 = tmp142 - tmp143;
	       tmp152 = tmp142 + tmp143;
	  }
	  {
	       fftw_real tmp151;
	       fftw_real tmp154;
	       fftw_real tmp148;
	       fftw_real tmp149;
	       ASSERT_ALIGNED_DOUBLE();
	       X[2 * iostride] = tmp137 - tmp140;
	       tmp151 = tmp137 + tmp140;
	       tmp154 = tmp152 + tmp153;
	       X[4 * iostride] = tmp151 - tmp154;
	       X[0] = tmp151 + tmp154;
	       Y[-2 * iostride] = tmp153 - tmp152;
	       tmp148 = K707106781 * (tmp144 + tmp147);
	       X[3 * iostride] = tmp141 - tmp148;
	       X[iostride] = tmp141 + tmp148;
	       tmp149 = K707106781 * (tmp147 - tmp144);
	       Y[-iostride] = tmp149 - tmp150;
	       Y[-3 * iostride] = tmp150 + tmp149;
	  }
     }
     X = X + dist;
     Y = Y - dist;
     for (i = 2; i < m; i = i + 2, X = X + dist, Y = Y - dist, W = W + 7) {
	  fftw_real tmp61;
	  fftw_real tmp97;
	  fftw_real tmp124;
	  fftw_real tmp129;
	  fftw_real tmp95;
	  fftw_real tmp107;
	  fftw_real tmp110;
	  fftw_real tmp119;
	  fftw_real tmp72;
	  fftw_real tmp130;
	  fftw_real tmp100;
	  fftw_real tmp121;
	  fftw_real tmp84;
	  fftw_real tmp102;
	  fftw_real tmp105;
	  fftw_real tmp118;
	  ASSERT_ALIGNED_DOUBLE();
	  {
	       fftw_real tmp55;
	       fftw_real tmp123;
	       fftw_real tmp60;
	       fftw_real tmp122;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp55 = X[0];
	       tmp123 = Y[-7 * iostride];
	       {
		    fftw_real tmp57;
		    fftw_real tmp59;
		    fftw_real tmp56;
		    fftw_real tmp58;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp57 = X[4 * iostride];
		    tmp59 = Y[-3 * iostride];
		    tmp56 = c_re(W[3]);
		    tmp58 = c_im(W[3]);
		    tmp60 = (tmp56 * tmp57) - (tmp58 * tmp59);
		    tmp122 = (tmp58 * tmp57) + (tmp56 * tmp59);
	       }
	       tmp61 = tmp55 + tmp60;
	       tmp97 = tmp55 - tmp60;
	       tmp124 = tmp122 + tmp123;
	       tmp129 = tmp123 - tmp122;
	  }
	  {
	       fftw_real tmp89;
	       fftw_real tmp108;
	       fftw_real tmp94;
	       fftw_real tmp109;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp86;
		    fftw_real tmp88;
		    fftw_real tmp85;
		    fftw_real tmp87;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp86 = X[7 * iostride];
		    tmp88 = Y[0];
		    tmp85 = c_re(W[6]);
		    tmp87 = c_im(W[6]);
		    tmp89 = (tmp85 * tmp86) - (tmp87 * tmp88);
		    tmp108 = (tmp87 * tmp86) + (tmp85 * tmp88);
	       }
	       {
		    fftw_real tmp91;
		    fftw_real tmp93;
		    fftw_real tmp90;
		    fftw_real tmp92;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp91 = X[3 * iostride];
		    tmp93 = Y[-4 * iostride];
		    tmp90 = c_re(W[2]);
		    tmp92 = c_im(W[2]);
		    tmp94 = (tmp90 * tmp91) - (tmp92 * tmp93);
		    tmp109 = (tmp92 * tmp91) + (tmp90 * tmp93);
	       }
	       tmp95 = tmp89 + tmp94;
	       tmp107 = tmp89 - tmp94;
	       tmp110 = tmp108 - tmp109;
	       tmp119 = tmp108 + tmp109;
	  }
	  {
	       fftw_real tmp66;
	       fftw_real tmp98;
	       fftw_real tmp71;
	       fftw_real tmp99;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp63;
		    fftw_real tmp65;
		    fftw_real tmp62;
		    fftw_real tmp64;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp63 = X[2 * iostride];
		    tmp65 = Y[-5 * iostride];
		    tmp62 = c_re(W[1]);
		    tmp64 = c_im(W[1]);
		    tmp66 = (tmp62 * tmp63) - (tmp64 * tmp65);
		    tmp98 = (tmp64 * tmp63) + (tmp62 * tmp65);
	       }
	       {
		    fftw_real tmp68;
		    fftw_real tmp70;
		    fftw_real tmp67;
		    fftw_real tmp69;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp68 = X[6 * iostride];
		    tmp70 = Y[-iostride];
		    tmp67 = c_re(W[5]);
		    tmp69 = c_im(W[5]);
		    tmp71 = (tmp67 * tmp68) - (tmp69 * tmp70);
		    tmp99 = (tmp69 * tmp68) + (tmp67 * tmp70);
	       }
	       tmp72 = tmp66 + tmp71;
	       tmp130 = tmp66 - tmp71;
	       tmp100 = tmp98 - tmp99;
	       tmp121 = tmp98 + tmp99;
	  }
	  {
	       fftw_real tmp78;
	       fftw_real tmp103;
	       fftw_real tmp83;
	       fftw_real tmp104;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp75;
		    fftw_real tmp77;
		    fftw_real tmp74;
		    fftw_real tmp76;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp75 = X[iostride];
		    tmp77 = Y[-6 * iostride];
		    tmp74 = c_re(W[0]);
		    tmp76 = c_im(W[0]);
		    tmp78 = (tmp74 * tmp75) - (tmp76 * tmp77);
		    tmp103 = (tmp76 * tmp75) + (tmp74 * tmp77);
	       }
	       {
		    fftw_real tmp80;
		    fftw_real tmp82;
		    fftw_real tmp79;
		    fftw_real tmp81;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp80 = X[5 * iostride];
		    tmp82 = Y[-2 * iostride];
		    tmp79 = c_re(W[4]);
		    tmp81 = c_im(W[4]);
		    tmp83 = (tmp79 * tmp80) - (tmp81 * tmp82);
		    tmp104 = (tmp81 * tmp80) + (tmp79 * tmp82);
	       }
	       tmp84 = tmp78 + tmp83;
	       tmp102 = tmp78 - tmp83;
	       tmp105 = tmp103 - tmp104;
	       tmp118 = tmp103 + tmp104;
	  }
	  {
	       fftw_real tmp73;
	       fftw_real tmp96;
	       fftw_real tmp117;
	       fftw_real tmp120;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp73 = tmp61 + tmp72;
	       tmp96 = tmp84 + tmp95;
	       Y[-4 * iostride] = tmp73 - tmp96;
	       X[0] = tmp73 + tmp96;
	       {
		    fftw_real tmp127;
		    fftw_real tmp128;
		    fftw_real tmp125;
		    fftw_real tmp126;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp127 = tmp124 - tmp121;
		    tmp128 = tmp95 - tmp84;
		    X[6 * iostride] = -(tmp127 - tmp128);
		    Y[-2 * iostride] = tmp128 + tmp127;
		    tmp125 = tmp121 + tmp124;
		    tmp126 = tmp118 + tmp119;
		    X[4 * iostride] = -(tmp125 - tmp126);
		    Y[0] = tmp126 + tmp125;
	       }
	       tmp117 = tmp61 - tmp72;
	       tmp120 = tmp118 - tmp119;
	       Y[-6 * iostride] = tmp117 - tmp120;
	       X[2 * iostride] = tmp117 + tmp120;
	       {
		    fftw_real tmp113;
		    fftw_real tmp131;
		    fftw_real tmp116;
		    fftw_real tmp132;
		    fftw_real tmp114;
		    fftw_real tmp115;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp113 = tmp97 - tmp100;
		    tmp131 = tmp129 - tmp130;
		    tmp114 = tmp105 - tmp102;
		    tmp115 = tmp107 + tmp110;
		    tmp116 = K707106781 * (tmp114 - tmp115);
		    tmp132 = K707106781 * (tmp114 + tmp115);
		    Y[-7 * iostride] = tmp113 - tmp116;
		    X[3 * iostride] = tmp113 + tmp116;
		    X[5 * iostride] = -(tmp131 - tmp132);
		    Y[-iostride] = tmp132 + tmp131;
	       }
	       {
		    fftw_real tmp101;
		    fftw_real tmp133;
		    fftw_real tmp112;
		    fftw_real tmp134;
		    fftw_real tmp106;
		    fftw_real tmp111;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp101 = tmp97 + tmp100;
		    tmp133 = tmp130 + tmp129;
		    tmp106 = tmp102 + tmp105;
		    tmp111 = tmp107 - tmp110;
		    tmp112 = K707106781 * (tmp106 + tmp111);
		    tmp134 = K707106781 * (tmp111 - tmp106);
		    Y[-5 * iostride] = tmp101 - tmp112;
		    X[iostride] = tmp101 + tmp112;
		    X[7 * iostride] = -(tmp133 - tmp134);
		    Y[-3 * iostride] = tmp134 + tmp133;
	       }
	  }
     }
     if (i == m) {
	  fftw_real tmp1;
	  fftw_real tmp4;
	  fftw_real tmp28;
	  fftw_real tmp22;
	  fftw_real tmp45;
	  fftw_real tmp25;
	  fftw_real tmp47;
	  fftw_real tmp43;
	  fftw_real tmp48;
	  fftw_real tmp8;
	  fftw_real tmp30;
	  fftw_real tmp11;
	  fftw_real tmp32;
	  fftw_real tmp15;
	  fftw_real tmp38;
	  fftw_real tmp18;
	  fftw_real tmp40;
	  fftw_real tmp36;
	  fftw_real tmp41;
	  fftw_real tmp3;
	  fftw_real tmp2;
	  fftw_real tmp27;
	  ASSERT_ALIGNED_DOUBLE();
	  tmp1 = X[0];
	  tmp3 = X[4 * iostride];
	  tmp2 = c_re(W[3]);
	  tmp4 = tmp2 * tmp3;
	  tmp27 = c_im(W[3]);
	  tmp28 = tmp27 * tmp3;
	  {
	       fftw_real tmp21;
	       fftw_real tmp20;
	       fftw_real tmp44;
	       fftw_real tmp24;
	       fftw_real tmp23;
	       fftw_real tmp46;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp21 = X[7 * iostride];
	       tmp20 = c_re(W[6]);
	       tmp22 = tmp20 * tmp21;
	       tmp44 = c_im(W[6]);
	       tmp45 = tmp44 * tmp21;
	       tmp24 = X[3 * iostride];
	       tmp23 = c_re(W[2]);
	       tmp25 = tmp23 * tmp24;
	       tmp46 = c_im(W[2]);
	       tmp47 = tmp46 * tmp24;
	  }
	  tmp43 = tmp22 - tmp25;
	  tmp48 = tmp45 - tmp47;
	  {
	       fftw_real tmp7;
	       fftw_real tmp6;
	       fftw_real tmp29;
	       fftw_real tmp10;
	       fftw_real tmp9;
	       fftw_real tmp31;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp7 = X[2 * iostride];
	       tmp6 = c_re(W[1]);
	       tmp8 = tmp6 * tmp7;
	       tmp29 = c_im(W[1]);
	       tmp30 = tmp29 * tmp7;
	       tmp10 = X[6 * iostride];
	       tmp9 = c_re(W[5]);
	       tmp11 = tmp9 * tmp10;
	       tmp31 = c_im(W[5]);
	       tmp32 = tmp31 * tmp10;
	       {
		    fftw_real tmp14;
		    fftw_real tmp13;
		    fftw_real tmp37;
		    fftw_real tmp17;
		    fftw_real tmp16;
		    fftw_real tmp39;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp14 = X[iostride];
		    tmp13 = c_re(W[0]);
		    tmp15 = tmp13 * tmp14;
		    tmp37 = c_im(W[0]);
		    tmp38 = tmp37 * tmp14;
		    tmp17 = X[5 * iostride];
		    tmp16 = c_re(W[4]);
		    tmp18 = tmp16 * tmp17;
		    tmp39 = c_im(W[4]);
		    tmp40 = tmp39 * tmp17;
	       }
	       tmp36 = tmp15 - tmp18;
	       tmp41 = tmp38 - tmp40;
	  }
	  {
	       fftw_real tmp34;
	       fftw_real tmp49;
	       fftw_real tmp52;
	       fftw_real tmp51;
	       fftw_real tmp42;
	       fftw_real tmp50;
	       fftw_real tmp35;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp34 = tmp1 - tmp4;
	       tmp49 = tmp43 - tmp48;
	       tmp52 = tmp43 + tmp48;
	       tmp51 = tmp41 - tmp36;
	       tmp42 = tmp36 + tmp41;
	       tmp50 = tmp8 - tmp11;
	       tmp35 = tmp30 - tmp32;
	       X[iostride] = tmp34 + tmp35 + (K707106781 * (tmp42 + tmp49));
	       X[3 * iostride] = tmp34 + (K707106781 * tmp51) - (tmp35 + (K707106781 * tmp52));
	       Y[-iostride] = (K707106781 * (tmp51 + tmp52)) - (tmp28 + tmp50);
	       Y[-3 * iostride] = tmp50 + (K707106781 * tmp49) - (tmp28 + (K707106781 * tmp42));
	  }
	  {
	       fftw_real tmp5;
	       fftw_real tmp12;
	       fftw_real tmp54;
	       fftw_real tmp53;
	       fftw_real tmp26;
	       fftw_real tmp19;
	       fftw_real tmp33;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp5 = tmp1 + tmp4;
	       tmp12 = tmp8 + tmp11;
	       tmp54 = tmp45 + tmp47;
	       tmp53 = tmp38 + tmp40;
	       tmp26 = tmp22 + tmp25;
	       tmp19 = tmp15 + tmp18;
	       tmp33 = tmp30 + tmp32;
	       X[0] = tmp5 + tmp12 + tmp19 + tmp26;
	       X[2 * iostride] = tmp5 + tmp53 - (tmp12 + tmp54);
	       Y[0] = tmp28 + tmp33 + tmp53 + tmp54;
	       Y[-2 * iostride] = tmp28 + tmp26 - (tmp33 + tmp19);
	  }
     }
}

static const int twiddle_order[] =
{1, 2, 3, 4, 5, 6, 7};
fftw_codelet_desc fftw_hc2hc_forward_8_desc =
{
     "fftw_hc2hc_forward_8",
     (void (*)()) fftw_hc2hc_forward_8,
     8,
     FFTW_FORWARD,
     FFTW_HC2HC,
     131,
     7,
     twiddle_order,
};
