/*
 * Copyright (c) 1997,1998 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Mon Sep 28 17:18:43 EDT 1998 */

#include <fftw-int.h>
#include <fftw.h>

/* Generated by: ./genfft -magic-alignment-check -magic-twiddle-load-all -magic-variables 4 -magic-loopi -hc2hc-forward 7 */

/*
 * This function contains 141 FP additions, 120 FP multiplications,
 * (or, 129 additions, 108 multiplications, 12 fused multiply/add),
 * 25 stack variables, and 56 memory accesses
 */
static const fftw_real K222520933 = FFTW_KONST(+0.222520933956314404288902564496794759466355569);
static const fftw_real K900968867 = FFTW_KONST(+0.900968867902419126236102319507445051165919162);
static const fftw_real K623489801 = FFTW_KONST(+0.623489801858733530525004884004239810632274731);
static const fftw_real K433883739 = FFTW_KONST(+0.433883739117558120475768332848358754609990728);
static const fftw_real K781831482 = FFTW_KONST(+0.781831482468029808708444526674057750232334519);
static const fftw_real K974927912 = FFTW_KONST(+0.974927912181823607018131682993931217232785801);

/*
 * Generator Id's : 
 * $Id: exprdag.ml,v 1.35 1998/09/25 19:14:16 athena Exp $
 * $Id: fft.ml,v 1.40 1998/09/14 14:43:06 fftw Exp $
 * $Id: to_c.ml,v 1.23 1998/09/14 14:43:08 fftw Exp $
 */

void fftw_hc2hc_forward_7(fftw_real *A, const fftw_complex *W, int iostride, int m, int dist)
{
     int i;
     fftw_real *X;
     fftw_real *Y;
     X = A;
     Y = A + (7 * iostride);
     {
	  fftw_real tmp106;
	  fftw_real tmp115;
	  fftw_real tmp116;
	  fftw_real tmp109;
	  fftw_real tmp118;
	  fftw_real tmp112;
	  fftw_real tmp117;
	  fftw_real tmp113;
	  fftw_real tmp114;
	  ASSERT_ALIGNED_DOUBLE();
	  tmp106 = X[0];
	  tmp113 = X[iostride];
	  tmp114 = X[6 * iostride];
	  tmp115 = tmp113 + tmp114;
	  tmp116 = tmp114 - tmp113;
	  {
	       fftw_real tmp107;
	       fftw_real tmp108;
	       fftw_real tmp110;
	       fftw_real tmp111;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp107 = X[2 * iostride];
	       tmp108 = X[5 * iostride];
	       tmp109 = tmp107 + tmp108;
	       tmp118 = tmp108 - tmp107;
	       tmp110 = X[3 * iostride];
	       tmp111 = X[4 * iostride];
	       tmp112 = tmp110 + tmp111;
	       tmp117 = tmp111 - tmp110;
	  }
	  Y[-2 * iostride] = (K974927912 * tmp116) - (K781831482 * tmp117) - (K433883739 * tmp118);
	  Y[-iostride] = (K781831482 * tmp116) + (K974927912 * tmp118) + (K433883739 * tmp117);
	  Y[-3 * iostride] = (K433883739 * tmp116) + (K974927912 * tmp117) - (K781831482 * tmp118);
	  X[2 * iostride] = tmp106 + (K623489801 * tmp112) - (K900968867 * tmp109) - (K222520933 * tmp115);
	  X[iostride] = tmp106 + (K623489801 * tmp115) - (K900968867 * tmp112) - (K222520933 * tmp109);
	  X[3 * iostride] = tmp106 + (K623489801 * tmp109) - (K222520933 * tmp112) - (K900968867 * tmp115);
	  X[0] = tmp106 + tmp115 + tmp109 + tmp112;
     }
     X = X + dist;
     Y = Y - dist;
     for (i = 2; i < m; i = i + 2, X = X + dist, Y = Y - dist, W = W + 6) {
	  fftw_real tmp44;
	  fftw_real tmp96;
	  fftw_real tmp55;
	  fftw_real tmp98;
	  fftw_real tmp81;
	  fftw_real tmp93;
	  fftw_real tmp66;
	  fftw_real tmp99;
	  fftw_real tmp87;
	  fftw_real tmp94;
	  fftw_real tmp77;
	  fftw_real tmp100;
	  fftw_real tmp84;
	  fftw_real tmp95;
	  ASSERT_ALIGNED_DOUBLE();
	  tmp44 = X[0];
	  tmp96 = Y[-6 * iostride];
	  {
	       fftw_real tmp49;
	       fftw_real tmp79;
	       fftw_real tmp54;
	       fftw_real tmp80;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp46;
		    fftw_real tmp48;
		    fftw_real tmp45;
		    fftw_real tmp47;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp46 = X[iostride];
		    tmp48 = Y[-5 * iostride];
		    tmp45 = c_re(W[0]);
		    tmp47 = c_im(W[0]);
		    tmp49 = (tmp45 * tmp46) - (tmp47 * tmp48);
		    tmp79 = (tmp47 * tmp46) + (tmp45 * tmp48);
	       }
	       {
		    fftw_real tmp51;
		    fftw_real tmp53;
		    fftw_real tmp50;
		    fftw_real tmp52;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp51 = X[6 * iostride];
		    tmp53 = Y[0];
		    tmp50 = c_re(W[5]);
		    tmp52 = c_im(W[5]);
		    tmp54 = (tmp50 * tmp51) - (tmp52 * tmp53);
		    tmp80 = (tmp52 * tmp51) + (tmp50 * tmp53);
	       }
	       tmp55 = tmp49 + tmp54;
	       tmp98 = tmp54 - tmp49;
	       tmp81 = tmp79 - tmp80;
	       tmp93 = tmp79 + tmp80;
	  }
	  {
	       fftw_real tmp60;
	       fftw_real tmp85;
	       fftw_real tmp65;
	       fftw_real tmp86;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp57;
		    fftw_real tmp59;
		    fftw_real tmp56;
		    fftw_real tmp58;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp57 = X[2 * iostride];
		    tmp59 = Y[-4 * iostride];
		    tmp56 = c_re(W[1]);
		    tmp58 = c_im(W[1]);
		    tmp60 = (tmp56 * tmp57) - (tmp58 * tmp59);
		    tmp85 = (tmp58 * tmp57) + (tmp56 * tmp59);
	       }
	       {
		    fftw_real tmp62;
		    fftw_real tmp64;
		    fftw_real tmp61;
		    fftw_real tmp63;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp62 = X[5 * iostride];
		    tmp64 = Y[-iostride];
		    tmp61 = c_re(W[4]);
		    tmp63 = c_im(W[4]);
		    tmp65 = (tmp61 * tmp62) - (tmp63 * tmp64);
		    tmp86 = (tmp63 * tmp62) + (tmp61 * tmp64);
	       }
	       tmp66 = tmp60 + tmp65;
	       tmp99 = tmp65 - tmp60;
	       tmp87 = tmp85 - tmp86;
	       tmp94 = tmp85 + tmp86;
	  }
	  {
	       fftw_real tmp71;
	       fftw_real tmp82;
	       fftw_real tmp76;
	       fftw_real tmp83;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp68;
		    fftw_real tmp70;
		    fftw_real tmp67;
		    fftw_real tmp69;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp68 = X[3 * iostride];
		    tmp70 = Y[-3 * iostride];
		    tmp67 = c_re(W[2]);
		    tmp69 = c_im(W[2]);
		    tmp71 = (tmp67 * tmp68) - (tmp69 * tmp70);
		    tmp82 = (tmp69 * tmp68) + (tmp67 * tmp70);
	       }
	       {
		    fftw_real tmp73;
		    fftw_real tmp75;
		    fftw_real tmp72;
		    fftw_real tmp74;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp73 = X[4 * iostride];
		    tmp75 = Y[-2 * iostride];
		    tmp72 = c_re(W[3]);
		    tmp74 = c_im(W[3]);
		    tmp76 = (tmp72 * tmp73) - (tmp74 * tmp75);
		    tmp83 = (tmp74 * tmp73) + (tmp72 * tmp75);
	       }
	       tmp77 = tmp71 + tmp76;
	       tmp100 = tmp76 - tmp71;
	       tmp84 = tmp82 - tmp83;
	       tmp95 = tmp82 + tmp83;
	  }
	  {
	       fftw_real tmp90;
	       fftw_real tmp89;
	       fftw_real tmp103;
	       fftw_real tmp102;
	       ASSERT_ALIGNED_DOUBLE();
	       X[0] = tmp44 + tmp55 + tmp66 + tmp77;
	       tmp90 = (K781831482 * tmp81) + (K974927912 * tmp87) + (K433883739 * tmp84);
	       tmp89 = tmp44 + (K623489801 * tmp55) - (K900968867 * tmp77) - (K222520933 * tmp66);
	       Y[-6 * iostride] = tmp89 - tmp90;
	       X[iostride] = tmp89 + tmp90;
	       {
		    fftw_real tmp92;
		    fftw_real tmp91;
		    fftw_real tmp88;
		    fftw_real tmp78;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp92 = (K433883739 * tmp81) + (K974927912 * tmp84) - (K781831482 * tmp87);
		    tmp91 = tmp44 + (K623489801 * tmp66) - (K222520933 * tmp77) - (K900968867 * tmp55);
		    Y[-4 * iostride] = tmp91 - tmp92;
		    X[3 * iostride] = tmp91 + tmp92;
		    tmp88 = (K974927912 * tmp81) - (K781831482 * tmp84) - (K433883739 * tmp87);
		    tmp78 = tmp44 + (K623489801 * tmp77) - (K900968867 * tmp66) - (K222520933 * tmp55);
		    Y[-5 * iostride] = tmp78 - tmp88;
		    X[2 * iostride] = tmp78 + tmp88;
	       }
	       Y[0] = tmp93 + tmp94 + tmp95 + tmp96;
	       tmp103 = (K974927912 * tmp98) - (K781831482 * tmp100) - (K433883739 * tmp99);
	       tmp102 = (K623489801 * tmp95) + tmp96 - (K900968867 * tmp94) - (K222520933 * tmp93);
	       X[5 * iostride] = -(tmp102 - tmp103);
	       Y[-2 * iostride] = tmp103 + tmp102;
	       {
		    fftw_real tmp105;
		    fftw_real tmp104;
		    fftw_real tmp101;
		    fftw_real tmp97;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp105 = (K433883739 * tmp98) + (K974927912 * tmp100) - (K781831482 * tmp99);
		    tmp104 = (K623489801 * tmp94) + tmp96 - (K222520933 * tmp95) - (K900968867 * tmp93);
		    X[4 * iostride] = -(tmp104 - tmp105);
		    Y[-3 * iostride] = tmp105 + tmp104;
		    tmp101 = (K781831482 * tmp98) + (K974927912 * tmp99) + (K433883739 * tmp100);
		    tmp97 = (K623489801 * tmp93) + tmp96 - (K900968867 * tmp95) - (K222520933 * tmp94);
		    X[6 * iostride] = -(tmp97 - tmp101);
		    Y[-iostride] = tmp101 + tmp97;
	       }
	  }
     }
     if (i == m) {
	  fftw_real tmp1;
	  fftw_real tmp4;
	  fftw_real tmp24;
	  fftw_real tmp21;
	  fftw_real tmp31;
	  fftw_real tmp18;
	  fftw_real tmp29;
	  fftw_real tmp11;
	  fftw_real tmp34;
	  fftw_real tmp7;
	  fftw_real tmp26;
	  fftw_real tmp14;
	  fftw_real tmp36;
	  ASSERT_ALIGNED_DOUBLE();
	  tmp1 = X[0];
	  {
	       fftw_real tmp3;
	       fftw_real tmp2;
	       fftw_real tmp23;
	       fftw_real tmp20;
	       fftw_real tmp19;
	       fftw_real tmp30;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp3 = X[iostride];
	       tmp2 = c_re(W[0]);
	       tmp4 = tmp2 * tmp3;
	       tmp23 = c_im(W[0]);
	       tmp24 = tmp23 * tmp3;
	       tmp20 = X[4 * iostride];
	       tmp19 = c_re(W[3]);
	       tmp21 = tmp19 * tmp20;
	       tmp30 = c_im(W[3]);
	       tmp31 = tmp30 * tmp20;
	  }
	  {
	       fftw_real tmp17;
	       fftw_real tmp16;
	       fftw_real tmp28;
	       fftw_real tmp10;
	       fftw_real tmp9;
	       fftw_real tmp33;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp17 = X[3 * iostride];
	       tmp16 = c_re(W[2]);
	       tmp18 = tmp16 * tmp17;
	       tmp28 = c_im(W[2]);
	       tmp29 = tmp28 * tmp17;
	       tmp10 = X[2 * iostride];
	       tmp9 = c_re(W[1]);
	       tmp11 = tmp9 * tmp10;
	       tmp33 = c_im(W[1]);
	       tmp34 = tmp33 * tmp10;
	  }
	  {
	       fftw_real tmp6;
	       fftw_real tmp5;
	       fftw_real tmp25;
	       fftw_real tmp13;
	       fftw_real tmp12;
	       fftw_real tmp35;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp6 = X[6 * iostride];
	       tmp5 = c_re(W[5]);
	       tmp7 = tmp5 * tmp6;
	       tmp25 = c_im(W[5]);
	       tmp26 = tmp25 * tmp6;
	       tmp13 = X[5 * iostride];
	       tmp12 = c_re(W[4]);
	       tmp14 = tmp12 * tmp13;
	       tmp35 = c_im(W[4]);
	       tmp36 = tmp35 * tmp13;
	  }
	  {
	       fftw_real tmp38;
	       fftw_real tmp39;
	       fftw_real tmp43;
	       fftw_real tmp42;
	       fftw_real tmp41;
	       fftw_real tmp40;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp38 = tmp7 - tmp4;
	       tmp39 = tmp24 + tmp26;
	       tmp43 = tmp34 + tmp36;
	       tmp42 = tmp29 + tmp31;
	       tmp41 = tmp21 - tmp18;
	       tmp40 = tmp14 - tmp11;
	       Y[0] = tmp39 + tmp43 + tmp42;
	       Y[-2 * iostride] = (K974927912 * tmp38) + (K623489801 * tmp42) - (K781831482 * tmp41) - (K900968867 * tmp43) - (K433883739 * tmp40) - (K222520933 * tmp39);
	       Y[-iostride] = (K781831482 * tmp38) + (K623489801 * tmp39) + (K974927912 * tmp40) + (K433883739 * tmp41) - (K900968867 * tmp42) - (K222520933 * tmp43);
	  }
	  {
	       fftw_real tmp8;
	       fftw_real tmp15;
	       fftw_real tmp37;
	       fftw_real tmp32;
	       fftw_real tmp27;
	       fftw_real tmp22;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp8 = tmp4 + tmp7;
	       tmp15 = tmp11 + tmp14;
	       tmp37 = tmp34 - tmp36;
	       tmp32 = tmp29 - tmp31;
	       tmp27 = tmp24 - tmp26;
	       tmp22 = tmp18 + tmp21;
	       X[0] = tmp1 + tmp8 + tmp15 + tmp22;
	       X[3 * iostride] = tmp1 + (K433883739 * tmp27) + (K623489801 * tmp15) + (K974927912 * tmp32) - (K222520933 * tmp22) - (K781831482 * tmp37) - (K900968867 * tmp8);
	       X[2 * iostride] = tmp1 + (K974927912 * tmp27) + (K623489801 * tmp22) - (K781831482 * tmp32) - (K433883739 * tmp37) - (K900968867 * tmp15) - (K222520933 * tmp8);
	       X[iostride] = tmp1 + (K623489801 * tmp8) + (K781831482 * tmp27) + (K974927912 * tmp37) + (K433883739 * tmp32) - (K900968867 * tmp22) - (K222520933 * tmp15);
	  }
     }
}

static const int twiddle_order[] =
{1, 2, 3, 4, 5, 6};
fftw_codelet_desc fftw_hc2hc_forward_7_desc =
{
     "fftw_hc2hc_forward_7",
     (void (*)()) fftw_hc2hc_forward_7,
     7,
     FFTW_FORWARD,
     FFTW_HC2HC,
     115,
     6,
     twiddle_order,
};
