/*
 * Copyright (c) 1997,1998 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Mon Sep 28 17:19:40 EDT 1998 */

#include <fftw-int.h>
#include <fftw.h>

/* Generated by: ./genfft -magic-alignment-check -magic-twiddle-load-all -magic-variables 4 -magic-loopi -hc2hc-backward 3 */

/*
 * This function contains 30 FP additions, 22 FP multiplications,
 * (or, 20 additions, 12 multiplications, 10 fused multiply/add),
 * 15 stack variables, and 24 memory accesses
 */
static const fftw_real K1_500000000 = FFTW_KONST(+1.500000000000000000000000000000000000000000000);
static const fftw_real K500000000 = FFTW_KONST(+0.500000000000000000000000000000000000000000000);
static const fftw_real K866025403 = FFTW_KONST(+0.866025403784438646763723170752936183471402627);
static const fftw_real K2_000000000 = FFTW_KONST(+2.000000000000000000000000000000000000000000000);
static const fftw_real K1_732050807 = FFTW_KONST(+1.732050807568877293527446341505872366942805254);

/*
 * Generator Id's : 
 * $Id: exprdag.ml,v 1.35 1998/09/25 19:14:16 athena Exp $
 * $Id: fft.ml,v 1.40 1998/09/14 14:43:06 fftw Exp $
 * $Id: to_c.ml,v 1.23 1998/09/14 14:43:08 fftw Exp $
 */

void fftw_hc2hc_backward_3(fftw_real *A, const fftw_complex *W, int iostride, int m, int dist)
{
     int i;
     fftw_real *X;
     fftw_real *Y;
     X = A;
     Y = A + (3 * iostride);
     {
	  fftw_real tmp37;
	  fftw_real tmp33;
	  fftw_real tmp34;
	  fftw_real tmp35;
	  fftw_real tmp36;
	  ASSERT_ALIGNED_DOUBLE();
	  tmp36 = Y[-iostride];
	  tmp37 = K1_732050807 * tmp36;
	  tmp33 = X[0];
	  tmp34 = X[iostride];
	  tmp35 = tmp34 - tmp33;
	  X[0] = tmp33 + (K2_000000000 * tmp34);
	  X[2 * iostride] = tmp37 - tmp35;
	  X[iostride] = -(tmp35 + tmp37);
     }
     X = X + dist;
     Y = Y - dist;
     for (i = 2; i < m; i = i + 2, X = X + dist, Y = Y - dist, W = W + 2) {
	  fftw_real tmp13;
	  fftw_real tmp16;
	  fftw_real tmp22;
	  fftw_real tmp26;
	  fftw_real tmp17;
	  fftw_real tmp20;
	  fftw_real tmp23;
	  fftw_real tmp27;
	  ASSERT_ALIGNED_DOUBLE();
	  {
	       fftw_real tmp14;
	       fftw_real tmp15;
	       fftw_real tmp18;
	       fftw_real tmp19;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp13 = X[0];
	       tmp14 = X[iostride];
	       tmp15 = Y[-2 * iostride];
	       tmp16 = tmp14 + tmp15;
	       tmp22 = K866025403 * (tmp14 - tmp15);
	       tmp26 = tmp13 - (K500000000 * tmp16);
	       tmp17 = Y[0];
	       tmp18 = Y[-iostride];
	       tmp19 = X[2 * iostride];
	       tmp20 = tmp18 - tmp19;
	       tmp23 = tmp17 - (K500000000 * tmp20);
	       tmp27 = K866025403 * (tmp18 + tmp19);
	  }
	  X[0] = tmp13 + tmp16;
	  {
	       fftw_real tmp30;
	       fftw_real tmp32;
	       fftw_real tmp29;
	       fftw_real tmp31;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp30 = tmp23 - tmp22;
	       tmp32 = tmp26 + tmp27;
	       tmp29 = c_re(W[1]);
	       tmp31 = c_im(W[1]);
	       Y[0] = (tmp29 * tmp30) - (tmp31 * tmp32);
	       X[2 * iostride] = (tmp31 * tmp30) + (tmp29 * tmp32);
	  }
	  Y[-2 * iostride] = tmp17 + tmp20;
	  {
	       fftw_real tmp24;
	       fftw_real tmp28;
	       fftw_real tmp21;
	       fftw_real tmp25;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp24 = tmp22 + tmp23;
	       tmp28 = tmp26 - tmp27;
	       tmp21 = c_re(W[0]);
	       tmp25 = c_im(W[0]);
	       Y[-iostride] = (tmp21 * tmp24) - (tmp25 * tmp28);
	       X[iostride] = (tmp25 * tmp24) + (tmp21 * tmp28);
	  }
     }
     if (i == m) {
	  fftw_real tmp7;
	  fftw_real tmp10;
	  fftw_real tmp1;
	  fftw_real tmp3;
	  fftw_real tmp9;
	  fftw_real tmp6;
	  fftw_real tmp2;
	  fftw_real tmp5;
	  ASSERT_ALIGNED_DOUBLE();
	  tmp6 = Y[0];
	  tmp7 = K866025403 * tmp6;
	  tmp10 = K1_500000000 * tmp6;
	  tmp1 = X[0];
	  tmp2 = X[iostride];
	  tmp3 = tmp1 + tmp2;
	  tmp9 = K866025403 * (tmp2 - tmp1);
	  X[0] = tmp1 + tmp3;
	  tmp5 = tmp1 - (K500000000 * tmp3);
	  {
	       fftw_real tmp4;
	       fftw_real tmp8;
	       fftw_real tmp11;
	       fftw_real tmp12;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp4 = c_re(W[0]);
	       tmp8 = c_im(W[0]);
	       X[iostride] = (tmp4 * (tmp5 - tmp7)) + (tmp8 * (tmp9 + tmp10));
	       tmp11 = c_re(W[1]);
	       tmp12 = c_im(W[1]);
	       X[2 * iostride] = (tmp11 * (tmp5 + tmp7)) + (tmp12 * (tmp10 - tmp9));
	  }
     }
}

static const int twiddle_order[] =
{1, 2};
fftw_codelet_desc fftw_hc2hc_backward_3_desc =
{
     "fftw_hc2hc_backward_3",
     (void (*)()) fftw_hc2hc_backward_3,
     3,
     FFTW_BACKWARD,
     FFTW_HC2HC,
     59,
     2,
     twiddle_order,
};
