/*
 * Copyright (c) 1997,1998 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Mon Sep 28 17:19:58 EDT 1998 */

#include <fftw-int.h>
#include <fftw.h>

/* Generated by: ./genfft -magic-alignment-check -magic-twiddle-load-all -magic-variables 4 -magic-loopi -hc2hc-backward 16 */

/*
 * This function contains 352 FP additions, 157 FP multiplications,
 * (or, 288 additions, 93 multiplications, 64 fused multiply/add),
 * 49 stack variables, and 128 memory accesses
 */
static const fftw_real K707106781 = FFTW_KONST(+0.707106781186547524400844362104849039284835938);
static const fftw_real K382683432 = FFTW_KONST(+0.382683432365089771728459984030398866761344562);
static const fftw_real K923879532 = FFTW_KONST(+0.923879532511286756128183189396788286822416626);
static const fftw_real K765366864 = FFTW_KONST(+0.765366864730179543456919968060797733522689125);
static const fftw_real K1_847759065 = FFTW_KONST(+1.847759065022573512256366378793576573644833252);
static const fftw_real K1_414213562 = FFTW_KONST(+1.414213562373095048801688724209698078569671875);
static const fftw_real K2_000000000 = FFTW_KONST(+2.000000000000000000000000000000000000000000000);

/*
 * Generator Id's : 
 * $Id: exprdag.ml,v 1.35 1998/09/25 19:14:16 athena Exp $
 * $Id: fft.ml,v 1.40 1998/09/14 14:43:06 fftw Exp $
 * $Id: to_c.ml,v 1.23 1998/09/14 14:43:08 fftw Exp $
 */

void fftw_hc2hc_backward_16(fftw_real *A, const fftw_complex *W, int iostride, int m, int dist)
{
     int i;
     fftw_real *X;
     fftw_real *Y;
     X = A;
     Y = A + (16 * iostride);
     {
	  fftw_real tmp338;
	  fftw_real tmp383;
	  fftw_real tmp371;
	  fftw_real tmp350;
	  fftw_real tmp335;
	  fftw_real tmp347;
	  fftw_real tmp368;
	  fftw_real tmp382;
	  fftw_real tmp342;
	  fftw_real tmp358;
	  fftw_real tmp345;
	  fftw_real tmp355;
	  fftw_real tmp352;
	  fftw_real tmp378;
	  fftw_real tmp386;
	  fftw_real tmp385;
	  fftw_real tmp375;
	  fftw_real tmp359;
	  ASSERT_ALIGNED_DOUBLE();
	  {
	       fftw_real tmp336;
	       fftw_real tmp337;
	       fftw_real tmp369;
	       fftw_real tmp348;
	       fftw_real tmp349;
	       fftw_real tmp370;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp336 = X[2 * iostride];
	       tmp337 = X[6 * iostride];
	       tmp369 = tmp336 - tmp337;
	       tmp348 = Y[-2 * iostride];
	       tmp349 = Y[-6 * iostride];
	       tmp370 = tmp349 + tmp348;
	       tmp338 = K2_000000000 * (tmp336 + tmp337);
	       tmp383 = K1_414213562 * (tmp369 + tmp370);
	       tmp371 = K1_414213562 * (tmp369 - tmp370);
	       tmp350 = K2_000000000 * (tmp348 - tmp349);
	  }
	  {
	       fftw_real tmp334;
	       fftw_real tmp367;
	       fftw_real tmp332;
	       fftw_real tmp365;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp333;
		    fftw_real tmp366;
		    fftw_real tmp330;
		    fftw_real tmp331;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp333 = X[4 * iostride];
		    tmp334 = K2_000000000 * tmp333;
		    tmp366 = Y[-4 * iostride];
		    tmp367 = K2_000000000 * tmp366;
		    tmp330 = X[0];
		    tmp331 = X[8 * iostride];
		    tmp332 = tmp330 + tmp331;
		    tmp365 = tmp330 - tmp331;
	       }
	       tmp335 = tmp332 + tmp334;
	       tmp347 = tmp332 - tmp334;
	       tmp368 = tmp365 - tmp367;
	       tmp382 = tmp365 + tmp367;
	  }
	  {
	       fftw_real tmp373;
	       fftw_real tmp377;
	       fftw_real tmp376;
	       fftw_real tmp374;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp340;
		    fftw_real tmp341;
		    fftw_real tmp356;
		    fftw_real tmp357;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp340 = X[iostride];
		    tmp341 = X[7 * iostride];
		    tmp342 = tmp340 + tmp341;
		    tmp373 = tmp340 - tmp341;
		    tmp356 = Y[-iostride];
		    tmp357 = Y[-7 * iostride];
		    tmp358 = tmp356 - tmp357;
		    tmp377 = tmp356 + tmp357;
	       }
	       {
		    fftw_real tmp343;
		    fftw_real tmp344;
		    fftw_real tmp353;
		    fftw_real tmp354;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp343 = X[3 * iostride];
		    tmp344 = X[5 * iostride];
		    tmp345 = tmp343 + tmp344;
		    tmp376 = tmp344 - tmp343;
		    tmp353 = Y[-3 * iostride];
		    tmp354 = Y[-5 * iostride];
		    tmp355 = tmp353 - tmp354;
		    tmp374 = tmp354 + tmp353;
	       }
	       tmp352 = tmp342 - tmp345;
	       tmp378 = tmp376 + tmp377;
	       tmp386 = tmp377 - tmp376;
	       tmp385 = tmp373 + tmp374;
	       tmp375 = tmp373 - tmp374;
	       tmp359 = tmp355 + tmp358;
	  }
	  {
	       fftw_real tmp339;
	       fftw_real tmp346;
	       fftw_real tmp363;
	       fftw_real tmp364;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp339 = tmp335 + tmp338;
	       tmp346 = K2_000000000 * (tmp342 + tmp345);
	       X[8 * iostride] = tmp339 - tmp346;
	       X[0] = tmp339 + tmp346;
	       tmp363 = tmp335 - tmp338;
	       tmp364 = K2_000000000 * (tmp358 - tmp355);
	       X[4 * iostride] = tmp363 - tmp364;
	       X[12 * iostride] = tmp363 + tmp364;
	  }
	  {
	       fftw_real tmp351;
	       fftw_real tmp360;
	       fftw_real tmp361;
	       fftw_real tmp362;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp351 = tmp347 - tmp350;
	       tmp360 = K1_414213562 * (tmp352 - tmp359);
	       X[10 * iostride] = tmp351 - tmp360;
	       X[2 * iostride] = tmp351 + tmp360;
	       tmp361 = tmp347 + tmp350;
	       tmp362 = K1_414213562 * (tmp352 + tmp359);
	       X[6 * iostride] = tmp361 - tmp362;
	       X[14 * iostride] = tmp361 + tmp362;
	  }
	  {
	       fftw_real tmp372;
	       fftw_real tmp379;
	       fftw_real tmp380;
	       fftw_real tmp381;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp372 = tmp368 + tmp371;
	       tmp379 = (K1_847759065 * tmp375) - (K765366864 * tmp378);
	       X[9 * iostride] = tmp372 - tmp379;
	       X[iostride] = tmp372 + tmp379;
	       tmp380 = tmp368 - tmp371;
	       tmp381 = (K765366864 * tmp375) + (K1_847759065 * tmp378);
	       X[5 * iostride] = tmp380 - tmp381;
	       X[13 * iostride] = tmp380 + tmp381;
	  }
	  {
	       fftw_real tmp384;
	       fftw_real tmp387;
	       fftw_real tmp388;
	       fftw_real tmp389;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp384 = tmp382 - tmp383;
	       tmp387 = (K765366864 * tmp385) - (K1_847759065 * tmp386);
	       X[11 * iostride] = tmp384 - tmp387;
	       X[3 * iostride] = tmp384 + tmp387;
	       tmp388 = tmp382 + tmp383;
	       tmp389 = (K1_847759065 * tmp385) + (K765366864 * tmp386);
	       X[7 * iostride] = tmp388 - tmp389;
	       X[15 * iostride] = tmp388 + tmp389;
	  }
     }
     X = X + dist;
     Y = Y - dist;
     for (i = 2; i < m; i = i + 2, X = X + dist, Y = Y - dist, W = W + 15) {
	  fftw_real tmp132;
	  fftw_real tmp157;
	  fftw_real tmp194;
	  fftw_real tmp219;
	  fftw_real tmp241;
	  fftw_real tmp295;
	  fftw_real tmp269;
	  fftw_real tmp307;
	  fftw_real tmp154;
	  fftw_real tmp183;
	  fftw_real tmp197;
	  fftw_real tmp223;
	  fftw_real tmp256;
	  fftw_real tmp275;
	  fftw_real tmp303;
	  fftw_real tmp311;
	  fftw_real tmp139;
	  fftw_real tmp187;
	  fftw_real tmp164;
	  fftw_real tmp220;
	  fftw_real tmp272;
	  fftw_real tmp296;
	  fftw_real tmp248;
	  fftw_real tmp308;
	  fftw_real tmp147;
	  fftw_real tmp174;
	  fftw_real tmp196;
	  fftw_real tmp222;
	  fftw_real tmp263;
	  fftw_real tmp274;
	  fftw_real tmp300;
	  fftw_real tmp310;
	  ASSERT_ALIGNED_DOUBLE();
	  {
	       fftw_real tmp128;
	       fftw_real tmp239;
	       fftw_real tmp190;
	       fftw_real tmp268;
	       fftw_real tmp131;
	       fftw_real tmp267;
	       fftw_real tmp193;
	       fftw_real tmp240;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp126;
		    fftw_real tmp127;
		    fftw_real tmp188;
		    fftw_real tmp189;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp126 = X[0];
		    tmp127 = Y[-8 * iostride];
		    tmp128 = tmp126 + tmp127;
		    tmp239 = tmp126 - tmp127;
		    tmp188 = Y[0];
		    tmp189 = X[8 * iostride];
		    tmp190 = tmp188 - tmp189;
		    tmp268 = tmp188 + tmp189;
	       }
	       {
		    fftw_real tmp129;
		    fftw_real tmp130;
		    fftw_real tmp191;
		    fftw_real tmp192;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp129 = X[4 * iostride];
		    tmp130 = Y[-12 * iostride];
		    tmp131 = tmp129 + tmp130;
		    tmp267 = tmp129 - tmp130;
		    tmp191 = Y[-4 * iostride];
		    tmp192 = X[12 * iostride];
		    tmp193 = tmp191 - tmp192;
		    tmp240 = tmp191 + tmp192;
	       }
	       tmp132 = tmp128 + tmp131;
	       tmp157 = tmp128 - tmp131;
	       tmp194 = tmp190 - tmp193;
	       tmp219 = tmp190 + tmp193;
	       tmp241 = tmp239 - tmp240;
	       tmp295 = tmp239 + tmp240;
	       tmp269 = tmp267 + tmp268;
	       tmp307 = tmp268 - tmp267;
	  }
	  {
	       fftw_real tmp150;
	       fftw_real tmp253;
	       fftw_real tmp178;
	       fftw_real tmp251;
	       fftw_real tmp153;
	       fftw_real tmp250;
	       fftw_real tmp181;
	       fftw_real tmp254;
	       fftw_real tmp175;
	       fftw_real tmp182;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp148;
		    fftw_real tmp149;
		    fftw_real tmp176;
		    fftw_real tmp177;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp148 = Y[-15 * iostride];
		    tmp149 = X[7 * iostride];
		    tmp150 = tmp148 + tmp149;
		    tmp253 = tmp148 - tmp149;
		    tmp176 = Y[-7 * iostride];
		    tmp177 = X[15 * iostride];
		    tmp178 = tmp176 - tmp177;
		    tmp251 = tmp176 + tmp177;
	       }
	       {
		    fftw_real tmp151;
		    fftw_real tmp152;
		    fftw_real tmp179;
		    fftw_real tmp180;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp151 = X[3 * iostride];
		    tmp152 = Y[-11 * iostride];
		    tmp153 = tmp151 + tmp152;
		    tmp250 = tmp151 - tmp152;
		    tmp179 = Y[-3 * iostride];
		    tmp180 = X[11 * iostride];
		    tmp181 = tmp179 - tmp180;
		    tmp254 = tmp179 + tmp180;
	       }
	       tmp154 = tmp150 + tmp153;
	       tmp175 = tmp150 - tmp153;
	       tmp182 = tmp178 - tmp181;
	       tmp183 = tmp175 + tmp182;
	       tmp197 = tmp182 - tmp175;
	       tmp223 = tmp178 + tmp181;
	       {
		    fftw_real tmp252;
		    fftw_real tmp255;
		    fftw_real tmp301;
		    fftw_real tmp302;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp252 = tmp250 - tmp251;
		    tmp255 = tmp253 - tmp254;
		    tmp256 = (K923879532 * tmp252) - (K382683432 * tmp255);
		    tmp275 = (K382683432 * tmp252) + (K923879532 * tmp255);
		    tmp301 = tmp253 + tmp254;
		    tmp302 = tmp250 + tmp251;
		    tmp303 = (K382683432 * tmp301) - (K923879532 * tmp302);
		    tmp311 = (K382683432 * tmp302) + (K923879532 * tmp301);
	       }
	  }
	  {
	       fftw_real tmp135;
	       fftw_real tmp242;
	       fftw_real tmp163;
	       fftw_real tmp243;
	       fftw_real tmp138;
	       fftw_real tmp245;
	       fftw_real tmp160;
	       fftw_real tmp246;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp133;
		    fftw_real tmp134;
		    fftw_real tmp161;
		    fftw_real tmp162;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp133 = X[2 * iostride];
		    tmp134 = Y[-10 * iostride];
		    tmp135 = tmp133 + tmp134;
		    tmp242 = tmp133 - tmp134;
		    tmp161 = Y[-2 * iostride];
		    tmp162 = X[10 * iostride];
		    tmp163 = tmp161 - tmp162;
		    tmp243 = tmp161 + tmp162;
	       }
	       {
		    fftw_real tmp136;
		    fftw_real tmp137;
		    fftw_real tmp158;
		    fftw_real tmp159;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp136 = Y[-14 * iostride];
		    tmp137 = X[6 * iostride];
		    tmp138 = tmp136 + tmp137;
		    tmp245 = tmp136 - tmp137;
		    tmp158 = Y[-6 * iostride];
		    tmp159 = X[14 * iostride];
		    tmp160 = tmp158 - tmp159;
		    tmp246 = tmp158 + tmp159;
	       }
	       tmp139 = tmp135 + tmp138;
	       tmp187 = tmp135 - tmp138;
	       tmp164 = tmp160 - tmp163;
	       tmp220 = tmp163 + tmp160;
	       {
		    fftw_real tmp270;
		    fftw_real tmp271;
		    fftw_real tmp244;
		    fftw_real tmp247;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp270 = tmp242 + tmp243;
		    tmp271 = tmp245 + tmp246;
		    tmp272 = K707106781 * (tmp270 - tmp271);
		    tmp296 = K707106781 * (tmp270 + tmp271);
		    tmp244 = tmp242 - tmp243;
		    tmp247 = tmp245 - tmp246;
		    tmp248 = K707106781 * (tmp244 + tmp247);
		    tmp308 = K707106781 * (tmp244 - tmp247);
	       }
	  }
	  {
	       fftw_real tmp143;
	       fftw_real tmp260;
	       fftw_real tmp169;
	       fftw_real tmp258;
	       fftw_real tmp146;
	       fftw_real tmp257;
	       fftw_real tmp172;
	       fftw_real tmp261;
	       fftw_real tmp166;
	       fftw_real tmp173;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp141;
		    fftw_real tmp142;
		    fftw_real tmp167;
		    fftw_real tmp168;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp141 = X[iostride];
		    tmp142 = Y[-9 * iostride];
		    tmp143 = tmp141 + tmp142;
		    tmp260 = tmp141 - tmp142;
		    tmp167 = Y[-iostride];
		    tmp168 = X[9 * iostride];
		    tmp169 = tmp167 - tmp168;
		    tmp258 = tmp167 + tmp168;
	       }
	       {
		    fftw_real tmp144;
		    fftw_real tmp145;
		    fftw_real tmp170;
		    fftw_real tmp171;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp144 = X[5 * iostride];
		    tmp145 = Y[-13 * iostride];
		    tmp146 = tmp144 + tmp145;
		    tmp257 = tmp144 - tmp145;
		    tmp170 = Y[-5 * iostride];
		    tmp171 = X[13 * iostride];
		    tmp172 = tmp170 - tmp171;
		    tmp261 = tmp170 + tmp171;
	       }
	       tmp147 = tmp143 + tmp146;
	       tmp166 = tmp143 - tmp146;
	       tmp173 = tmp169 - tmp172;
	       tmp174 = tmp166 - tmp173;
	       tmp196 = tmp166 + tmp173;
	       tmp222 = tmp169 + tmp172;
	       {
		    fftw_real tmp259;
		    fftw_real tmp262;
		    fftw_real tmp298;
		    fftw_real tmp299;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp259 = tmp257 + tmp258;
		    tmp262 = tmp260 - tmp261;
		    tmp263 = (K923879532 * tmp259) + (K382683432 * tmp262);
		    tmp274 = (K923879532 * tmp262) - (K382683432 * tmp259);
		    tmp298 = tmp260 + tmp261;
		    tmp299 = tmp258 - tmp257;
		    tmp300 = (K382683432 * tmp298) - (K923879532 * tmp299);
		    tmp310 = (K382683432 * tmp299) + (K923879532 * tmp298);
	       }
	  }
	  {
	       fftw_real tmp140;
	       fftw_real tmp155;
	       fftw_real tmp217;
	       fftw_real tmp221;
	       fftw_real tmp224;
	       fftw_real tmp225;
	       fftw_real tmp216;
	       fftw_real tmp218;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp140 = tmp132 + tmp139;
	       tmp155 = tmp147 + tmp154;
	       tmp217 = tmp140 - tmp155;
	       tmp221 = tmp219 + tmp220;
	       tmp224 = tmp222 + tmp223;
	       tmp225 = tmp221 - tmp224;
	       X[0] = tmp140 + tmp155;
	       Y[-15 * iostride] = tmp221 + tmp224;
	       tmp216 = c_re(W[7]);
	       tmp218 = c_im(W[7]);
	       X[8 * iostride] = (tmp216 * tmp217) + (tmp218 * tmp225);
	       Y[-7 * iostride] = (tmp216 * tmp225) - (tmp218 * tmp217);
	  }
	  {
	       fftw_real tmp229;
	       fftw_real tmp235;
	       fftw_real tmp233;
	       fftw_real tmp237;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp227;
		    fftw_real tmp228;
		    fftw_real tmp231;
		    fftw_real tmp232;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp227 = tmp219 - tmp220;
		    tmp228 = tmp147 - tmp154;
		    tmp229 = tmp227 - tmp228;
		    tmp235 = tmp228 + tmp227;
		    tmp231 = tmp132 - tmp139;
		    tmp232 = tmp223 - tmp222;
		    tmp233 = tmp231 - tmp232;
		    tmp237 = tmp231 + tmp232;
	       }
	       {
		    fftw_real tmp226;
		    fftw_real tmp230;
		    fftw_real tmp234;
		    fftw_real tmp236;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp226 = c_re(W[11]);
		    tmp230 = c_im(W[11]);
		    Y[-3 * iostride] = (tmp226 * tmp229) - (tmp230 * tmp233);
		    X[12 * iostride] = (tmp230 * tmp229) + (tmp226 * tmp233);
		    tmp234 = c_re(W[3]);
		    tmp236 = c_im(W[3]);
		    Y[-11 * iostride] = (tmp234 * tmp235) - (tmp236 * tmp237);
		    X[4 * iostride] = (tmp236 * tmp235) + (tmp234 * tmp237);
	       }
	  }
	  {
	       fftw_real tmp185;
	       fftw_real tmp201;
	       fftw_real tmp199;
	       fftw_real tmp203;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp165;
		    fftw_real tmp184;
		    fftw_real tmp195;
		    fftw_real tmp198;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp165 = tmp157 + tmp164;
		    tmp184 = K707106781 * (tmp174 + tmp183);
		    tmp185 = tmp165 - tmp184;
		    tmp201 = tmp165 + tmp184;
		    tmp195 = tmp187 + tmp194;
		    tmp198 = K707106781 * (tmp196 + tmp197);
		    tmp199 = tmp195 - tmp198;
		    tmp203 = tmp195 + tmp198;
	       }
	       {
		    fftw_real tmp156;
		    fftw_real tmp186;
		    fftw_real tmp200;
		    fftw_real tmp202;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp156 = c_re(W[9]);
		    tmp186 = c_im(W[9]);
		    X[10 * iostride] = (tmp156 * tmp185) + (tmp186 * tmp199);
		    Y[-5 * iostride] = (tmp156 * tmp199) - (tmp186 * tmp185);
		    tmp200 = c_re(W[1]);
		    tmp202 = c_im(W[1]);
		    X[2 * iostride] = (tmp200 * tmp201) + (tmp202 * tmp203);
		    Y[-13 * iostride] = (tmp200 * tmp203) - (tmp202 * tmp201);
	       }
	  }
	  {
	       fftw_real tmp207;
	       fftw_real tmp213;
	       fftw_real tmp211;
	       fftw_real tmp215;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp205;
		    fftw_real tmp206;
		    fftw_real tmp209;
		    fftw_real tmp210;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp205 = tmp194 - tmp187;
		    tmp206 = K707106781 * (tmp174 - tmp183);
		    tmp207 = tmp205 - tmp206;
		    tmp213 = tmp205 + tmp206;
		    tmp209 = tmp157 - tmp164;
		    tmp210 = K707106781 * (tmp197 - tmp196);
		    tmp211 = tmp209 - tmp210;
		    tmp215 = tmp209 + tmp210;
	       }
	       {
		    fftw_real tmp204;
		    fftw_real tmp208;
		    fftw_real tmp212;
		    fftw_real tmp214;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp204 = c_re(W[13]);
		    tmp208 = c_im(W[13]);
		    Y[-iostride] = (tmp204 * tmp207) - (tmp208 * tmp211);
		    X[14 * iostride] = (tmp208 * tmp207) + (tmp204 * tmp211);
		    tmp212 = c_re(W[5]);
		    tmp214 = c_im(W[5]);
		    Y[-9 * iostride] = (tmp212 * tmp213) - (tmp214 * tmp215);
		    X[6 * iostride] = (tmp214 * tmp213) + (tmp212 * tmp215);
	       }
	  }
	  {
	       fftw_real tmp265;
	       fftw_real tmp279;
	       fftw_real tmp277;
	       fftw_real tmp281;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp249;
		    fftw_real tmp264;
		    fftw_real tmp273;
		    fftw_real tmp276;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp249 = tmp241 - tmp248;
		    tmp264 = tmp256 - tmp263;
		    tmp265 = tmp249 - tmp264;
		    tmp279 = tmp249 + tmp264;
		    tmp273 = tmp269 - tmp272;
		    tmp276 = tmp274 - tmp275;
		    tmp277 = tmp273 - tmp276;
		    tmp281 = tmp273 + tmp276;
	       }
	       {
		    fftw_real tmp238;
		    fftw_real tmp266;
		    fftw_real tmp278;
		    fftw_real tmp280;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp238 = c_re(W[12]);
		    tmp266 = c_im(W[12]);
		    X[13 * iostride] = (tmp238 * tmp265) + (tmp266 * tmp277);
		    Y[-2 * iostride] = (tmp238 * tmp277) - (tmp266 * tmp265);
		    tmp278 = c_re(W[4]);
		    tmp280 = c_im(W[4]);
		    X[5 * iostride] = (tmp278 * tmp279) + (tmp280 * tmp281);
		    Y[-10 * iostride] = (tmp278 * tmp281) - (tmp280 * tmp279);
	       }
	  }
	  {
	       fftw_real tmp285;
	       fftw_real tmp291;
	       fftw_real tmp289;
	       fftw_real tmp293;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp283;
		    fftw_real tmp284;
		    fftw_real tmp287;
		    fftw_real tmp288;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp283 = tmp269 + tmp272;
		    tmp284 = tmp263 + tmp256;
		    tmp285 = tmp283 - tmp284;
		    tmp291 = tmp283 + tmp284;
		    tmp287 = tmp241 + tmp248;
		    tmp288 = tmp274 + tmp275;
		    tmp289 = tmp287 - tmp288;
		    tmp293 = tmp287 + tmp288;
	       }
	       {
		    fftw_real tmp282;
		    fftw_real tmp286;
		    fftw_real tmp290;
		    fftw_real tmp292;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp282 = c_re(W[8]);
		    tmp286 = c_im(W[8]);
		    Y[-6 * iostride] = (tmp282 * tmp285) - (tmp286 * tmp289);
		    X[9 * iostride] = (tmp286 * tmp285) + (tmp282 * tmp289);
		    tmp290 = c_re(W[0]);
		    tmp292 = c_im(W[0]);
		    Y[-14 * iostride] = (tmp290 * tmp291) - (tmp292 * tmp293);
		    X[iostride] = (tmp292 * tmp291) + (tmp290 * tmp293);
	       }
	  }
	  {
	       fftw_real tmp305;
	       fftw_real tmp315;
	       fftw_real tmp313;
	       fftw_real tmp317;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp297;
		    fftw_real tmp304;
		    fftw_real tmp309;
		    fftw_real tmp312;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp297 = tmp295 - tmp296;
		    tmp304 = tmp300 + tmp303;
		    tmp305 = tmp297 - tmp304;
		    tmp315 = tmp297 + tmp304;
		    tmp309 = tmp307 + tmp308;
		    tmp312 = tmp310 - tmp311;
		    tmp313 = tmp309 - tmp312;
		    tmp317 = tmp309 + tmp312;
	       }
	       {
		    fftw_real tmp294;
		    fftw_real tmp306;
		    fftw_real tmp314;
		    fftw_real tmp316;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp294 = c_re(W[10]);
		    tmp306 = c_im(W[10]);
		    X[11 * iostride] = (tmp294 * tmp305) + (tmp306 * tmp313);
		    Y[-4 * iostride] = (tmp294 * tmp313) - (tmp306 * tmp305);
		    tmp314 = c_re(W[2]);
		    tmp316 = c_im(W[2]);
		    X[3 * iostride] = (tmp314 * tmp315) + (tmp316 * tmp317);
		    Y[-12 * iostride] = (tmp314 * tmp317) - (tmp316 * tmp315);
	       }
	  }
	  {
	       fftw_real tmp321;
	       fftw_real tmp327;
	       fftw_real tmp325;
	       fftw_real tmp329;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp319;
		    fftw_real tmp320;
		    fftw_real tmp323;
		    fftw_real tmp324;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp319 = tmp307 - tmp308;
		    tmp320 = tmp300 - tmp303;
		    tmp321 = tmp319 + tmp320;
		    tmp327 = tmp319 - tmp320;
		    tmp323 = tmp295 + tmp296;
		    tmp324 = tmp310 + tmp311;
		    tmp325 = tmp323 - tmp324;
		    tmp329 = tmp323 + tmp324;
	       }
	       {
		    fftw_real tmp318;
		    fftw_real tmp322;
		    fftw_real tmp326;
		    fftw_real tmp328;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp318 = c_re(W[6]);
		    tmp322 = c_im(W[6]);
		    Y[-8 * iostride] = (tmp318 * tmp321) - (tmp322 * tmp325);
		    X[7 * iostride] = (tmp322 * tmp321) + (tmp318 * tmp325);
		    tmp326 = c_re(W[14]);
		    tmp328 = c_im(W[14]);
		    Y[0] = (tmp326 * tmp327) - (tmp328 * tmp329);
		    X[15 * iostride] = (tmp328 * tmp327) + (tmp326 * tmp329);
	       }
	  }
     }
     if (i == m) {
	  fftw_real tmp7;
	  fftw_real tmp88;
	  fftw_real tmp20;
	  fftw_real tmp62;
	  fftw_real tmp40;
	  fftw_real tmp68;
	  fftw_real tmp97;
	  fftw_real tmp117;
	  fftw_real tmp14;
	  fftw_real tmp93;
	  fftw_real tmp25;
	  fftw_real tmp44;
	  fftw_real tmp65;
	  fftw_real tmp33;
	  fftw_real tmp30;
	  fftw_real tmp45;
	  fftw_real tmp34;
	  fftw_real tmp66;
	  fftw_real tmp116;
	  fftw_real tmp91;
	  fftw_real tmp115;
	  ASSERT_ALIGNED_DOUBLE();
	  {
	       fftw_real tmp3;
	       fftw_real tmp16;
	       fftw_real tmp39;
	       fftw_real tmp95;
	       fftw_real tmp6;
	       fftw_real tmp36;
	       fftw_real tmp19;
	       fftw_real tmp96;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp1;
		    fftw_real tmp2;
		    fftw_real tmp37;
		    fftw_real tmp38;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp1 = X[0];
		    tmp2 = X[7 * iostride];
		    tmp3 = tmp1 + tmp2;
		    tmp16 = tmp1 - tmp2;
		    tmp37 = Y[0];
		    tmp38 = Y[-7 * iostride];
		    tmp39 = tmp37 + tmp38;
		    tmp95 = tmp38 - tmp37;
	       }
	       {
		    fftw_real tmp4;
		    fftw_real tmp5;
		    fftw_real tmp17;
		    fftw_real tmp18;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp4 = X[4 * iostride];
		    tmp5 = X[3 * iostride];
		    tmp6 = tmp4 + tmp5;
		    tmp36 = tmp5 - tmp4;
		    tmp17 = Y[-4 * iostride];
		    tmp18 = Y[-3 * iostride];
		    tmp19 = tmp17 + tmp18;
		    tmp96 = tmp18 - tmp17;
	       }
	       tmp7 = tmp3 + tmp6;
	       tmp88 = tmp3 - tmp6;
	       tmp20 = tmp16 - tmp19;
	       tmp62 = tmp16 + tmp19;
	       tmp40 = tmp36 - tmp39;
	       tmp68 = tmp36 + tmp39;
	       tmp97 = tmp95 - tmp96;
	       tmp117 = tmp96 + tmp95;
	  }
	  {
	       fftw_real tmp10;
	       fftw_real tmp21;
	       fftw_real tmp24;
	       fftw_real tmp90;
	       fftw_real tmp13;
	       fftw_real tmp26;
	       fftw_real tmp29;
	       fftw_real tmp89;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp8;
		    fftw_real tmp9;
		    fftw_real tmp22;
		    fftw_real tmp23;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp8 = X[2 * iostride];
		    tmp9 = X[5 * iostride];
		    tmp10 = tmp8 + tmp9;
		    tmp21 = tmp8 - tmp9;
		    tmp22 = Y[-2 * iostride];
		    tmp23 = Y[-5 * iostride];
		    tmp24 = tmp22 + tmp23;
		    tmp90 = tmp22 - tmp23;
	       }
	       {
		    fftw_real tmp11;
		    fftw_real tmp12;
		    fftw_real tmp27;
		    fftw_real tmp28;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp11 = X[iostride];
		    tmp12 = X[6 * iostride];
		    tmp13 = tmp11 + tmp12;
		    tmp26 = tmp11 - tmp12;
		    tmp27 = Y[-iostride];
		    tmp28 = Y[-6 * iostride];
		    tmp29 = tmp27 + tmp28;
		    tmp89 = tmp28 - tmp27;
	       }
	       tmp14 = tmp10 + tmp13;
	       tmp93 = tmp13 - tmp10;
	       tmp25 = tmp21 - tmp24;
	       tmp44 = tmp21 + tmp24;
	       tmp65 = tmp26 + tmp24;
	       tmp33 = tmp26 - tmp24;
	       tmp30 = tmp26 - tmp29;
	       tmp45 = tmp26 + tmp29;
	       tmp34 = tmp29 - tmp21;
	       tmp66 = tmp21 + tmp29;
	       tmp116 = tmp90 + tmp89;
	       tmp91 = tmp89 - tmp90;
	  }
	  X[0] = K2_000000000 * (tmp7 + tmp14);
	  tmp115 = c_im(W[7]);
	  X[8 * iostride] = tmp115 * (K2_000000000 * (tmp116 - tmp117));
	  {
	       fftw_real tmp121;
	       fftw_real tmp124;
	       fftw_real tmp119;
	       fftw_real tmp120;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp119 = tmp7 - tmp14;
	       tmp120 = tmp116 + tmp117;
	       tmp121 = tmp119 - tmp120;
	       tmp124 = tmp119 + tmp120;
	       {
		    fftw_real tmp118;
		    fftw_real tmp122;
		    fftw_real tmp123;
		    fftw_real tmp125;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp118 = c_re(W[11]);
		    tmp122 = c_im(W[11]);
		    X[12 * iostride] = (tmp118 * tmp121) + (tmp122 * tmp121);
		    tmp123 = c_re(W[3]);
		    tmp125 = c_im(W[3]);
		    X[4 * iostride] = (tmp123 * tmp124) - (tmp125 * tmp124);
	       }
	  }
	  {
	       fftw_real tmp92;
	       fftw_real tmp111;
	       fftw_real tmp99;
	       fftw_real tmp109;
	       fftw_real tmp101;
	       fftw_real tmp108;
	       fftw_real tmp104;
	       fftw_real tmp112;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp94;
		    fftw_real tmp98;
		    fftw_real tmp102;
		    fftw_real tmp103;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp92 = tmp88 + tmp91;
		    tmp111 = tmp88 - tmp91;
		    tmp94 = tmp93 + tmp91;
		    tmp98 = tmp88 + tmp97;
		    tmp99 = K707106781 * (tmp94 + tmp98);
		    tmp109 = K707106781 * (tmp94 - tmp98);
		    tmp101 = tmp93 + tmp97;
		    tmp108 = tmp93 - tmp97;
		    tmp102 = tmp93 - tmp91;
		    tmp103 = tmp97 - tmp88;
		    tmp104 = K707106781 * (tmp102 + tmp103);
		    tmp112 = K707106781 * (tmp103 - tmp102);
	       }
	       {
		    fftw_real tmp87;
		    fftw_real tmp100;
		    fftw_real tmp105;
		    fftw_real tmp106;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp87 = c_re(W[9]);
		    tmp100 = c_im(W[9]);
		    X[10 * iostride] = (tmp87 * (tmp92 - tmp99)) - (tmp100 * (tmp101 + tmp104));
		    tmp105 = c_re(W[1]);
		    tmp106 = c_im(W[1]);
		    X[2 * iostride] = (tmp105 * (tmp92 + tmp99)) + (tmp106 * (tmp104 - tmp101));
	       }
	       {
		    fftw_real tmp107;
		    fftw_real tmp110;
		    fftw_real tmp113;
		    fftw_real tmp114;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp107 = c_im(W[13]);
		    tmp110 = c_re(W[13]);
		    X[14 * iostride] = (tmp107 * (tmp108 - tmp109)) + (tmp110 * (tmp111 - tmp112));
		    tmp113 = c_im(W[5]);
		    tmp114 = c_re(W[5]);
		    X[6 * iostride] = (tmp113 * (tmp108 + tmp109)) + (tmp114 * (tmp111 + tmp112));
	       }
	  }
	  {
	       fftw_real tmp64;
	       fftw_real tmp80;
	       fftw_real tmp76;
	       fftw_real tmp81;
	       fftw_real tmp73;
	       fftw_real tmp84;
	       fftw_real tmp70;
	       fftw_real tmp83;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp63;
		    fftw_real tmp74;
		    fftw_real tmp75;
		    fftw_real tmp72;
		    fftw_real tmp67;
		    fftw_real tmp69;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp63 = K707106781 * (tmp44 + tmp45);
		    tmp64 = tmp62 - tmp63;
		    tmp80 = tmp62 + tmp63;
		    tmp74 = (K923879532 * tmp65) + (K382683432 * tmp66);
		    tmp75 = (K923879532 * tmp62) + (K382683432 * tmp68);
		    tmp76 = tmp74 - tmp75;
		    tmp81 = tmp74 + tmp75;
		    tmp72 = K707106781 * (tmp25 - tmp30);
		    tmp73 = tmp72 + tmp68;
		    tmp84 = tmp68 - tmp72;
		    tmp67 = (K382683432 * tmp65) - (K923879532 * tmp66);
		    tmp69 = (K382683432 * tmp62) - (K923879532 * tmp68);
		    tmp70 = tmp67 + tmp69;
		    tmp83 = tmp67 - tmp69;
	       }
	       {
		    fftw_real tmp61;
		    fftw_real tmp71;
		    fftw_real tmp77;
		    fftw_real tmp78;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp61 = c_re(W[10]);
		    tmp71 = c_im(W[10]);
		    X[11 * iostride] = (tmp61 * (tmp64 - tmp70)) + (tmp71 * (tmp73 - tmp76));
		    tmp77 = c_re(W[2]);
		    tmp78 = c_im(W[2]);
		    X[3 * iostride] = (tmp77 * (tmp64 + tmp70)) + (tmp78 * (tmp73 + tmp76));
	       }
	       {
		    fftw_real tmp79;
		    fftw_real tmp82;
		    fftw_real tmp85;
		    fftw_real tmp86;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp79 = c_re(W[6]);
		    tmp82 = c_im(W[6]);
		    X[7 * iostride] = (tmp79 * (tmp80 - tmp81)) + (tmp82 * (tmp83 + tmp84));
		    tmp85 = c_re(W[14]);
		    tmp86 = c_im(W[14]);
		    X[15 * iostride] = (tmp85 * (tmp80 + tmp81)) + (tmp86 * (tmp84 - tmp83));
	       }
	  }
	  {
	       fftw_real tmp32;
	       fftw_real tmp54;
	       fftw_real tmp50;
	       fftw_real tmp55;
	       fftw_real tmp47;
	       fftw_real tmp57;
	       fftw_real tmp42;
	       fftw_real tmp58;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp31;
		    fftw_real tmp48;
		    fftw_real tmp49;
		    fftw_real tmp46;
		    fftw_real tmp35;
		    fftw_real tmp41;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp31 = K707106781 * (tmp25 + tmp30);
		    tmp32 = tmp20 + tmp31;
		    tmp54 = tmp20 - tmp31;
		    tmp48 = (K382683432 * tmp33) + (K923879532 * tmp34);
		    tmp49 = (K923879532 * tmp40) - (K382683432 * tmp20);
		    tmp50 = tmp48 + tmp49;
		    tmp55 = tmp49 - tmp48;
		    tmp46 = K707106781 * (tmp44 - tmp45);
		    tmp47 = tmp46 - tmp40;
		    tmp57 = tmp46 + tmp40;
		    tmp35 = (K923879532 * tmp33) - (K382683432 * tmp34);
		    tmp41 = (K923879532 * tmp20) + (K382683432 * tmp40);
		    tmp42 = tmp35 + tmp41;
		    tmp58 = tmp35 - tmp41;
	       }
	       {
		    fftw_real tmp15;
		    fftw_real tmp43;
		    fftw_real tmp51;
		    fftw_real tmp52;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp15 = c_re(W[8]);
		    tmp43 = c_im(W[8]);
		    X[9 * iostride] = (tmp15 * (tmp32 - tmp42)) + (tmp43 * (tmp47 - tmp50));
		    tmp51 = c_re(W[0]);
		    tmp52 = c_im(W[0]);
		    X[iostride] = (tmp51 * (tmp32 + tmp42)) + (tmp52 * (tmp47 + tmp50));
	       }
	       {
		    fftw_real tmp53;
		    fftw_real tmp56;
		    fftw_real tmp59;
		    fftw_real tmp60;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp53 = c_re(W[12]);
		    tmp56 = c_im(W[12]);
		    X[13 * iostride] = (tmp53 * (tmp54 - tmp55)) - (tmp56 * (tmp57 + tmp58));
		    tmp59 = c_im(W[4]);
		    tmp60 = c_re(W[4]);
		    X[5 * iostride] = (tmp59 * (tmp58 - tmp57)) + (tmp60 * (tmp54 + tmp55));
	       }
	  }
     }
}

static const int twiddle_order[] =
{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
fftw_codelet_desc fftw_hc2hc_backward_16_desc =
{
     "fftw_hc2hc_backward_16",
     (void (*)()) fftw_hc2hc_backward_16,
     16,
     FFTW_BACKWARD,
     FFTW_HC2HC,
     267,
     15,
     twiddle_order,
};
