/* cp_main.c = main file for the program called "CirclePack", Version 3.1
Copyright Kenneth Stephenson, 1992, 1993, 1994, 1995 all rights reserved. 
May be distributed with permission.

Related files are:
	headers: 
		cp_head.h = general header file, global variables, XView, etc. 
		complex_math.h = complex arith and transformations header
		eucl_math.h = eucl geometry header
		hyp_math.h = hyp geometry header
		sph_math.h = sph geometry header
		cp_util.h = graphics header
		cp_remote.h = for writing remote routines
	program files:
		cp_main.c = main
		cp_cmd.c = to parse/exec commands
		cp_action.c = actions called by notifier
		cp_comb.c = manipulations of simplicial complex 
		cp_io.c = input/output routines
		cp_comps.c = general computation routines (most hyperbolic)
		cp_format.c = formating of window environ
		cp_screen.c = screen handling
		cp_special.c = tailored routines for "special" button
		cp_string.c = string manip and parsing routines
		cp_remote.c = setup, talk to remote routines
		cp_repack.c = repack routines
		cp_geom.c = geometric comp routines
	Utility programs:
		complex_math.c
		eucl_math.c
		hyp_math.c
		sph_math.c
		cp_util.c
		cp_remote_library.c = subroutines for remote routines
	Misc files:
		cp_help.info = text help file, including "Help" button
		.packrc = configuration file for user choices
		remote_shell.c = shell for writing remote routines
*/

#include "cp_head.h"
#include <pwd.h>
#include <unistd.h>

Rect rect;

int canv_size;
	
main(argc,argv)
int argc;
char *argv[];
{
	int i,j,k,sflag=0;
	char *filename;
	extern void base_resize_proc();
	uid_t myuid;
	struct passwd *mypassdata;	
	
	xv_init(XV_INIT_ARGC_PTR_ARGV,&argc,argv,NULL);
		/* xv_init allows xview to pick off its cmd-line args */
	
/* copyright notice */

	printf("\n\n                   CirclePack, Version 4.0.1, \n\n");
	printf("                   Copyright 1992 -- 1998\n\n");
	printf("Kenneth Stephenson, University of Tennessee, ");
	printf("Knoxville, kens@math.utk.edu\n\n");

/* some global variable initializations */

	myuid=getuid();
	mypassdata=getpwuid(myuid); /* get .pw_dir=home directory */
	home_dir=mypassdata->pw_dir;
	getcwd(buf,BUFSIZE);
	working_dir=(char *)malloc((strlen(buf)+2)*sizeof(char));
	strcpy(working_dir,buf);
	strcpy(emsgbuf,"**ERROR** "); /* prefix for errors */
	msgbuf=emsgbuf+10; /* messages */
	sc_print_size=7; /* default size for canvas dumps */
	degPI=180.0/M_PI;
	eucl_factor=0.5;
	inc_factor=1.0717735; /* 10th root of 2 (equates to 10%) */
	current_p=0;
	draw_speed=1;
	iterates=2;
	totalpasses=500;
	toler=0.0000001;	
	okerr=0.000000001;
	std_real_box.lx=std_real_box.ly=-1.1;
	std_real_box.rx=std_real_box.ry=1.1;
	canv_size=CANV_SIZE;
	line_cmds_only=0;
	line_thick=1;
	fill_mode=0;
	custom_status=0;
	pathlength=cmd_search_depth=0;
	pathlist=newpath=NULL;
	next_script_cmd=NULL;
	stipple_bits[0]=(char)0xAA;stipple_bits[1]=(char)0xAA;
	stipple_bits[2]=(char)0x55;stipple_bits[3]=(char)0x55;
	reset_Mob();
	rand_next=5; /* random number holder -- should put seed call here */
	b_flip=r_flip=NULL;
	num_plot=40;
	sph_pic=(Pixmap)NULL;

/* build frames and initialize XLib stuff */

	printf("Initialization in progress\n");
	frame_builder();/* builds XView frames */

/* other initializations */
	
	panel_set_value(dir_name_item,"packings/"); /* directory name for
		reading and writing files; default = current */
	set_packing_path();
	panel_set_value(print_com_item,"lpr -h "); /* set print command */
	panel_set_value(ps_file_item,"pack_post.ps"); /* postscript filename 
		for screen printing */
	panel_set_value(print_file_item,"sel_post.ps"); /* postscript filename 
		for custom printing */
	ScrX=0;ScrY=DisplayHeight(display,DefaultScreen(display))-600;
	i=DefaultScreen(display);
	Aspect=1.0; /* may need to compute based on screen */

/* read `.packrc' file to specify user default quantities */

        read_packrc(".packrc");

/* allocate space for pack data */

	if ((packdata=(struct p_data *)
		calloc((size_t)(NUM_PACKS+1),sizeof(struct p_data)))==NULL)
	 {
		printf("Memory allocation problems.\n");
		exit(1);
	 }

/* initialize some pack and screen data, window locations, etc. */

	for (i=0;i<NUM_PACKS;i++)
	 {
		packdata[i].sizelimit=5000;
		packdata[i].screen=screendata+i;
		sprintf(packlabels[i],
		 "Pack %d: empty             ",
		 i);
		live_face[i]=live_node[i]=1;
				
		screendata[i].box=std_real_box; 
		screendata[i].pix_box.lx=screendata[i].pix_box.ly;
		screendata[i].pix_box.rx=screendata[i].pix_box.ry=canv_size;
		xv_set(canvas_frame[i],
			XV_HEIGHT,canv_size,XV_WIDTH,canv_size,
			WIN_X,25+i*25+(canv_size+10)*(int)(i%2),
			WIN_Y,80+12*(int)(i>1),
			0); 
		screendata[i].factor=1.0;
			/* set default view matrices */
		for (k=0;k<3;k++) 		 {
			for (j=0;j<3;j++)
			   screendata[i].disp_trans[k][j]=
				screendata[i].disp_inv_trans[k][j]=0.0;
			screendata[i].disp_trans[k][k]=
				screendata[i].disp_inv_trans[k][k]=1.0;
		 }
		sprintf(buf,"set_sphere_view -p%d -d",i);
		handle_cmd(buf);
		screendata[i].coord_flag=0;
		screendata[i].display_opt=0;
		screendata[i].ms_flag=0;
	 }
	for (i=0;i<NUM_PACKS;i++) 
		if (!alloc_pack_space(&packdata[i],5000,0))
		 { printf("Memory allocation problems.\n");exit(1);}

	for (i=0;i<NUM_PROC;i++) 
		remote[i].notify_client=(Notify_client)(100+i);
	set_pack_labels();
	rect.r_top=ScrY;rect.r_left=ScrX;rect.r_width=630;rect.r_height=150;
	xv_set(base_frame,
		WIN_X,(int)rect.r_left,
		WIN_Y,(int)rect.r_top,
/*		XV_WIDTH,(int)rect.r_width,
		XV_HEIGHT,(int)rect.r_height,
*/		0);

/*	frame_set_rect(base_frame,&rect);*/ 
	rect.r_top+=175;rect.r_width=630;rect.r_height=35;
	xv_set(cmd_frame,
		WIN_X,(int)rect.r_left,
		WIN_Y,(int)rect.r_top,
		XV_WIDTH,(int)rect.r_width,
		XV_HEIGHT,(int)rect.r_height,
		0);
/*	frame_set_rect(cmd_frame,&rect);*/
	rect.r_top+=40;rect.r_height=130;
	frame_set_rect(msg_frame,&rect);
	rect.r_top=ScrY;rect.r_left=ScrX+630;rect.r_width=400;
		rect.r_height=337;
	frame_set_rect(text_frame,&rect);

/* a command line argument is taken as 'script' filename. */

	if (argc>1)
	 {
		sflag=1;
		filename=(char *)malloc(128);
		xv_set(script_sw,TEXTSW_FILE,argv[1],0);
		sprintf(filename,"Script Window - ");
		if (textsw_append_file_name(script_sw,filename)!=0)
			strcat(filename,"(NONE)\0");
		xv_set(script_frame,XV_LABEL,filename,0);
		free(filename);
		xv_set(script_frame,WIN_SHOW,TRUE,0);
	 }
	cmd_up(0); /* show command/message frames */
	if (sflag)
	 {
		notify_dispatch();
		strcpy(msgbuf,"*** Script ready in `Script Window' ***\nPress button 'Execute next cmd' to execute prepared commands.");
		msg();
		XFlush(display);
	 }
	else
	 {
		notify_dispatch();
		strcpy(msgbuf,"*** New user? Type 'script demo.cmd' on `Command:' line to run a prepared script.");
		msg();
	 	XFlush(display);
	 }

/* enter main notifier loop to get desired actions from input devices */

	xv_set(base_frame,WIN_EVENT_PROC,base_resize_proc);
	window_main_loop(base_frame); 
	puts("CirclePack exited normally.");
	exit(0);
} /* main */

read_packrc(name)
char *name;
{
	FILE *fp;
	char *keyword,*next,*ptr;
	int cs;
	float aspect;
	int i;

/* read `.packrc' file to specify user default quantities */

	if ((fp=fopen(name,"r"))!=NULL)
	 {
	   keyword=(char *)malloc(256);
	   next=(char *)malloc(256);
	   while (fgets(keyword,255,fp)!=NULL)
	    {
	      stripsp(keyword);
	      if( *keyword!='#' && *keyword!='\n' && *keyword!='\0')
	       {
		ptr=keyword;
		grab_next(&ptr,next);	
	/* directory name for reading and writing files */
		if (!strncmp(next,"CP_PATH",7) 
		   && grab_next(&ptr,next) && (strcspn(next,"#")>0) )
		 {
			panel_set_value(dir_name_item,next); 
			set_packing_path();
		 }
	/* postscript file */
		else if (!strncmp(next,"PS_FILE",7) 
		   && grab_next(&ptr,next) && (strcspn(next,"#")>0) )
			panel_set_value(ps_file_item,next);
	/* custom postscript file */
		else if (!strncmp(next,"CUSTOM_FILE",11) 
		   && grab_next(&ptr,next) && (strcspn(next,"#")>0) )
			panel_set_value(print_file_item,next);
	/* aspect ratio */
		else if (!strncmp(next,"ASPECT_RATIO",12)
		   && grab_next(&ptr,next) && sscanf(next,"%lf",&aspect)==1)
			Aspect=aspect;	
	/* canvas size */
		else if (!strncmp(next,"CANV_SIZE",9)
		   && grab_next(&ptr,next) && sscanf(next,"%d",&cs)==1)
			canv_size=cs;		
	/* print command */
		else if (!strncmp(next,"PRINT_CMD",9))
		 {
			i=strcspn(ptr,"#\t\r\0\n");
			strncpy(next,ptr,i); next[i]='\0'; stripsp(next);
			panel_set_value(print_com_item,next);
		 }
		else if (!strncmp(next,"SCREEN_X_Y",10)
		   && grab_next(&ptr,next) && sscanf(next,"%d",&ScrX)
		   && grab_next(&ptr,next) && sscanf(next,"%d",&i) )
		 {
			if (ScrX<0 || ScrX>800) ScrX=0;
			if (i>=0 && i<900) ScrY=i;
		 }			
	       } 
	    } /* end of while */
	   free(keyword);
	   free(next);
	   fclose(fp);
	 }
} /* read_packrc */


