// $Header: /home/abyss/prj/tcl_interf/RCS/utils.cc,v 1.5 1998/10/25 23:32:46 cthulhu Exp $

#include "utils.hh"

void
    err_print(char *message) {
        
        cerr << message << '\n';
        exit(1);
    }

void 
    err_print(char *message, int i) {
        
        cerr << message  << i << '\n';
        exit(1);
    }

void 
    err_print(char *message, char *st) {
        
        cerr << message << st << '\n';
        exit(1);
    }

void 
    err_print(char *message, char c) {
        
        cerr << message << " " << c << '\n';
        exit(1);
    }

char *strnsave(char *st, int n) {
    char *result;

    if (st == NULL) return(NULL);

    result = new char[n];
    memcpy(result,st,n);
    return(result);

}

char *strsave(char *st) {
    char *result;

    if (st == NULL) return(NULL);

    result = new char[strlen(st)+1];
    strcpy(result,st);
    return(result);
}


#define MBIG 1000000000
#define MSEED 161803398
#define MZ 0
#define FAC (1.0/MBIG)

static int seed = -1;

float ran3(int &idum)
{
	static int inext,inextp;
	static long ma[56];
	static int iff=0;
	long mj,mk;
	int i,ii,k;

	if (idum < 0 || iff == 0) {
		iff=1;
		mj=MSEED-(idum < 0 ? -idum : idum);
		mj %= MBIG;
		ma[55]=mj;
		mk=1;
		for (i=1;i<=54;i++) {
			ii=(21*i) % 55;
			ma[ii]=mk;
			mk=mj-mk;
			if (mk < MZ) mk += MBIG;
			mj=ma[ii];
		}
		for (k=1;k<=4;k++)
			for (i=1;i<=55;i++) {
				ma[i] -= ma[1+(i+30) % 55];
				if (ma[i] < MZ) ma[i] += MBIG;
			}
		inext=0;
		inextp=31;
		idum=1;
	}
	if (++inext == 56) inext=1;
	if (++inextp == 56) inextp=1;
	mj=ma[inext]-ma[inextp];
	if (mj < MZ) mj += MBIG;
	ma[inext]=mj;
	return mj*FAC;
}

int iran(int limit) {
  return((int) floor(limit*ran3(seed)));
}

float ran() {
  return(ran3(seed));
}

void sran(int is) {
    seed = is;
}

#undef MBIG
#undef MSEED
#undef MZ
#undef FAC



// $Log: utils.cc,v $
// Revision 1.5  1998/10/25 23:32:46  cthulhu
// Removed header.
//
// Revision 1.4  1996/02/16 18:04:16  aml
// Fixed a memory bug in formula copy with purify.
// Fixed a few minor bugs. Functional, stable version.
//
// Revision 1.3  1996/02/16 17:56:46  aml
// None
//
// Revision 1.2  1996/01/27 23:10:39  aml
// CellCopy created.
// CellGet fixed.
// Tcl range operators created.
// User interface improved. Cell references and ranges
// can now be defined with the mouse.
//
// Revision 1.1  1996/01/24  16:26:23  aml
// Initial revision
//
// Revision 1.1  1994/09/08  00:02:38  aml
// Initial revision
//
