// $Id: checkargs.cc,v 1.7 1998/10/07 22:02:18 cthulhu Exp $

#include "checkargs.hh"

int checkint(char *aux)
{
  int res;
  
  if(((res=strtol(aux,(char **) NULL,10))!=LONG_MIN)&&(res!=LONG_MAX))
    return(res);
  return(-255);
}

double checkdouble(char *aux)
{
  double res;
  
  if(((res=strtod(aux,(char **) NULL))!=+HUGE_VAL)&&(res!=-HUGE_VAL))
    return(res);
  return(-255);
}

int checkintrange(char *aux,int min,int max)
{
  int res;
  
  if(((res=strtol(aux,(char **) NULL,10))!=LONG_MIN)&&(res!=LONG_MAX))
    return(((res<=max)&&(res>=min)) ? res : -1);
  return(-255);
}

#define checkcoordx(coord) checkintrange(coord,-1,DEFSHEETWIDTH)
#define checkcoordy(coord) checkintrange(coord,-1,DEFSHEETHEIGHT)

int checkintenum(char *aux,int numargs,...)
{
  va_list ap;
  int res,arg;
  
  if(((res=strtol(aux,(char **) NULL,10))!=LONG_MIN)&&(res!=LONG_MAX))
    {
      va_start(ap,numargs);
      while(--numargs>=0)
	{
	  arg=va_arg(ap,int);
	  if(res==arg)
	    {
	      va_end(ap);
	      return(res);
	    }
	}
      va_end(ap);
      return(-255);
    }
  else
    return(-255);
}

int checksheetname(char *name)
{
  if(SheetFromName(name)==NULL)
    return(-255);
  return(0);
}

int checkargc(int argc, FuncName func)
{
  switch(func)
    {
    case(F_CELL_BORDERS):
    case(F_PAGE_BORDERS):
    case(F_TOGGLE_DISPLAY_BORDERS):
    case(F_TOGGLE_PAGE_BORDERS):
    case(F_COL_NAME):
    case(F_NEW_SHEET):
    case(F_SHEET_RECALC):
    case(F_GET_AUTOMATIC_RECALC):
    case(F_SHEET_EXISTS):
    case(F_SHEET_EMPTY):
    case(F_SHEET_MODIFIED):
    case(F_REDRAW_SHEET):
    case(F_DELETE_SHEET):
    case(F_GET_PRINT_RANGE):
    case(F_GET_PRINT_PARAMS):
    case(F_USED_GRAPHS):
    case(F_SET_ACTIVE_SHEET):
    case(F_SHEET_X_ORIGIN):
    case(F_SHEET_Y_ORIGIN):
    case(F_RESET_SCROLL):
      if(argc==2) return 0; else return -1;
      break;
    case(F_RUN_SCRIPT):
    case(F_UNDO_REDO):
    case(F_CELL_NAME):
    case(F_PARSE_RANGE):
    case(F_LOAD_SHEET):
    case(F_RECALCULATE_BEFORE_SAVING):
    case(F_SET_AUTOMATIC_RECALC):
    case(F_CHANGE_SHEET_NAME):
    case(F_GET_GRAPH_PARAMS):
    case(F_CELL_COL):
    case(F_CELL_ROW):
    case(F_SET_BORDER_ITEM_ID):
    case(F_GET_COL_WIDTH):
    case(F_GET_ROW_HEIGHT):
    case(F_COL_ORIGIN):
    case(F_ROW_ORIGIN):
    case(F_MAX_TEXT_WIDTH):
      if(argc==3) return 0; else return -1;
      break;
    case(F_SET_NEW_CANVAS_SIZE):
    case(F_NEED_TO_SCROLL):
    case(F_CELL_VALUE):
    case(F_CELL_GET_NUMBER):
    case(F_CELL_GET):
    case(F_GET_FORMAT):
    case(F_RANGE_MOVE):
    case(F_FIND_GRAPH):
    case(F_SET_COL_WIDTH):
    case(F_SET_ROW_HEIGHT):
    case(F_SCROLL):
      if(argc==4) return 0; else return -1;
      break;
    case(F_CELL_SET):
      if(argc==5) return 0; else return -1;
      break;
    case(F_DELETE_ROW_OR_COLUMN):
    case(F_INSERT_ROW_OR_COLUMN):
      if(argc==6) return 0; else return -1;
      break;
    case(F_CELL_COPY):
    case(F_SET_PRINT_RANGE):
      if(argc==7) return 0; else return -1;
      break;
    case(F_SORT_CELLS):
    case(F_CHANGE_GRAPH_PARAMS):
      if(argc==9) return 0; else return -1;
      break;
    case(F_RANGE_COPY):
      if(argc==11) return 0; else return -1;
      break;
    case(F_SET_PRINT_PARAMS):
      if(argc==12) return 0; else return -1;
      break;
    case(F_SET_GRAPH_PARAMS):
      if(argc==13) return 0; else return -1;
      break;
    case(F_DELETE_GRAPH):
    case(F_SAVE_SHEET):
    case(F_SCROLL_FRACTION):
      if((argc==3)||(argc==4)) return 0; else return -1;
      break;
    case(F_RANGE_KILL):
    case(F_COPY_TO_PASTE_BUFFER):
      if((argc==4)||(argc==6)) return 0; else return -1;
      break;
    case(F_SET_ALIGNMENT):
    case(F_SET_FILL):
    case(F_SET_FORMAT):
      if((argc==5)||(argc==7)) return 0; else return -1;
      break;
    case(F_PASTE):
      if((argc==6)||(argc==8)) return 0; else return -1;
      break;
    case(F_FIND):
      if((argc==8)||(argc==9)) return 0; else return -1;
      break;
    case(F_SET_BORDERS):
      if((argc==8)||(argc==10)) return 0; else return -1;
      break;
    case(F_SET_FONT):
      if((argc==9)||(argc==12)) return 0; else return -1;
      break;
    case(F_DEF_CELL_HEIGHT):
    case(F_DEF_CELL_WIDTH):
    case(F_DEF_SHEET_WIDTH):
    case(F_DEF_SHEET_HEIGHT):
    case(F_DEF_WIDTH_IN_CELLS):
    case(F_DEF_HEIGHT_IN_CELLS):
    default:
      internal_error();
    }
}

char *CheckArgs(int argc, char **argv, FuncName func)
{
  int x1,x2,y1,y2,aux1,aux2;

  if(checkargc(argc,func)==-1)
    return("Wrong number of arguments");
  switch(func)
    {
    case(F_NEW_SHEET):
      break;
    case(F_RUN_SCRIPT):
    case(F_CELL_BORDERS):
    case(F_PAGE_BORDERS):
    case(F_TOGGLE_DISPLAY_BORDERS):
    case(F_TOGGLE_PAGE_BORDERS):
    case(F_SAVE_SHEET):
    case(F_LOAD_SHEET):
    case(F_SHEET_RECALC):
    case(F_GET_AUTOMATIC_RECALC):
    case(F_CHANGE_SHEET_NAME):
    case(F_SHEET_EXISTS):
    case(F_SHEET_EMPTY):
    case(F_SHEET_MODIFIED):
    case(F_REDRAW_SHEET):
    case(F_DELETE_SHEET):
    case(F_GET_PRINT_RANGE):
    case(F_GET_PRINT_PARAMS):
    case(F_USED_GRAPHS):
    case(F_SET_ACTIVE_SHEET):
    case(F_SHEET_X_ORIGIN):
    case(F_SHEET_Y_ORIGIN):
    case(F_RESET_SCROLL):
      if(checksheetname(argv[1])==-255) return("Unknown sheet");
      break;
    case(F_UNDO_REDO):
    case(F_RECALCULATE_BEFORE_SAVING):
      if(checksheetname(argv[1])==-255) return("Unknown sheet");
      if(checkintrange(argv[2],0,1)==-255)
	return("Invalid argument or argument out of range");
      break;
    case(F_SORT_CELLS):
      if(checksheetname(argv[1])==-255) return("Unknown sheet");
      if((x1=checkcoordx(argv[2]))==-255)
	return("Invalid argument or argument out of range");
      if((y1=checkcoordy(argv[3]))==-255)
	return("Invalid argument or argument out of range");
      if((x2=checkcoordx(argv[4]))==-255)
	return("Invalid argument or argument out of range");
      if((y2=checkcoordy(argv[5]))==-255)
	return("Invalid argument or argument out of range");
      if(checkintrange(argv[6],0,1)==-255)
	return("Invalid argument or argument out of range");
      if((aux1=checkintrange(argv[7],0,1))==-255)
	return("Invalid argument or argument out of range");
      if((aux2=checkint(argv[8]))==-255) 
	return("Invalid argument or argument out of range");
      else
	{
	  if((aux1==0)&&(aux2>(x2-x1)))
	    return("Invalid argument or argument out of range");
	  if((aux1==1)&&(aux2>(y2-y1)))
	    return("Invalid argument or argument out of range");
	}
      break;
    case(F_CELL_SET):
    case(F_CELL_VALUE):
    case(F_CELL_GET):
    case(F_CELL_GET_NUMBER):
    case(F_GET_FORMAT):
    case(F_RANGE_MOVE):
    case(F_NEED_TO_SCROLL):
    case(F_SCROLL):
      if(checksheetname(argv[1])==-255) return("Unknown sheet");
      if(checkcoordx(argv[2])==-255)
	return("Invalid argument or argument out of range");
      if(checkcoordy(argv[3])==-255)
	return("Invalid argument or argument out of range");
      break;
    case(F_CELL_COPY):
      if(checksheetname(argv[1])==-255) return("Unknown sheet");
      if(checkcoordx(argv[2])==-255)
	return("Invalid argument or argument out of range");
      if(checkcoordy(argv[3])==-255)
	return("Invalid argument or argument out of range");
      if(checksheetname(argv[4])==-255) return("Unknown sheet");
      if(checkcoordx(argv[5])==-255)
	return("Invalid argument or argument out of range");
      if(checkcoordy(argv[6])==-255)
	return("Invalid argument or argument out of range");
      break;
    case(F_SET_FONT):
      if(checksheetname(argv[1])==-255) return("Unknown sheet");
      if(checkintrange(argv[2],0,3)==-255)
	return("Invalid argument or argument out of range");
      if(checkintrange(argv[3],0,5)==-255)
	return("Invalid argument or argument out of range");
      if(checkintrange(argv[4],0,1)==-255)
	return("Invalid argument or argument out of range");
      if(checkintrange(argv[5],0,1)==-255)
	return("Invalid argument or argument out of range");
      if(argc==9)
	{
	  if(checkcoordx(argv[6])==-255)
	    return("Invalid argument or argument out of range");
	  if(checkcoordy(argv[7])==-255)
	    return("Invalid argument or argument out of range");
	  if(checkint(argv[8])==-255)
	    return("Invalid argument or argument out of range");
	}
      else
	{
	  if(checkcoordx(argv[6])==-255)
	    return("Invalid argument or argument out of range");
	  if(checkcoordy(argv[7])==-255)
	    return("Invalid argument or argument out of range");
	  if(checkcoordx(argv[8])==-255)
	    return("Invalid argument or argument out of range");
	  if(checkcoordy(argv[9])==-255)
	    return("Invalid argument or argument out of range");
	  if(checkintrange(argv[10],0,1)==-255)
	    return("Invalid argument or argument out of range");
	  if(checkintrange(argv[10],0,10)==-255)
	    return("Invalid argument or argument out of range");
	}
      break;
    case(F_SET_FILL):
      if(checksheetname(argv[1])==-255) return("Unknown sheet");
      if(checkintrange(argv[2],0,100)==-255)
	return("Invalid argument or argument out of range");
      if(checkcoordx(argv[3])==-255)
	return("Invalid argument or argument out of range");
      if(checkcoordy(argv[4])==-255)
	return("Invalid argument or argument out of range");
      if(argc==7)
	{
	  if(checkcoordx(argv[5])==-255)
	    return("Invalid argument or argument out of range");
	  if(checkcoordy(argv[6])==-255)
	    return("Invalid argument or argument out of range");
	}
      break;
    case(F_SET_ALIGNMENT):
      if(checksheetname(argv[1])==-255) return("Unknown sheet");
      if(checkintrange(argv[2],0,3)==-255)
	return("Invalid argument or argument out of range");
      if(checkcoordx(argv[3])==-255)
	return("Invalid argument or argument out of range");
      if(checkcoordy(argv[4])==-255)
	return("Invalid argument or argument out of range");
      if(argc==7)
	{
	  if(checkcoordx(argv[5])==-255)
	    return("Invalid argument or argument out of range");
	  if(checkcoordy(argv[6])==-255)
	    return("Invalid argument or argument out of range");
	}
      break;
    case(F_SET_FORMAT):
      if(checksheetname(argv[1])==-255) return("Unknown sheet");
      if(checkint(argv[2])==-255)
	return("Invalid argument or argument out of range");
      if(checkcoordx(argv[3])==-255)
	return("Invalid argument or argument out of range");
      if(checkcoordy(argv[4])==-255)
	return("Invalid argument or argument out of range");
      if(argc==7)
	{
	  if(checkcoordx(argv[5])==-255)
	    return("Invalid argument or argument out of range");
	  if(checkcoordy(argv[6])==-255)
	    return("Invalid argument or argument out of range");
	}
      break;
    case(F_SET_BORDERS):
      if(checksheetname(argv[1])==-255) return("Unknown sheet");
      if(checkintenum(argv[2],6,0,1,2,3,5,7)==-255)
	return("Invalid argument or argument out of range");
      if(checkintenum(argv[3],6,0,1,2,3,5,7)==-255)
	return("Invalid argument or argument out of range");
      if(checkintenum(argv[4],6,0,1,2,3,5,7)==-255)
	return("Invalid argument or argument out of range");
      if(checkintenum(argv[5],6,0,1,2,3,5,7)==-255)
	return("Invalid argument or argument out of range");
      if(checkcoordx(argv[6])==-255)
	return("Invalid argument or argument out of range");
      if(checkcoordy(argv[7])==-255)
	return("Invalid argument or argument out of range");
      if(argc==10)
	{
	  if(checkcoordx(argv[8])==-255)
	    return("Invalid argument or argument out of range");
	  if(checkcoordy(argv[9])==-255)
	    return("Invalid argument or argument out of range");
	}
      break;
    case(F_RANGE_COPY):
      if(checksheetname(argv[1])==-255) return("Unknown sheet");
      if(checkcoordx(argv[2])==-255)
	return("Invalid argument or argument out of range");
      if(checkcoordy(argv[3])==-255)
	return("Invalid argument or argument out of range");
      if(checkcoordx(argv[4])==-255)
	return("Invalid argument or argument out of range");
      if(checkcoordy(argv[5])==-255)
	return("Invalid argument or argument out of range");
      if(checksheetname(argv[6])==-255) return("Unknown sheet");
      if(checkcoordx(argv[7])==-255)
	return("Invalid argument or argument out of range");
      if(checkcoordy(argv[8])==-255)
	return("Invalid argument or argument out of range");
      if(checkcoordx(argv[9])==-255)
	return("Invalid argument or argument out of range");
      if(checkcoordy(argv[10])==-255)
	return("Invalid argument or argument out of range");
      break;
    case(F_RANGE_KILL):
    case(F_COPY_TO_PASTE_BUFFER):
      if(checksheetname(argv[1])==-255) return("Unknown sheet");
      if(checkcoordx(argv[2])==-255)
	return("Invalid argument or argument out of range");
      if(checkcoordy(argv[3])==-255)
	return("Invalid argument or argument out of range");
      if(argc==6)
	{
	  if(checkcoordx(argv[4])==-255)
	    return("Invalid argument or argument out of range");
	  if(checkcoordy(argv[5])==-255)
	    return("Invalid argument or argument out of range");
	}
       break;
    case(F_FIND):
      if(checksheetname(argv[1])==-255) return("Unknown sheet");
      if(checkintrange(argv[3],0,1)==-255)
	return("Invalid argument or argument out of range");
      if(checkintrange(argv[4],0,1)==-255)
	return("Invalid argument or argument out of range");
      if(checkintrange(argv[5],0,1)==-255)
	return("Invalid argument or argument out of range");
      if(checkintrange(argv[6],0,1)==-255)
	return("Invalid argument or argument out of range");
      if(checkintrange(argv[7],-1,1)==-255)
	return("Invalid argument or argument out of range");
      break;
    case(F_CELL_NAME):
    case(F_PARSE_RANGE):
      if(checkcoordx(argv[1])==-255)
	return("Invalid argument or argument out of range");
      if(checkcoordy(argv[2])==-255)
	return("Invalid argument or argument out of range");
      break;
    case(F_SET_AUTOMATIC_RECALC):
      if(checksheetname(argv[1])==-255) return("Unknown sheet");
      if(checkintenum(argv[2],2,0,255)==-255)
	return("Invalid argument or argument out of range");
      break;
    case(F_SET_PRINT_RANGE):
      if(checksheetname(argv[1])==-255) return("Unknown sheet");
      if(checkintrange(argv[2],1,2)==-255)
	return("Invalid argument or argument out of range");
      if(checkcoordx(argv[3])==-255)
	return("Invalid argument or argument out of range");
      if(checkcoordy(argv[4])==-255)
	return("Invalid argument or argument out of range");
      if(checkcoordx(argv[5])==-255)
	return("Invalid argument or argument out of range");
      if(checkcoordy(argv[6])==-255)
	return("Invalid argument or argument out of range");
      break;
    case(F_SET_PRINT_PARAMS):
      if(checksheetname(argv[1])==-255) return("Unknown sheet");
      if(checkdouble(argv[2])==-255)
	return("Invalid argument or argument out of range");
      if(checkdouble(argv[3])==-255)
	return("Invalid argument or argument out of range");
      if(checkdouble(argv[4])==-255)
	return("Invalid argument or argument out of range");
      if(checkdouble(argv[5])==-255)
	return("Invalid argument or argument out of range");
      if(checkdouble(argv[6])==-255)
	return("Invalid argument or argument out of range");
      if((*argv[7]!='m')&&(*argv[7]!='g')&&(*argv[7]!='c'))
	return("Invalid argument or argument out of range");
      if(checkintrange(argv[8],0,1)==-255)
	return("Invalid argument or argument out of range");
      if(checkint(argv[9])==-255)
	return("Invalid argument or argument out of range");
      if(checkint(argv[10])==-255)
	return("Invalid argument or argument out of range");
      if((*argv[11]!='A')&&(*argv[11]!='U'))
	return("Invalid argument or argument out of range");
      break;
    case(F_SET_GRAPH_PARAMS):
      if(checksheetname(argv[1])==-255) return("Unknown sheet");
      if(checkint(argv[2])==-255)
	return("Invalid argument or argument out of range");
      if(checkcoordx(argv[3])==-255)
	return("Invalid argument or argument out of range");
      if(checkcoordy(argv[4])==-255)
	return("Invalid argument or argument out of range");
      if(checkcoordx(argv[5])==-255)
	return("Invalid argument or argument out of range");
      if(checkcoordy(argv[6])==-255)
	return("Invalid argument or argument out of range");
      if(checkint(argv[7])==-255)
	return("Invalid argument or argument out of range");
      if(checkint(argv[8])==-255)
	return("Invalid argument or argument out of range");
      if(checkint(argv[9])==-255)
	return("Invalid argument or argument out of range");
      if(checkint(argv[10])==-255)
	return("Invalid argument or argument out of range");
      if(checkcoordx(argv[11])==-255)
	return("Invalid argument or argument out of range");
      if(checkcoordy(argv[12])==-255)
	return("Invalid argument or argument out of range");
      break;
    case(F_CHANGE_GRAPH_PARAMS):
      if(checksheetname(argv[1])==-255) return("Unknown sheet");
      if(checkint(argv[2])==-255)
	return("Invalid argument or argument out of range");
      if(checkint(argv[3])==-255)
	return("Invalid argument or argument out of range");
      if(checkint(argv[4])==-255)
	return("Invalid argument or argument out of range");
      if(checkint(argv[5])==-255)
	return("Invalid argument or argument out of range");
      if(checkint(argv[6])==-255)
	return("Invalid argument or argument out of range");
      if(checkcoordx(argv[7])==-255)
	return("Invalid argument or argument out of range");
      if(checkcoordy(argv[8])==-255)
	return("Invalid argument or argument out of range");
      break;
    case(F_GET_GRAPH_PARAMS):
    case(F_CELL_COL):
    case(F_CELL_ROW):
    case(F_SET_BORDER_ITEM_ID):
      if(checksheetname(argv[1])==-255) return("Unknown sheet");
      if(checkint(argv[2])==-255)
	return("Invalid argument or argument out of range");
      break;
    case(F_FIND_GRAPH):
    case(F_SET_NEW_CANVAS_SIZE):
      if(checksheetname(argv[1])==-255) return("Unknown sheet");
      if(checkint(argv[2])==-255)
	return("Invalid argument or argument out of range");
      if(checkint(argv[3])==-255)
	return("Invalid argument or argument out of range");
      break;
    case(F_SET_COL_WIDTH):
      if(checksheetname(argv[1])==-255) return("Unknown sheet");
      if(checkcoordx(argv[2])==-255)
	return("Invalid argument or argument out of range");
      if(checkintrange(argv[3],0,300)==-255)
	return("Invalid argument or argument out of range");
      break;
    case(F_SET_ROW_HEIGHT):
      if(checksheetname(argv[1])==-255) return("Unknown sheet");
      if(checkcoordy(argv[2])==-255)
	return("Invalid argument or argument out of range");
      if(checkintrange(argv[3],0,300)==-255)
	return("Invalid argument or argument out of range");
      break;
    case(F_INSERT_ROW_OR_COLUMN):
    case(F_DELETE_ROW_OR_COLUMN):
      if(checksheetname(argv[1])==-255) return("Unknown sheet");
      if(checkint(argv[2])==-255)
	return("Invalid argument or argument out of range");
      if(checkint(argv[3])==-255)
	return("Invalid argument or argument out of range");
      if((*argv[4]!='c')&&(*argv[4]!='r'))
	return("Invalid argument or argument out of range");
      if(checkintrange(argv[5],0,1)==-255)
	return("Invalid argument or argument out of range");
      break;
    case(F_MAX_TEXT_WIDTH):
    case(F_GET_COL_WIDTH):
      if(checksheetname(argv[1])==-255) return("Unknown sheet");
      if(checkcoordx(argv[2])==-255)
	return("Invalid argument or argument out of range");
      break;
    case(F_GET_ROW_HEIGHT):
      if(checksheetname(argv[1])==-255) return("Unknown sheet");
      if(checkcoordy(argv[2])==-255)
	return("Invalid argument or argument out of range");
      break;
    case(F_COL_NAME):
      if(checkcoordx(argv[1])==-255)
	return("Invalid argument or argument out of range");
      break;
    case(F_COL_ORIGIN):
      if(checkcoordx(argv[2])==-255)
	return("Invalid argument or argument out of range");
      break;
    case(F_ROW_ORIGIN):
      if(checkcoordy(argv[2])==-255)
	return("Invalid argument or argument out of range");
      break;
    case(F_SCROLL_FRACTION):
      if(checksheetname(argv[1])==-255) return("Unknown sheet");
      if((*argv[2]!='h')&&(*argv[2]!='v')&&(*argv[2]!='l')&&(*argv[2]!='r')
	 &&(*argv[2]!='u')&&(*argv[2]!='d'))
	return("Invalid argument or argument out of range");
      if(argc==4)
	{
	  if(checkdouble(argv[3])==-255)
	    return("Invalid argument or argument out of range");
	}
      break;
    case(F_PASTE):
      if(checksheetname(argv[1])==-255) return("Unknown sheet");
      if(checkcoordx(argv[2])==-255)
	return("Invalid argument or argument out of range");
      if(checkcoordy(argv[3])==-255)
	return("Invalid argument or argument out of range");
      if(argc==6)
	{
	  if((checkintrange(argv[4],0,4))==-255)
	    return("Invalid argument or argument out of range");
	  if((checkintrange(argv[5],0,5))==-255)
	    return("Invalid argument or argument out of range");
	}
      else
	{
	  if(checkcoordx(argv[4])==-255)
	    return("Invalid argument or argument out of range");
	  if(checkcoordy(argv[5])==-255)
	    return("Invalid argument or argument out of range");
	  if((checkintrange(argv[6],0,4))==-255)
	    return("Invalid argument or argument out of range");
	  if((checkintrange(argv[7],0,5))==-255)
	    return("Invalid argument or argument out of range");
	}
      break;
    case(F_DELETE_GRAPH):
      if(checksheetname(argv[1])==-255) return("Unknown sheet");
      if(checkint(argv[2])==-255)
	return("Invalid argument or argument out of range");
      if(argc==4)
	{
	  if(checkint(argv[3])==-255)
	    return("Invalid argument or argument out of range");
	}
      break;
    case(F_DEF_CELL_HEIGHT):
    case(F_DEF_CELL_WIDTH):
    case(F_DEF_SHEET_WIDTH):
    case(F_DEF_SHEET_HEIGHT):
    case(F_DEF_WIDTH_IN_CELLS):
    case(F_DEF_HEIGHT_IN_CELLS):
    default:
      internal_error();
    }
  return(NULL);
}

// $Log: checkargs.cc,v $
// Revision 1.7  1998/10/07 22:02:18  cthulhu
// Paste merged with PasteSpecial.
// Tons of bugfixes...
//
// Revision 1.6  1998/10/06 20:47:39  cthulhu
// SCROLL_FRACTION bugfix.
//
// Revision 1.5  1998/10/06 19:54:45  cthulhu
// Fixed DELETE_GRAPH and SET_GRAPH bugs.
//
// Revision 1.4  1998/10/05 20:27:26  cthulhu
// Fixed SCROLL_FRACTION and MAX_TEXT_WIDTH bugs.
//
// Revision 1.4  1998/10/05 20:22:47  cthulhu
// Fixed MAX_COL_WIDTH and SCROLL_FRACTION bugs.
//
// Revision 1.3  1998/10/01 22:20:02  cthulhu
// Fixed paste special.
//
// Revision 1.2  1998/09/30 00:46:12  cthulhu
// Added paste special.
//
// Revision 1.1  1998/09/29 01:33:31  cthulhu
// Initial revision
//
