// $Id: format.hh,v 1.10 1998/08/06 21:08:43 aml Exp $

#ifndef _FORMAT_DOT_HH_
#define _FORMAT_DOT_HH_

static char *month_names[12] = {"Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"};
 
extern "C" {
#include "tcl.h"
#include "tk.h"
}
#include "utils.hh"

class Fontinfo;

#define DEFAULT_FORMAT 0xf1
#define DEFAULT_FONT_FAMILY 1
#define DEFAULT_FONT_SIZE 2
#define DEFAULT_FONT_BOLD 0
#define DEFAULT_FONT_ITALICS 0
#define DEFAULT_ALIGNMENT 0
#define LEFT_ALIGNMENT 1
#define CENTER_ALIGNMENT 2
#define RIGHT_ALIGNMENT 3
#define DEFAULT_FILL   100
#define DEFAULT_BORDER 0x7
#define NO_ITEM -1



extern Tcl_HashTable font_hash;
char *getFont(Tcl_Interp *interp,Fontinfo &font);



struct Format_code {
  char desc[20];
  char form[20];
};

class Border {
  public:
    unsigned char top;
    unsigned char bottom;
    unsigned char left;
    unsigned char right;
    int top_item;
    int bottom_item;
    int left_item;
    int right_item; 
    char top_item_double, bottom_item_double;
    char left_item_double, right_item_double;
    Border() ;
    operator=(const Border &rig) ;
    Border(const Border &rig) ;

    int isdefault() {
        if (top == DEFAULT_BORDER && bottom == DEFAULT_BORDER 
            && left == DEFAULT_BORDER && right == DEFAULT_BORDER)
            return(1);
        else
            return(0);
    }
};

class Background {
  public:
    unsigned char filllevel;
    unsigned char red;
    unsigned char green;
    unsigned char blue;
    int item;
    Background() ;
    Background(const Background &rig) ;
    void operator=(const Background &rig) ;
    int isdefault() {
        if (filllevel == DEFAULT_FILL)
            return(1);
        else
            return(0);
    }
};


class Fontinfo {
  public:
    unsigned char family;
    unsigned char size;
    unsigned char italics;
    unsigned char bold;
    Fontinfo() {
        family = DEFAULT_FONT_FAMILY;
        size = DEFAULT_FONT_SIZE;
        italics = DEFAULT_FONT_BOLD;
        bold = DEFAULT_FONT_ITALICS;
    }
    int isdefault() {
      if (family == DEFAULT_FONT_FAMILY &&
          size == DEFAULT_FONT_SIZE &&
          italics == DEFAULT_FONT_BOLD &&
          bold == DEFAULT_FONT_ITALICS)
            return(1); 
        else return(0);
    }
};

class Format {
private:
  static int last_timestamp;
public:
   /* used to resolve conflicts when merging formats */
  int timestamp;
  unsigned char form;
  unsigned char alignment;
  Fontinfo font;
  Border borders;
  Background bg;
  void UpdateTimestamp();
  Format();
};

#endif

/*
$Log: format.hh,v $
Revision 1.10  1998/08/06 21:08:43  aml
Released alpha version of Abacus.

Revision 1.9  1996/10/07 12:35:41  aml
First cut at error handling.
Date formats are in.
Fixed problem with blank cell drawing.

//Revision 1.8  1996/09/17  15:16:31  aml
//Fixed problems with copying of cells with non-default formats.
//Created printing formats, alignment formats.
//Format toolbar now reflects format of active cell.
//
Revision 1.7  1996/09/16 18:42:48  aml
Some performance problems addressed by reducing tag use.
Several performance problems remain when heavy use is made
of borders and shading in large spreadsheets.

//Revision 1.6  1996/09/15  19:24:37  aml
//Rulling and shading.
//Optionally hide cell borders.
//Works well, but is very slow for large spreadsheets.
//
//Revision 1.5  1996/09/14  23:56:09  aml
//Created cell shading.
//
//Revision 1.4  1996/09/02  10:51:44  aml
//Cell fonts created, loaded and saved.
//Row height created.
//
//Revision 1.3  1996/07/18  10:19:35  aml
//Created formats for cells.
//Load cell now makes copy of old file.
//
Revision 1.2  1996/04/27 11:15:47  aml
None

Revision 1.1  1996/04/27 11:14:55  aml
Initial revision
*/




