# $Id: canvas.tcl,v 1.36 1998/09/30 00:43:47 cthulhu Exp $
#!/usr/local/bin/wish -f
#
# This file creates a new canvas for a given spreadsheet
#

#proc extWidth {widget} {
#    set r [expr [lindex [$widget config -width] 4] + [lindex [$widget config -bd] 4]]
#    return $r
#}

proc drawActiveColButton {t_canvas col} {
    source [xxl_library]/globalvars.tcl

    .$activeSheet.fr.toprow.labels delete selectedcols$col

    $t_canvas create rect \
	0 4 [GetColWidth $activeSheet $col] [expr [defCellHeight]+2] \
	X $col 0 $col 0  \
	-outline darkgreen -width 2 -tag selectedcols$col -fill grey
    
    set y 5

    set x [ColOrigin $activeSheet $col]

    $t_canvas create text $col 0 X 0 $y -text [format %2s [ColName $col]] \
	-tag selectedcols$col -fill  white
}

proc deleteActiveColButton {col} {
    source [xxl_library]/globalvars.tcl

    .$activeSheet.fr.toprow.labels delete selectedcols$col
}

proc unhighlightColSelection {{reset 1}} {
    source [xxl_library]/globalvars.tcl

    set first [lindex $cols_selected 0]
    set last [lindex $cols_selected 1]
    while {$first < $last } {
	deleteActiveColButton $first
	incr first
    }
    while {$last < $first } {
	deleteActiveColButton $first
	incr first -1
    }
    deleteActiveColButton $first
    if {$reset==1} {
	set cols_selected {}
	.$activeSheet.fr.menubar.menu.edit.menu.insert entryconfigure 2 \
	    -state normal
    }

    .$activeSheet.fr.menubar.menu.format.menu entryconfigure 3 -state normal
    set cols_selected {}

}

proc highlightColSelection {} {
    source [xxl_library]/globalvars.tcl

    set first [lindex $cols_selected 0]
    set last [lindex $cols_selected 1]

    while {$first < $last } {
	drawActiveColButton .$activeSheet.fr.toprow.labels $first
	incr first
    }
    while {$last < $first } {
	drawActiveColButton .$activeSheet.fr.toprow.labels $first
	incr first -1
    }
    drawActiveColButton .$activeSheet.fr.toprow.labels $first
}

proc drawActiveRowButton {t_canvas row} {
    source [xxl_library]/globalvars.tcl

    .$activeSheet.fr.midrow.f.labels delete selectedrows$row

    $t_canvas create rect \
	5 0 35 [GetRowHeight $activeSheet $row] X 0 $row 0 $row \
	-outline darkgreen -width 2 -tag selectedrows$row -fill grey

    set x 3
    $t_canvas create text 0 $row X $x 0 -text [format %4d [expr $row+1]]  \
	-tag selectedrows$row -fill white -anchor w
}

proc deleteActiveRowButton {row} {
    source [xxl_library]/globalvars.tcl

    .$activeSheet.fr.midrow.f.labels delete selectedrows$row
}

proc unhighlightRowSelection {{reset 1}} {
    source [xxl_library]/globalvars.tcl

    set first [lindex $rows_selected 0]
    set last [lindex $rows_selected 1]
    while {$first < $last } {
	deleteActiveRowButton $first
	incr first
    }
    while {$last < $first } {
	deleteActiveRowButton $first
	incr first -1
    }
    deleteActiveRowButton $first
    if {$reset==1} {
	set rows_selected {}
	.$activeSheet.fr.menubar.menu.edit.menu.insert entryconfigure 1 \
	    -state normal
    }

    .$activeSheet.fr.menubar.menu.format.menu entryconfigure 2 -state normal
    set rows_selected {}
}

proc highlightRowSelection {} {
    source [xxl_library]/globalvars.tcl

    set first [lindex $rows_selected 0]
    set last [lindex $rows_selected 1]
    while {$first < $last } {
	drawActiveRowButton .$activeSheet.fr.midrow.f.labels $first
	incr first
    }
    while {$last < $first } {
	drawActiveRowButton .$activeSheet.fr.midrow.f.labels $first
	incr first -1
    }
    drawActiveRowButton .$activeSheet.fr.midrow.f.labels $first
}

proc doColCanvasMotionBindings {col_canvas} {
    source [xxl_library]/globalvars.tcl

    bind $col_canvas <B1-Motion> \
	{
	    set col [CellCol $activeSheet \
			 [expr %x + [SheetXOrigin $activeSheet]]]
	    set first [lindex $cols_selected 0]
	    set last [lindex $cols_selected 1]
	    set aux $col
	    if { $col < $first } {
		while { $last > $first } {
		    deleteActiveColButton $last
		    incr last -1
		}
		while { $last < $col } {
		    deleteActiveColButton $last
		    incr last
		}
		while { $aux < $first } {
		    drawActiveColButton %W $aux
		    incr aux
		}
		set cols_selected [list $first $col]
	    } else {
		while { $last < $first } {
		    deleteActiveColButton $last
		    incr last
		}
		while { $last > $col } {
		    deleteActiveColButton $last
		    incr last -1
		}
		while { $aux > $first } {
		    drawActiveColButton %W $aux
		    incr aux -1
		}
		set cols_selected [list $first $col]
	    }
	    if { $first < $col } {
		set currentRange \
		    [list $first 0 $col [expr [DefSheetHeight] - 1]]
	    } else {
		set currentRange \
		    [list $col 0 $first [expr [DefSheetHeight] - 1]]
	    }
	    highlightCurrentRange [canvasFromSheet $activeSheet]
	}
    bind $col_canvas <ButtonRelease-1> \
	{
	    lsort -increasing $cols_selected
	    bind %col_canvas <B1-Motion> {}
	}
}

proc doRowCanvasMotionBindings {row_canvas} {
    source [xxl_library]/globalvars.tcl

    bind $row_canvas <B1-Motion> \
	{

	    set row [CellRow $activeSheet \
			 [expr %y + [SheetYOrigin $activeSheet]]]
	    set first [lindex $rows_selected 0]
	    set last [lindex $rows_selected 1]
	    set aux $row

	    if { $row < $first } {
		while { $last > $first } {
		    deleteActiveRowButton $last
		    incr last -1
		}
		while { $last < $row } {
		    deleteActiveRowButton $last
		    incr last
		}
		while { $aux < $first } {
		    drawActiveRowButton %W $aux
		    incr aux
		}
		set rows_selected [list $first $row]
	    } else {
		while { $last < $first } {
		    deleteActiveRowButton $last
		    incr last
		}
		while { $last > $row } {
		    deleteActiveRowButton $last
		    incr last -1
		}
		while { $aux > $first } {
		    drawActiveRowButton %W $aux
		    incr aux -1
		}
		set rows_selected [list $first $row]
	    }
	    if { $first < $row } {
		set currentRange \
		    [list 0 $first [expr [DefSheetWidth] - 1] $row]
	    } else {
		set currentRange \
		    [list 0 $row [expr [DefSheetWidth] - 1] $first]
	    }
	    highlightCurrentRange [canvasFromSheet $activeSheet]
	}
    bind $row_canvas <ButtonRelease-1> \
	{
	    lsort -increasing $cols_selected
	    bind %row_canvas <B1-Motion> {}
	}
}

proc doColRowCanvasBindings {col_canvas row_canvas} {
    source [xxl_library]/globalvars.tcl
    set cols_selected {}
    set rows_selected {}
    
    bind $col_canvas <ButtonPress-1> \
	{
	    unhighlightRowSelection
	    set rows_selected {}
	    
	    .$activeSheet.fr.menubar.menu.edit.menu.insert entryconfigure 2 \
		-state disabled
	    .$activeSheet.fr.menubar.menu.format.menu entryconfigure 3 -state disabled


	    set col [CellCol $activeSheet \
			 [expr %x + [SheetXOrigin $activeSheet]]]
	    set s [GetFormat $activeSheet $col -1]
	    if {$s != ""} {
		set fontNameIndex [lindex $s 0]
		set fontSizeIndex [lindex $s 1]
		set fontBoldIndex [lindex $s 2] 
		setFontName
		set fontItalicIndex [lindex $s 3]
		set shadeIndex [lindex $s 8]
		set positionLRC [lindex $s 9]
		set formatValue [lindex $s 10]
	    }
	    set currentRange [list $col 0 $col [expr [DefSheetHeight] - 1]]
	    unhighlightActiveCell
	    highlightCurrentRange [canvasFromSheet $activeSheet]
	    
	    if {$cols_selected != ""} {
		unhighlightColSelection
	    }
	    if {$rows_selected != ""} {
		unhighlightRowSelection
	    }
	    set cols_selected [list $col $col]
	    drawActiveColButton %W $col
	    doColCanvasMotionBindings %W
	    
	    bind %W <ButtonRelease-1> \
		{
		    bind %W <B1-Motion> {}
		}
	}
    bind $row_canvas  <ButtonPress-1> \
	{
	    unhighlightColSelection
	    set cols_selected {}

	    .$activeSheet.fr.menubar.menu.edit.menu.insert entryconfigure 1 \
		-state disabled
	    .$activeSheet.fr.menubar.menu.format.menu entryconfigure 2 -state disabled


	    set row [CellRow $activeSheet \
			 [expr %y + [SheetYOrigin $activeSheet]]]
	    set s [GetFormat $activeSheet -1 $row]
	    if {$s != ""} {
		set fontNameIndex [lindex $s 0]
		set fontSizeIndex [lindex $s 1]
		set fontBoldIndex [lindex $s 2] 
		setFontName
		set fontItalicIndex [lindex $s 3]
		set shadeIndex [lindex $s 8]
		set positionLRC [lindex $s 9]
		set formatValue [lindex $s 10]
	    }
	    set currentRange [list 0 $row [expr [DefSheetWidth] - 1] $row]
	    unhighlightActiveCell
	    highlightCurrentRange [canvasFromSheet $activeSheet]

	    if {$cols_selected != ""} {
		unhighlightColSelection
	    }
	    if {$rows_selected != ""} {
		unhighlightRowSelection
	    }
	    set rows_selected [list $row $row]
	    drawActiveRowButton %W $row
	    doRowCanvasMotionBindings %W
	    
	    bind %W <ButtonRelease-1> \
		{
		    bind %W <B1-Motion> {}
		}
	}
}

proc extWidth {widget} {
    set r [expr [lindex [$widget config -width] 4]]
    return $r
}

proc extHeight {widget} {
    set r [expr [lindex [$widget config -height] 4]]
    return $r
}

proc createCellBorders {sheet} {
    set canvas [canvasFromSheet $sheet]
    
    for {set i 0} {$i < 1 } {incr i} {
        set x [colOrigin $i]
        set yf [defHeight]
        set s [$canvas create line $x 0 $x $yf X 0 0 0 0 \
		   -fill blue -tag Zcellborders]
        SetBorderItemId $sheet $s
    }
}

proc deleteCellBorders {sheet} {
    
    set c [canvasFromSheet $sheet]
    $c delete Zcellborders
    $c delete cellborders
    SetBorderItemId $sheet -1
    refreshCanvas $sheet
}

proc createColumnLabels {frme} {

    for {set i 0} {$i < 1} {incr i} {
        set y [expr [defCellHeight]/2+4]
        set x 0
        $frme create text $x $y  -text [format %2s [ColName $i]] \
	    -tag Zcollabels
    }
}

proc createRowLabels {frme} {
    for {set i 0} {$i < 1} {incr i} {
        set x [expr 30/2]
        set y 0
        $frme create text $x $y  -text [format %4d [expr $i+1]] \
	    -tag Zrowlabels
    }
}

proc scrollHSheet {top k y {z 0}} {
    global activeSheet
    
    if {$z == 0} {
        ScrollFraction $activeSheet horizontal $y 
    } else {
        if {$y > 0} {
            ScrollFraction $activeSheet right
        } else {
            ScrollFraction $activeSheet left
        }

    }
}

proc scrollVSheet {top k y {z 0}} {
    global activeSheet

    if {$z == 0} {
        ScrollFraction $activeSheet vertical $y
    } else {
        if {$y > 0} {
            ScrollFraction $activeSheet down
        } else {
            ScrollFraction $activeSheet up
        }
    }
}

proc canvasFromSheet {sheet} {
    return .$sheet.fr.midrow.canvas
}

proc colLabelsFromSheet {sheet} {
    return .$sheet.fr.toprow.labels
}

proc rowLabelsFromSheet {sheet} {
    return .$sheet.fr.midrow.f.labels
}

proc hScrollFromSheet {sheet} {
    return .$sheet.fr.botrow.hscroll
}

proc vScrollFromSheet {sheet} {
    return .$sheet.fr.midrow.f2.vscroll
}

proc mkCanvas {sheet {waitForWindow 1}} {
    global activeSheet 
    set activeSheet $sheet


    set top .$sheet
    
    toplevel .$top
    #
    # First, the frames
    #
    dpos $top 50 50

    frame $top.fr

    frame $top.fr.menubar
    frame $top.fr.header -relief ridge -bd 2
    
    # Now, the frames that force the ordering on the toolbars

    frame $top.fr.header.f1 -width 10c -height 1 
    frame $top.fr.header.f2 -width 10c -height 1 
    frame $top.fr.header.f3 -width 10c -height 1 
    frame $top.fr.header.f4 -width 10c -height 1 
    frame $top.fr.header.f5 -height 1 


    frame $top.fr.toprow 
    frame $top.fr.midrow 
    frame $top.fr.botrow 
    
    frame $top.fr.trailer 
    
    #
    # Now, the canvas itself
    #   
    frame $top.fr.midrow.f3 
    set canvasName [canvasFromSheet $sheet]
    canvas $canvasName \
            -scrollregion "0 0 [defWidth]  [defHeight]"\
            -width [defDispWidth] \
            -height [defDispHeight] \
            -bg white -relief sunken -bd 2 \
            -cursor diamond_cross \
            -xscrollincrement 1 \
            -yscrollincrement 1
    
    #
    # Now, the scrollbars   
    #
    
    frame $top.fr.midrow.f2
    scrollbar $top.fr.midrow.f2.vscroll  -relief sunken \
            -command "scrollVSheet $sheet" 
    $top.fr.midrow.f2 config -width [expr [extWidth $top.fr.midrow.f2.vscroll]+10] \
            -height 2 


    
    scrollbar $top.fr.botrow.hscroll -orient horiz -relief sunken \
          -command "scrollHSheet $sheet" 
            
    

    #
    # Row and column labels
    #

    canvas $top.fr.toprow.labels \
            -scrollregion "0 0 [defWidth]  [defHeight]"\
            -width [defDispWidth] \
            -height [defCellHeight] \
            -relief raised -bd 2 \
            -xscrollincrement 1 \
            -yscrollincrement 1


    frame $top.fr.midrow.f
    canvas $top.fr.midrow.f.labels \
            -scrollregion "0 0 [defWidth]  [defHeight]"\
            -width 35 \
            -height [defDispHeight] \
            -relief raised -bd 2 \
            -xscrollincrement 1 \
            -yscrollincrement 1

    $top.fr.midrow.f  config   -width [expr [extWidth $top.fr.midrow.f.labels]+6] \
            -height 2 


    #
    # Padding
    #

    frame $top.fr.toprow.pad1 -width [expr [extWidth $top.fr.midrow.f.labels]+6] \
            -height 2 
    frame $top.fr.toprow.pad2 -width [expr [extWidth $top.fr.midrow.f2.vscroll]+10] \
            -height 2 

    frame $top.fr.botrow.pad1 -width [expr [extWidth $top.fr.midrow.f.labels]+6] \
            -height 2 
    frame $top.fr.botrow.pad2 -width [expr [extWidth $top.fr.midrow.f2.vscroll]+10] \
            -height 2 


    #
    # Now, pack everything
    #

    pack $top.fr.toprow.pad1 -fill x -side left
    pack $top.fr.toprow.labels -expand yes -fill x -side left
    pack $top.fr.toprow.pad2 -fill x -side left

    pack $top.fr.midrow.f -fill y -side left -anchor w
    pack $top.fr.midrow.f.labels $canvasName -expand yes \
            -side left -fill y -anchor w

#    pack $top.fr.midrow.f3
    pack $canvasName -expand yes \
            -side left -fill both -anchor nw

    pack $top.fr.midrow.f2 -fill y -side left -anchor e
    pack $top.fr.midrow.f2.vscroll -expand yes \
            -side right -fill y -anchor e

    
    pack $top.fr.botrow.pad1 -fill x -side left -anchor s
    pack $top.fr.botrow.hscroll -fill x -side left -expand yes -anchor s
    pack $top.fr.botrow.pad2 -fill x -side left -anchor s


    pack $top.fr.menubar \
            -side top  -fill both 
    pack $top.fr.header.f1 -side top -fill x 
    pack $top.fr.header.f2 -side top -fill x 
    pack $top.fr.header.f3 -side top -fill x 
    pack $top.fr.header.f4 -side top -fill x 
    pack $top.fr.header.f5 -side top -fill x 

    pack $top.fr.header \
            -side top  -fill x 
    pack $top.fr.toprow \
            -side top -fill x  -anchor s
    pack $top.fr.midrow \
            -side top -expand yes -fill both -expand yes
    pack $top.fr.botrow \
            -side top -fill x  -anchor n
    pack $top.fr.trailer \
            -side top -fill both 
    pack $top.fr -expand yes -fill both

    displayStandardToolbar $top.fr.header $top.fr.header.f1
    displayFormatToolbar $top.fr.header $top.fr.header.f2
    displayMenuBar $top.fr.menubar
    displayEntry $top.fr.header $top.fr.header.f5 $sheet

    if {$waitForWindow == 1} {tkwait visibility $top}

    set wid [lindex [$canvasName config -width] 4]
    set hei [lindex [$canvasName config -height] 4]
    SetNewCanvasSize $sheet $wid $hei
    Scroll $sheet 0 0

    createColumnLabels $top.fr.toprow.labels
    createRowLabels $top.fr.midrow.f.labels
    if {[CellBorders $sheet]} {
        createCellBorders $sheet
    }

    set info [wm geom $top]
    scan $info "%dx%d" w h
    wm minsize $top $w $h
    wm title $top "Abacus: $sheet"
    wm iconname $top "Abacus: $sheet"
    
    doColRowCanvasBindings $top.fr.toprow.labels $top.fr.midrow.f.labels

    bind $canvasName <Configure> \
            {SetNewCanvasSize $activeSheet [expr %w-8] [expr %h-8]}

    bind $canvasName <ButtonPress-1> \
            {stateMachine %W press %x %y}
    bind $canvasName <ButtonRelease-1> \
            {stateMachine %W  release %x %y}

    bind $canvasName <Enter> {stateMachine %W focus}
#    bind $canvasName <Leave> {focus .$activeSheet}

    global bindDown
    set bindDown {    
        set c [canvasFromSheet $activeSheet]
        bind $c <Down> {countKeys} ;
        bind $c <Key> {countKeys} ;
#        incr updateCnt
#        if {[expr $updateCnt %% 3] == 0} {update} ; 
        update
        stateMachine %W down 0 1 rel;
        bind $c <Down> $bindDown
        bind $c <Key> {stateMachine %%W key %%A}
    }
    bind $canvasName <Down> $bindDown

#    global timer
#    set timer {after 1000 {set keysPressed 0; eval $timer}}
#    eval $timer

    global bindLeft
    set bindLeft {    
        set c [canvasFromSheet $activeSheet]
        bind $c <Left> {countKeys} ;
        bind $c <Key> {countKeys} ;
        update 
        stateMachine %W left -1 0 rel;
        bind $c <Left> $bindLeft
        bind $c <Key> {stateMachine %%W key %%A}
    }
    bind $canvasName <Left> $bindLeft

    global bindUp
    set bindUp {    
        set c [canvasFromSheet $activeSheet]
        bind $c <Up> {countKeys} ;
        bind $c <Key> {countKeys} ;
        update 
        stateMachine %W up 0 -1 rel;
        bind $c <Up> $bindUp
        bind $c <Key> {stateMachine %%W key %%A}
    }
    bind $canvasName <Up> $bindUp

    global bindRight 
    set bindRight {    
        set c [canvasFromSheet $activeSheet]
        bind $c <Right> {countKeys} ;
        bind $c <Key> {countKeys} ;
        update 
        stateMachine %W right 1 0 rel;
        bind $c <Right> $bindRight
        bind $c <Key> {stateMachine %%W key %%A}
    }
    bind $canvasName <Right> $bindRight

#    bind $canvasName <Down> \
#            {stateMachine %W down 0 1 rel}
#    bind $canvasName <Left> \
#            {stateMachine %W left -1 0 rel}
#    bind $canvasName <Right> \
#            {stateMachine %W right 1 0 rel}
#    bind $canvasName <Up> \
#            {stateMachine %W up 0 -1 rel}
    bind $canvasName <Return> \
            {stateMachine %W return %A}
    bind $canvasName <Key-equal> \
            {stateMachine %W equal %A}

    bind $canvasName <Shift_L> \
	{stateMachine %W shift %A}
    bind $canvasName <Shift_R> \
	{stateMachine %W shift %A}
    bind $canvasName <Control_L> \
	{stateMachine %W control %A}
    bind $canvasName <Control_R> \
	{stateMachine %W control %A}

    bind $canvasName <Key> \
            {stateMachine %W key %A}
#    bind $canvasName <B1-Motion> \
#            {stateMachine %W B1Motion %x %y}
    global bindMotion
    set bindMotion {
#        set c [canvasFromSheet $activeSheet]
#        bind $c <B1-Motion> {} 
        stateMachine  %W B1Motion %x %y
#        update
#        bind $c <B1-Motion> $bindMotion
# Letting this in implies changing the needtoscroll2 function too
    }
    bind $canvasName <B1-Motion> $bindMotion

    bind $top.fr <Enter> {
	changeActiveSheet $activeSheet [lindex [split %W {.}] 1]
    }
    highlightActiveCell
}

proc changeActiveSheet {old new} {
    source [xxl_library]/globalvars.tcl
    global activeSheet showCellBorders showPageBorders

    if {$old!=$new} {
	if {$cols_selected != ""} {
	    unhighlightColSelection 0
	    unhighlightCurrentRange [canvasFromSheet $activeSheet] 0
	} elseif {$rows_selected != ""} {
	    unhighlightRowSelection 0
	    unhighlightCurrentRange [canvasFromSheet $activeSheet] 0
	} elseif {$currentRange != ""} {
	    unhighlightCurrentRange [canvasFromSheet $activeSheet] 0
	} else {
	    unhighlightActiveCell
	}
	set activeSheet $new
	SetActiveSheet $activeSheet
	set showCellBorders [CellBorders $new]
	set showPageBorders [PageBorders $new]
	update
	if {$cols_selected != ""} {
	    highlightColSelection
	    highlightCurrentRange [canvasFromSheet $activeSheet]
	} elseif {$rows_selected != ""} {
	    highlightRowSelection
	    highlightCurrentRange [canvasFromSheet $activeSheet]
	} elseif {$currentRange != ""} {
	    highlightCurrentRange [canvasFromSheet $activeSheet]
	} else {
	    highlightActiveCell
	}
    } else {
	update
    }
}

proc refreshCanvas {sheet} {
    set canvas [canvasFromSheet $sheet]

    $canvas yview scroll 1 units
    $canvas yview scroll -1 units
}

proc redrawCanvas {sheet} {
    global activeSheet cols_selected rows_selected
    global printRange paperWidth paperHeight typeView scale  

    set top .$sheet

    set canvas [canvasFromSheet $sheet]
    changeActiveSheet $activeSheet $sheet

    $canvas delete all
    if {[CellBorders $activeSheet]} {
        createCellBorders $activeSheet
    }

    $top.fr.toprow.labels xview scroll 1 units
    $top.fr.toprow.labels xview scroll -1 units
    $top.fr.midrow.f.labels yview scroll 1 units
    $top.fr.midrow.f.labels yview scroll -1 units
   

    $top.fr.midrow.canvas yview scroll 1 units
    $top.fr.midrow.canvas yview scroll -1 units


    RedrawSheet $sheet

    if {[llength $cols_selected]!=0} {highlightColSelection}
    if {[llength $rows_selected]!=0} {highlightRowSelection}
    
    redrawGraph $sheet
    
}

proc redrawGraph {sheet } {

    set s [UsedGraphs $sheet]

    foreach i $s {
        doDrawGraph $sheet $i
    }
}

proc scrollBenchmark {} {
    set c [canvasFromSheet $activeSheet]
    for {set i 0} {$i < 100} {incr i} {
        $c yview scroll 1 unit
        update
    }
    for {set i 0} {$i < 100} {incr i} {
        $c yview scroll -1 unit
        update
    }
}

# $Log: canvas.tcl,v $
# Revision 1.36  1998/09/30 00:43:47  cthulhu
# Bindings for CTRL and ALT entry box editing were added.
#
# Revision 1.35  1998/09/04 02:32:19  cthulhu
# Column and Row labels now resize correctly when width/height is changed
#
# Revision 1.34  1998/08/24 18:32:53  cthulhu
# Rearranged toolbar geometry so help messages are displayed correctly.
#
# Revision 1.33  1998/08/06 21:08:28  aml
# Released alpha version of Abacus.
#
# Revision 1.32  1997/03/27 10:00:32  aml
# Started implementing graphs.
# Fixed bug in tkCanvasPs.c
# Created bindings for composite characters in Portuguese.
#
# Revision 1.31  1997/02/10 15:10:02  aml
# Print settings now are saved to file.
# Fixed buggy error message when loading sheets.
#
# Revision 1.30  1996/12/31  17:38:35  aml
# On-demand calculation improved. Loops are detected.
# Automatic recalculation can now be disabled.
# Printing was improved.
#
# Revision 1.29  1996/12/11 21:39:55  aml
# Sumif implemented.
# Diverse time functions implemented.
# Fixed needtoscroll2 to avoid out of control scroll.
#
# Revision 1.28  1996/11/22 16:29:07  aml
# First cut at transforming canvas into a true cell widget.
# Text, lines and rectangles are now relative to row and colunm numbers.
# It still has a bug with wrong estimation of column widths.
#
# Revision 1.27  1996/09/16 18:42:15  aml
# Some performance problems addressed by reducing tag use.
# Several performance problems remain when heavy use is made
# of borders and shading in large spreadsheets.
#
# Revision 1.26  1996/09/15  19:24:09  aml
# Rulling and shading.
# Optionally hide cell borders.
# Works well, but is very slow for large spreadsheets.
#
# Revision 1.25  1996/09/04  14:29:48  aml
# Fixed double redrawing of sheets that was taking place.
# Fixed a item reference problem when the sheet is redrawn.
# Fixed misplacement of row labels.
# Created first version of format toolbar.
#
# Revision 1.24  1996/08/29 12:05:19  aml
# Fixed problem with initialization of formulas.
# Insertion in entry is now done properly.
# Focus is slightly better handled.
# Fixed serious problem when canvas changes name and old
# references exist. Also removed double call to redraw that
# was slowing things a lot.
#
# Revision 1.23  1996/08/28 17:17:27  aml
# Load and save now accept string_value for formula cells.
# This fixes previous thought problem of formula values not
# being stored.
# Functions upper,lower and proper created.
# Function if can now return labels.
# Fixed problem with function count.
# Reasonably stable version, very used to manipulate notas.wk1.
#
# Revision 1.22  1996/08/26 17:22:26  aml
# Function round fixed.
# Many other functions added, from power to mod.
#
# Revision 1.21  1996/08/26 12:08:41  aml
# Fixed problem with several sheets. Each canvas now has its own
# canvas info.
# Fixed scroll up and down. Implemented max_row and max_col.
# Fairly stable version.
#
# Revision 1.20  1996/08/24  10:15:56  aml
# Scroll almost fixed. We are missing scroll steps.
# Several sheets work again, but need to be fixed right.
#
# Revision 1.19  1996/08/23  16:13:30  aml
# Top window resizing now works well.
# Range selection now uses a filled rectangle with overall good results.
# Intermediate version, does not work well.
#
# Revision 1.18  1996/07/29 09:02:27  aml
# Fixed a few small problems with variable sized columns caused by
# messing around with the canvas widget.
#
# Revision 1.17  1996/07/23 14:01:09  aml
# Changed canvas widget to handle special items like cell borders.
# Seems to work well. Spreadsheet size is no more limited now.
#
# Revision 1.16  1996/07/18 10:19:18  aml
# Created formats for cells.
# Load cell now makes copy of old file.
#
# Revision 1.15  1996/04/21  13:28:07  aml
# Sped up scroll functions, caching keys presses.
# First cut at handling overflowing cells.
# Overflow into ajoining filled cells not solved.
#
# Revision 1.14  1996/03/29 21:45:30  aml
# Changed key based scrolls to be synchronous. Work fine, but are somewhat slow.
# Fixed abnormaly in state machine after range defition causing canvas scroll.
# Solid, working version.
#
# Revision 1.13  1996/03/07 20:32:53  aml
# Created print range ability.
# Set in gray non-working menus.
# Created RangeKill command.
# Created round function and macros for single argument functions.
#
# Revision 1.12  1996/02/19  15:47:32  aml
# Fixed abnormality with mouse click.
# Variable width columns implemented, but not yet saved.
# Labels are now a lex element, fixing some aberrant behavior that existed.
#
# Revision 1.11  1996/02/16  23:09:30  aml
# Improved user interf state machine.
# Centralized range definitions.
# Range defined outiside current view work properly.
#
# Revision 1.10  1996/02/13  21:55:15  aml
# Fixed problems with change to elf.
# RangeCopy created. Works !
# Pressed mouse leaving canvas will cause scroll. Works, but needs to
# keep moving.
#
# Revision 1.9  1996/01/30  16:05:37  aml
# User interface for cell and range copy created.
# Improved user interface state machine when entering and viewing cells.
# Fixed unaligned accesses during formula parsing and io operations.
#
# Revision 1.8  1996/01/27  23:10:21  aml
# CellCopy created.
# CellGet fixed.
# Tcl range operators created.
# User interface improved. Cell references and ranges
# can now be defined with the mouse.
#
# Revision 1.7  1996/01/10  18:53:38  aml
# Fixed limited integer range of cells.
# Fixed incorrect code in spreadsheet type.
# Users interface improved. Cursors and mouse clicks
# now work in the most basic modes.
#
# Revision 1.6  1996/01/09  18:34:46  aml
# Load, save, open, close and exit now work properly (hopefuly).
# Sheet utility functions also work : SheetExists, SheetEmpty, SheetModified
#
# Revision 1.5  1996/01/03  23:07:11  aml
# Absolute and relative references to cells introduced.
# They are parsed and reverse parsed, not yet evaluated.
#
# Revision 1.4  1996/01/02  16:22:09  aml
# Formula compilation, evaluation and decompilation now work.
# Cells can be of type label, numerical formula or numbers.
#
# Revision 1.3  1995/12/27  23:15:09  aml
# First version of Sheet::display
#
# Revision 1.2  1995/12/14  12:13:00  aml
# Version 0.4.2
#
# Revision 1.1  1995/11/08  22:07:25  aml
# Initial revision
#
