/*
 * fn2ent.c  - convert font name to entry name
 *
 *  Programmmed by Hirotsugu Kakugawa, Hiroshima University
 *  E-Mail:  h.kakugawa@computer.org
 *
 *  Edition History
 *  31 Oct 1993
 *   4 Nov 1993  Implemented VF_Fn2Ent_TeX(), improved VF_Fn2Ent_AsItIs().
 */


/* This file is part of VFlib
 *
 * Copyright (C) 1993-1998 Hirotsugu KAKUGAWA.   All rights reserved.
 *
 * This file is part of the VFlib Library.  This library is free
 * software; you can redistribute it and/or modify it under the terms of
 * the GNU Library General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your
 * option) any later version.  This library is distributed in the hope
 * that it will be useful, but WITHOUT ANY WARRANTY; without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU Library General Public License for more details.
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include  <stdio.h>
#include  <stdlib.h>
#include  <ctype.h>
#include  "VF.h"


/* ConvFunc
 *    The function pointed to by ConvFunc :
 *      - takes a string as an argument
 *      - returns a string
 */

static char *(*ConvFunc)() = VF_Fn2Ent_AsItIs;


char*
VF_Fontname2Entry(fontname)
  char *fontname;
{
  return (ConvFunc)(fontname);
}

int
VF_SetFn2EntFunc(f)
  char *(*f)();
{
  ConvFunc = f;
  return 0;
}


char*
VF_Fn2Ent_TeX(fontname)
  char* fontname;
{
  char        *p, *q, *val;
  static char s[64];
  static char *f = NULL;

  if (f != NULL)
    free(f);
  f = NULL;
  if (strlen(fontname) < 64){
    strcpy(s, fontname);
    val = q = s;
  } else {
    if ((f = malloc(strlen(fontname) + 1)) == NULL)
      return fontname;  /* should be NULL??? */
    val= q = f;
  }
  p = fontname;
  while (*p != '\0'){
    if (isdigit(*p)){
      *q = '\0';
      break;
    }
    *q++ = *p++;
  }
  /**printf("****FONT NAME=%s\n", val);**/
  return val;
}

char*
VF_Fn2Ent_AsItIs(fontname)
  char *fontname;
{
  char        *val;
  static char s[64];
  static char *f = NULL;

  if (f != NULL)
    free(f);
  f = NULL;
  if (strlen(fontname) < 64){
    strcpy(s, fontname);
    val = s;
  } else {
    if ((f = malloc(strlen(fontname) + 1)) == NULL)
      return fontname;  /* should be NULL??? */
    strcpy(f, fontname);
    val = f;
  }
  return val;
}

