/* Copyright (C) 1991, 1992, 1995, 1996, 1997 Free Software Foundation, Inc.
   This file is part of the GNU C Library.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

#include <stdlib.h>
#include <wchar.h>

/* Convert WCHAR into its multibyte character representation,
   putting this in S and returning its length.

   Attention: this function should NEVER be intentionally used.
   The interface is completely stupid.  The state is shared between
   all conversion functions.  You should use instead the restartable
   version `wcrtomb'.  */
int
wctomb (char *s, wchar_t wchar)
{
  int result;
  static mbstate_t shift_state = {0,(wint_t)0};

  /*
   * The document "libc.info-19" says at line 67,
   *
   * "- Function: int wctomb (char *STRING, wchar_t WCHAR)
   *    .....
   *  If the multibyte character code uses shift characters, then
   *  `wctomb' maintains and updates a shift state as it scans.  If you
   *  call `wctomb' with a null pointer for STRING, that initializes the
   *  shift state to its standard initial value.  It also returns
   *  nonzero if the multibyte character code in use actually has a
   *  shift state.  *Note Shift State::."
   *
   */
  if (s == NULL)
    {
      result = (shift_state.count != 0) || (shift_state.value != (wint_t)0);
      shift_state.count = 0;
      shift_state.value = (wint_t)0;
      return result;
    }

  return __wcrtomb (s, wchar, &shift_state);
}
