/* expand a file name by prepending current directory, deleting . and
   .. (not really correct for symbolic links) between the prepended
   current directory.  Use $PWD if it exists.
   Returns true if any changes were made.
*/

#include <FL/filename.H>
#include <stdlib.h>
#include <string.h>
#ifdef WIN32
# include <direct.h>
#else
# include <unistd.h>
#endif

#ifdef WIN32
inline int isdirsep(char c) {return c=='/' || c=='\\';}
#else
#define isdirsep(c) ((c)=='/')
#endif

int filename_absolute(char *to,const char *from) {

  if (isdirsep(*from) || *from == '|'
#ifdef WIN32
      || from[1]==':'
#endif
      ) {
    strcpy(to,from);
    return 0;
  }

  char *a,temp[FNAMEMAX];
  const char *start = from;

#ifdef WIN32
  a = _getdcwd(0, temp, FNAMEMAX);
  if (!a) return 0;
  for (a = temp; *a; a++) if (*a=='\\') *a = '/'; // ha ha
#else
  a = getenv("PWD");
  if (a) strcpy(temp,a);
  else getcwd(temp,FNAMEMAX);
  a = temp+strlen(temp);
#endif
  if (isdirsep(*(a-1))) a--;
  /* remove intermediate . and .. names: */
  while (*start == '.') {
    if (start[1]=='.' && isdirsep(start[2])) {
      char *b;
      for (b = a-1; b >= temp && !isdirsep(*b); b--);
      if (b < temp) break;
      a = b;
      start += 3;
    } else if (isdirsep(start[1])) {
      start += 2;
    } else
      break;
  }
  *a++ = '/';
  strcpy(a,start);
  strcpy(to,temp);
  return 1;

}
