// Fl_Scroll.H

// A scrolling area of child widgets.  You can also subclass this so
// that you can draw into the area not occupied by children, so this
// is also an arbitrary "canvas".

#ifndef Fl_Scroll_H
#define Fl_Scroll_H

#include "Fl_Group.H"
#include "Fl_Slider.H"

class Fl_Scroll : public Fl_Group {

  Fl_Slider hslider;
  Fl_Slider vslider;
  int xposition_, yposition_;
  int width_, height_;
  int oldx, oldy;
  static void hslider_cb(Fl_Widget*, void*);
  static void vslider_cb(Fl_Widget*, void*);
  void fix_slider_order();
  void draw_clip(int,int,int,int);

protected:

  void draw();

public:

  void resize(int,int,int,int);
  int handle(int);

  Fl_Scroll(int X,int Y,int W,int H,const char*l=0);

  enum { // values for type()
    HORIZONTAL = 1,
    VERTICAL = 2,
    BOTH = 3
  };

  int xposition() const {return xposition_;}
  int yposition() const {return yposition_;}
  int width() const {return width_;}
  int height() const {return height_;}
  void position(int, int);
  void area(int,int);
  void init_area();
  Fl_Slider& xslider() {return hslider;}
  Fl_Slider& yslider() {return vslider;}
};

#endif
