%module _gtktty

%{
#include <gtktty/libgtktty.h>
%}

%include glue.i

%typemap(python,in) GtkLed * {
  if (PyGtk_Check($source))
    $target = GTK_LED(PyGtk_Get($source));
  else {
    PyErr_SetString(PyExc_TypeError, "not a GtkObject");
    return NULL;
  }
}
%typemap(python,out) GtkLed * {
  $target = PyGtk_New((GtkObject *)$source);
}

%typemap(python,in) GtkTerm * {
  if (PyGtk_Check($source))
    $target = GTK_TERM(PyGtk_Get($source));
  else {
    PyErr_SetString(PyExc_TypeError, "not a GtkObject");
    return NULL;
  }
}
%typemap(python,out) GtkTerm * {
  $target = PyGtk_New((GtkObject *)$source);
}

%typemap(python,in) GtkTty * {
  if (PyGtk_Check($source))
    $target = GTK_TTY(PyGtk_Get($source));
  else {
    PyErr_SetString(PyExc_TypeError, "not a GtkObject");
    return NULL;
  }
}
%typemap(python,out) GtkTty * {
  $target = PyGtk_New((GtkObject *)$source);
}

void pygtk_init();

int gtk_led_get_type();
GtkWidget *gtk_led_new();
void gtk_led_set_state(GtkLed *led, int widget_state, int on_off);
void gtk_led_switch(GtkLed *led, int on_off);
int gtk_led_is_on(GtkLed *led);

int gtk_term_get_type();
void gtk_term_construct(GtkTerm *term, int width, int height, int max_width,
		    int scrollback);
void gtk_term_set_scroll_offset(GtkTerm *term, int offset);
void gtk_term_block_refresh(GtkTerm *term);
void gtk_term_force_refresh(GtkTerm *term);
void gtk_term_unblock_refresh(GtkTerm *term);
void gtk_term_set_fonts(GtkTerm *term, GdkFont *font_normal, GdkFont *font_dim,
			GdkFont *font_bold, int overstrike_bold,
			GdkFont *font_underline, int draw_underline,
			GdkFont *font_reverse, int colors_reversed);
void gtk_term_set_color(GtkTerm *term, int index, long back, long fore,
			long fore_dim, long fore_bold);
void gtk_term_select_color(GtkTerm *term, int fore_index, int back_index);
void gtk_term_set_dim(GtkTerm *term, int dim);
void gtk_term_set_bold(GtkTerm *term, int bold);
void gtk_term_set_underline(GtkTerm *term, int underline);
void gtk_term_set_reverse(GtkTerm *term, int reverse);
void gtk_term_invert(GtkTerm *term);
void gtk_term_insert_lines(GtkTerm *term, int n);
void gtk_term_delete_lines(GtkTerm *term, int n);
void gtk_term_scroll(GtkTerm *term, int n, int downwards);
void gtk_term_clear_line(GtkTerm *term, int before_cursor, int after_cursor);
void gtk_term_insert_chars(GtkTerm *term, int n);
void gtk_term_delete_chars(GtkTerm *term, int n);
void gtk_term_bell(GtkTerm *term);
void gtk_term_clear(GtkTerm *term, int before_cursor, int after_cursor);
void gtk_term_set_cursor(GtkTerm *term, int x, int y);
//void gtk_term_get_cursor
%{
static PyObject *gtk__term_get_cursor(PyObject *self, PyObject *args) {
  PyObject *term;
  int x, y;
  if (!PyArg_ParseTuple(args, "O!:gtk_term_get_cursor", PyGtk_Type, &term))
    return NULL;
  gtk_term_get_cursor(GTK_TERM(PyGtk_Get(term)), &x, &y);
  return Py_BuildValue("(ii)", x, y);
}
static PyObject *gtk__term_get_size(PyObject *self, PyObject *args) {
  PyObject *term;
  int x, y;
  if (!PyArg_ParseTuple(args, "O!:gtk_term_get_size", PyGtk_Type, &term))
    return NULL;
  gtk_term_get_size(GTK_TERM(PyGtk_Get(term)), &x, &y);
  return Py_BuildValue("(ii)", x, y);
}
%}
%native(gtk_term_get_cursor) PyObject *gtk__term_get_cursor(PyObject *self,
							    PyObject *args);
%native(gtk_term_get_size) PyObject *gtk__term_get_size(PyObject *self,
							PyObject *args);
void gtk_term_set_cursor_mode(GtkTerm *term, int mode, int blinking);
void gtk_term_save_cursor(GtkTerm *term);
void gtk_term_restore_cursor(GtkTerm *term);
void gtk_term_set_scroll_reg(GtkTerm *term, int top, int bottom);
void gtk_term_reset(GtkTerm *term);

void gtk_term_erase_chars(GtkTerm *term, int n);
int gtk_term_putc(GtkTerm *term, char ch, int insert);
int gtk_tty_get_type();
GtkWidget *gtk_tty_new(int width, int height, int scrollback);
void gtk_tty_put_out(GtkTty *tty, char *buffer, int count);
void gtk_tty_put_in(GtkTty *tty, char *buffer, int count);
void gtk_tty_leds_changed(GtkTty *tty);
void gtk_tty_add_update_led(GtkTty *tty, GtkLed *led, int mask);
//void gtk_tty_execute
%{
static PyObject *gtk__tty_execute(PyObject *self, PyObject *args) {
  PyObject *tty;
  char *prg_name;
  PyObject *py_argv, *py_envp, *item;
  char **argv, **envp;
  int len, i;

  if (!PyArg_ParseTuple(args, "O!sOO:gtk_tty_execute", PyGtk_Type, &tty,
			&prg_name, &py_argv, &py_envp))
    return NULL;
  if (!PySequence_Check(py_argv) || !PySequence_Check(py_envp)) {
    PyErr_SetString(PyExc_TypeError, "argument not a sequence");
    return NULL;
  }
  len = PySequence_Length(py_argv);
  argv = g_new(char *, len+1);
  argv[len] = NULL;
  for (i = 0; i < len; i++) {
    item = PySequence_GetItem(py_argv, i);
    if (!PyString_Check(item)) {
      PyErr_SetString(PyExc_TypeError, "sequence item not a string");
      g_free(argv);
      return NULL;
    }
    argv[i] = PyString_AsString(item);
  }
  len = PySequence_Length(py_envp);
  envp = g_new(char *, len+1);
  envp[len] = NULL;
  for (i = 0; i < len; i++) {
    item = PySequence_GetItem(py_envp, i);
    if (!PyString_Check(item)) {
      PyErr_SetString(PyExc_TypeError, "sequence item not a string");
      g_free(argv);
      g_free(envp);
      return NULL;
    }
    envp[i] = PyString_AsString(item);
  }
  gtk_tty_execute(GTK_TTY(PyGtk_Get(tty)), prg_name, argv, envp);
  g_free(argv);
  g_free(envp);
  Py_INCREF(Py_None);
  return Py_None;
}
%}
%native(gtk_tty_execute) PyObject *gtk__tty_execute(PyObject *self,
						    PyObject *args);
