.\"
.\" Copyright (c) Mark J. Kilgard, 1996.
.\"
.TH glutPositionWindow 3GLUT "3.6" "GLUT" "GLUT"
.SH NAME
glutPositionWindow - requests a change to the position of the current window. 
.SH SYNTAX
.nf
.LP
void glutPositionWindow(int x, int y);
.fi
.SH ARGUMENTS
.IP \fIx\fP 1i
New X location of window in pixels. 
.IP \fIy\fP 1i
New Y location of window in pixels. 
.SH DESCRIPTION
glutPositionWindow requests a change in the position of the current
window. For top-level windows, the x and y parameters are pixel offsets
from the screen origin. For subwindows, the x and y parameters are
pixel offsets from the window's parent window origin. 

The requests by glutPositionWindow are not processed immediately.
The request is executed after returning to the main event loop. This
allows multiple glutPositionWindow, glutReshapeWindow, and
glutFullScreen requests to the same window to be coalesced. 

In the case of top-level windows, a glutPositionWindow call is
considered only a request for positioning the window. The window
system is free to apply its own policies to top-level window placement.
The intent is that top-level windows should be repositioned according
glutPositionWindow's parameters. 

glutPositionWindow disables the full screen status of a window if
previously enabled. 
.SH SEE ALSO
glutInitWindowPosition, glutReshapeWindow
.SH AUTHOR
Mark J. Kilgard (mjk@sgi.com)
