////////////////////////////////////////////////////////
//
// GEM - Graphics Environment for Multimedia
//
// mark@danks.org
//
// Implementation file
//
//    Copyright (c) 1997-1998 Mark Danks.
//    For information on usage and redistribution, and for a DISCLAIMER OF ALL
//    WARRANTIES, see the file, "GEM.LICENSE.TERMS" in this distribution.
//
/////////////////////////////////////////////////////////

#include "light.h"

CPPEXTERN_NEW(light)

/////////////////////////////////////////////////////////
//
// light
//
/////////////////////////////////////////////////////////
// Constructor
//
/////////////////////////////////////////////////////////
light :: light()
{
    m_position[0] = m_position[1] = m_position[2] = 0.0;
    m_position[3] = 1.0;

    // create the position inlet
    inlet_new(this->x_obj, &this->x_obj->ob_pd, gensym("list"), gensym("poslist"));
}

/////////////////////////////////////////////////////////
// Destructor
//
/////////////////////////////////////////////////////////
light :: ~light()
{ }

/////////////////////////////////////////////////////////
// lightPositionMess
//
/////////////////////////////////////////////////////////
void light :: lightPositionMess(float x, float y, float z)
{
    m_position[0] = x;
    m_position[1] = y;
    m_position[2] = z;

    m_dirty = 1;
    setModified();
}

/////////////////////////////////////////////////////////
// static member functions
//
/////////////////////////////////////////////////////////
void light :: obj_setupCallback(t_class *classPtr)
{
    class_addmethod(classPtr, (t_method)&light::lightPositionMessCallback,
    	    gensym("poslist"), A_FLOAT, A_FLOAT, A_FLOAT, A_NULL);
}
void light :: lightPositionMessCallback(void *data, t_floatarg x, t_floatarg y, t_floatarg z)
{
    GetMyClass(data)->lightPositionMess((float)x, (float)y, (float)z);
}
