/*-----------------------------------------------------------------
LOG
    GEM - Graphics Environment for Multimedia

    Interface for the window manager

    Copyright (c) 1997-1998 Mark Danks.
    For information on usage and redistribution, and for a DISCLAIMER OF ALL
    WARRANTIES, see the file, "GEM.LICENSE.TERMS" in this distribution.

-----------------------------------------------------------------*/

#ifndef INCLUDE_GEMWIN_H_
#define INCLUDE_GEMWIN_H_

#include "Base/CPPExtern.h"

/*-----------------------------------------------------------------
-------------------------------------------------------------------
CLASS
    gemwin
    
    The window manager

DESCRIPTION
    
    Access to GemMan.
    
    "int"   - turn on/off the rendering (in double buffered mode)
    "bang"  - swap the buffers
    "create" - create a graphics window
    "destroy" - destroy the graphics window
    "buffer" - single or double buffering
    "dimen" - the window dimensions
    "frame" - the frame rate
    "lighting" - turn lighting on/off
    "ambient" - the ambient light color
    "specular" - the specular light color
    "shininess" - the shininess value
    "reset" - reset the graphics manager to the initial state
    "color" - rgb color for clearing
    "profile #" - turn on/off profiling (time per frame)
				- # == 0 : turn off
				- # == 1 : turn on
				- # == 2 : turn on without image caching
-----------------------------------------------------------------*/
class GEM_EXTERN gemwin : public CPPExtern
{
    CPPEXTERN_HEADER(gemwin, CPPExtern)
    
    public:
    
	    //////////
	    // Constructor
    	gemwin(t_floatarg framespersecond);
    	
    private:

      	//////////
    	// Destructor
    	virtual     	~gemwin();

    	void 	    	bangMess();
    	void 	    	intMess(int state);

    	void 	    	createMess();
    	void 	    	bufferMess(int buf);
    	void 	    	dimensionsMess(int width, int height);
    	void 	    	colorMess(float red, float green, float blue);
    	void 	    	ambientMess(float red, float green, float blue);
    	void 	    	specularMess(float red, float green, float blue);
    	void 	    	shininessMess(float val);

    private:
    
    	//////////
    	// Static member functions
    	static void 	bangMessCallback(void *data);
    	static void 	floatMessCallback(void *data, t_float state);
    	static void 	createMessCallback(void *data);
    	static void 	bufferMessCallback(void *data, t_floatarg buf);
    	static void 	dimensionsMessCallback(void *data, t_floatarg width, t_floatarg height);
    	static void 	colorMessCallback(void *data, t_floatarg red, t_floatarg green, t_floatarg blue);
    	static void 	ambientMessCallback(void *data, t_floatarg red, t_floatarg green, t_floatarg blue);
    	static void 	specularMessCallback(void *data, t_floatarg red, t_floatarg green, t_floatarg blue);
    	static void 	shininessMessCallback(void *data, t_floatarg val);

    	// just call GemMan directly
    	static void 	destroyMessCallback(void *);
    	static void 	printMessCallback(void *);
    	static void 	profileMessCallback(void *, t_floatarg state);
    	static void 	resetMessCallback(void *);
    	static void 	lightingMessCallback(void *, t_floatarg state);
    	static void 	frameMessCallback(void *, t_floatarg framesPerSecond);
};

#endif	// for header file
