# Note that this is NOT a relocatable package
%define ver      0.3
%define rel      1
%define prefix   /usr

Summary: Color Font rendering lobrary for X11R6
Name: fnlib
Version: %ver
Release: %rel
Copyright: LGPL
Group: X11/Libraries
Source: ftp://www.rasterman.com/pub/enlightenment/libs/fnlib/fnlib_DR-%{ver}.tar.gz
Obsoletes: Fnlib
BuildRoot: /tmp/fnlib-root
Packager: The Rastermnan <raster@redhat.com>
URL: http://www.rasterman.com/
Requires: imlib
Requires: libpng
Requires: libtiff
Requires: libjpeg
Requires: zlib
Requires: libgr-progs
Requires: libungif
Requires: ImageMagick
Docdir: %{prefix}/doc

%description
Fnlib is a library that provides full scalable 24-bit Color font rendering
abilities for X.

%package devel
Summary: Fnlib headers, static libraries and documentation
Group: X11/Libraries
Requires: fnlib
Obsoletes: Fnlib

%description devel
Headers, static libraries and documentation for Fnlib.

%prep
%setup -n fnlib

%build
# Needed for snapshot releases.
# Optimize that damned code all the way
if [ ! -z "echo -n ${RPM_OPT_FLAGS} | grep pentium" ]; then
  if [ ! -z `which egcs` ]; then
    CC="egcs"
  else
    if [ ! -z `which pgcc` ]; then
      CC="pgcc"
    fi
  fi
  CFLAGS="${RPM_OPT_FLAGS}"
else
  CFLAGS="${RPM_OPT_FLAGS}"
fi
./configure --prefix=%prefix
make

%install
rm -rf $RPM_BUILD_ROOT

make prefix=$RPM_BUILD_ROOT%{prefix} install

%clean
rm -rf $RPM_BUILD_ROOT

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files
%defattr(-, root, root)

%doc README

%{prefix}/lib/lib*.so.*
%{prefix}/etc/*
%{prefix}/fnlib_fonts

%files devel
%defattr(-, root, root)

%doc HACKING
%doc doc/index.html
%doc doc/fontinfo.README

%{prefix}/lib/lib*.so
%{prefix}/lib/*a
%{prefix}/include/*
%{prefix}/fnlib_fonts/shinymetal/*
%{prefix}/fnlib_fonts/rock/*
%{prefix}/fnlib_fonts/e/*
