/* Quinn diff, another program to do something or other */
/* Copyright (C) 1997,1998 James Troup <james@nocrew.org> */

/* This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <fcntl.h>
#include <db.h>
#include "common.h"
#include "xmalloc.h"
#include "error.h"
#include "utils.h"
#include "hash.h"
#include "source.h"

/* Public functions */

HASHINFO *source_packages_hash_info;
DB *source_packages_table = NULL;
DBT *source_packages_dbt, *source_packages_key;
char package_key[PACKAGE_NAME_LENGTH];

void
source_packages_create (void)
{

  source_packages_hash_info = xmalloc (sizeof(*source_packages_hash_info));

  source_packages_hash_info->bsize = 256;
  source_packages_hash_info->cachesize = 1048576;
  source_packages_hash_info->ffactor = 8;
  source_packages_hash_info->hash = NULL; 
  source_packages_hash_info->lorder = 0;
  source_packages_hash_info->nelem = 1;

  source_packages_table = dbopen (NULL, O_RDWR, 0, DB_HASH, source_packages_hash_info);

  if (source_packages_table == NULL)
    fubar (SYSERR, "Unable to create hash table for source_packages buffer");

  source_packages_dbt = xmalloc (sizeof(*source_packages_dbt));
  source_packages_dbt->size = sizeof (source_packages_info);

  source_packages_key = xmalloc (sizeof(*source_packages_key));
  source_packages_key->data = package_key;

}

void source_packages_read (void)
{

  FILE *fp = NULL; 
  char *buffer_p;
  long buffer_length;

  read_file (packages_source_filename, fp, &buffer_p, &buffer_length); 

  debug (debug_sp, "read_source_packages_file: read %ld bytes of \"%s\"", 
	 buffer_length, packages_source_filename);
  
  read_source_packages (buffer_p, buffer_length);

}

int
source_packages_retrieve (const char *package, source_packages_info *source_package)
{

  source_packages_info *source_package_details;

  strcpy (package_key, package);
  source_packages_key->size = strlen (package);

  if (source_packages_table->get (source_packages_table, source_packages_key, source_packages_dbt, 0) != 0)
    return 0;

  source_package_details = (source_packages_info *) source_packages_dbt->data; 
  strcpy (source_package->package_name, source_package_details->package_name);
  strcpy (source_package->section, source_package_details->section);
  strcpy (source_package->version, source_package_details->version);

  return 1;


}
/*************/



void read_source_packages (char *buffer_p, long buffer_length)
{
  source_packages_info source_package;
  int i, j, k;

  i = 0;

  while (i < buffer_length)
    {
      j = 0;
      while (i < buffer_length && buffer_p[i] != ' ' && buffer_p[i] != '\n' && j < PACKAGE_STR_LENGTH)
	{
	  source_package.package_name[j++] = buffer_p[i++];
	}
      source_package.package_name[j] = '\0';
      debug(debug_sp, "package_name is \"%s\"", source_package.package_name);
      
      if (buffer_p[i] != ' ')
	fubar (NONSYS, "read_source_packages: failed to parse package_name in Packages-source.");
      
      j = 0; i++;
      while (i < buffer_length && buffer_p[i] != ' ' && buffer_p[i] != '\n' && j < SECTION_STR_LENGTH)
	{
	  source_package.section[j++] = buffer_p[i++];
	}
      source_package.section[j] = '\0';
      debug(debug_sp, "section is \"%s\"", source_package.section);
      
      if (buffer_p[i] != ' ')
	fubar (NONSYS, "read_source_packages: failed to parse section of %s in Packages-source.", 
	       source_package.package_name);
      
      j = 0; i++;
      while (i < buffer_length && buffer_p[i] != ' ' && buffer_p[i] != '\n' && j < VERSION_STR_LENGTH)
	{
	  source_package.version[j++] = buffer_p[i++];
	}
      source_package.version[j] = '\0';
      debug(debug_sp, "version is \"%s\"", source_package.version);
      
      if (buffer_p[i] != '\n')
	fubar (NONSYS, "read_source_packages: failed to parse version of %s Packages-source.", 
	       source_package.package_name);
      
      i++;

      /* add to the hash table */
      source_packages_dbt->data = (void *) &source_package;
      strcpy (package_key, source_package.package_name);
      source_packages_key->size = strlen (source_package.package_name);
      
      debug (debug_sp, "read_source_packages: key is %s and key size is %d", 
	     (char *) source_packages_key->data, source_packages_key->size);
      debug(debug_sp, "read_source_packages: data is at %p and size is %d", 
	    source_packages_dbt->data, source_packages_dbt->size);

      k = source_packages_table->put (source_packages_table, source_packages_key, source_packages_dbt, R_NOOVERWRITE);
      if (k == 1)
	fubar (NONSYS, "%s is duplicated in Packages-source, go find a better mirror.", source_package.package_name);
      else if (k == -1)
	fubar (SYSERR, "Couldn't add %s to the source packages hash table.", source_package.package_name);
      
    }

}
