/* Quinn Diff, Compares two Packages files looking for differences between Archs */
/* Copyright (C) 1997-1998, James Troup <james@nocrew.org> */

/* This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "xmalloc.h"
#include "error.h"
#include "init.h"
#include "list.h"
#include "hash.h"
#include "arch_specific.h"
#include "source.h"
#include "vercmp.h"
#include "output.h"
#include "primary.h"
#include "utils.h"
#include "main.h"

/* The following causes "common.h" to produce definitions of all the global
   variables, rather than just "extern" declarations of them. */
#define GLOBAL
#include "common.h"

int
main (int argc, char **argv)
{

  primary_package_info *primary;
  secondary_package_info *secondary;

  primary = xmalloc (sizeof(*primary));
  secondary = xmalloc (sizeof(*secondary));

  /* Setup some (global) variables */

  debug_level = 0;
  visible_warn_level = -1;
  program_name = argv[0];
  primary->buffer_pos = 0;
  secondary->buffer_pos = 0;
  strcpy (primary->file_name, "Packages-primary");
  strcpy (secondary->file_name, "Packages-secondary");
  strcpy (packages_arch_specific_filename, "Packages-arch-specific"); 
  strcpy (packages_source_filename, "Packages-source");
  parse_opt (argc, argv, primary, secondary);

  /* The Secondary architecture */

  read_file (secondary->file_name, secondary->file_pointer, &secondary->buffer, &secondary->file_length); 
  secondary_hash_create ();
  
  /* Find the name of the secondary architecture */

  secondary_architecture[0] = '\0';
  while (secondary->buffer_pos < secondary->file_length && secondary_architecture[0] == '\0')
    {
      get_blah (secondary->buffer, secondary->buffer_pos, secondary_architecture, "Architecture: ", secondary->file_length, "dunno");
      if (strstr (secondary_architecture, "all") != NULL)
	secondary_architecture[0] = '\0';
      if (secondary_architecture[0] == '\0')
	skip_to_next_package (secondary->buffer, &secondary->buffer_pos, secondary->file_length);
    }
  /* Reset the buffer position to the start */
  secondary->buffer_pos = 0;

  /* Read the secondary architecture Packages file and store the
     details in a hash table */

  while (secondary->buffer_pos < secondary->file_length)
    {
      if (secondary->buffer[secondary->buffer_pos] == 'P')
	{
	  read_line (secondary->buffer, &secondary->buffer_pos, secondary->name);

	  debug (debug_secondary, "Readline: \"%s\"", secondary->name); 
	  
 	  if (!(strncmp ("Package: ", secondary->name, 9))) 
	    {
	      strcpy (secondary->name, secondary->name + 9);
	      debug(debug_secondary, "main: Searching for package \"%s\" in Packages-secondary", 
		    secondary->name);
	      
	      get_blah (secondary->buffer, secondary->buffer_pos, secondary->version, "Version: ", secondary->file_length, secondary->name);
	      secondary_hash_add (secondary->name, secondary->version);
	    }
	}
      skip_line(secondary->buffer, &secondary->buffer_pos, secondary->file_length);
    }

  free (secondary->buffer);

  /** Process Packages-arch-specific **/

  arch_specific_hash_create ();
  arch_specific_read (); 

  /** Process Packages-source **/

  source_packages_create ();
  source_packages_read ();

  /** The Primary architecture **/

  read_file (primary->file_name, primary->file_pointer, &primary->buffer, &primary->file_length); 

  output_create ();

  process_primary(primary,secondary);

  output_display ();

  /** Cleanup */
  
  secondary_hash_destroy ();
  output_destroy ();
  free (primary->buffer);
  free (primary);
  free (secondary);
  return (0);
      
}

