/* Quinn Diff, Compares two Packages files looking for differences between Archs */
/* Copyright (C) 1997-1998, James Troup <james@nocrew.org> */

/* This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

void arch_specific_hash_create (void);
void arch_specific_read(void);
int is_arch_specific(const char *package_name);

/* Private functions */
void open_arch_specific_file(FILE *fp, char **buffer_p, long *buffer_length);
void read_arch_specific_packages (const char *buffer_p, const long buffer_length);
void arch_specific_hash_add (const char *package_name);
void check_parseable (const char *buffer_p, const long buffer_length);

struct arch_specific_info {
};

/* Fixed length of line which is parsed for Packages-arch-specific */

#define LINE_BUFFER_LENGTH 60

/* Used to stop quinn diff trying to parse Packages-arch-specific
   files which it can't */

#define NEWEST_PARSEABLE_VERSION 2
