#ifndef BZ_ARRAYMISC_CC
#define BZ_ARRAYMISC_CC

#ifndef BZ_ARRAY_H
 #error <blitz/array/misc.cc> must be included via <blitz/array.h>
#endif

BZ_NAMESPACE(blitz)

#define BZ_ARRAY_DECLARE_UOP(fn, fnobj)                                \
template<class T_numtype, int N_rank>                                  \
inline                                                                 \
_bz_ArrayExpr<_bz_ArrayExprUnaryOp<ArrayIterator<T_numtype,N_rank>,    \
    fnobj<T_numtype> > >                                               \
fn(const Array<T_numtype,N_rank>& array)                               \
{                                                                      \
    return _bz_ArrayExprUnaryOp<ArrayIterator<T_numtype,N_rank>,       \
        fnobj<T_numtype> >(array.begin());                             \
}                                                                      \
                                                                       \
template<class T_expr>                                                 \
inline                                                                 \
_bz_ArrayExpr<_bz_ArrayExprUnaryOp<_bz_ArrayExpr<T_expr>,              \
    fnobj<_bz_typename T_expr::T_numtype> > >                          \
fn(_bz_ArrayExpr<T_expr> expr)                                         \
{                                                                      \
    return _bz_ArrayExprUnaryOp<_bz_ArrayExpr<T_expr>,                 \
        fnobj<_bz_typename T_expr::T_numtype> >(expr);                 \
}                                                                      \
                                                                       \
template<int N_index>                                                  \
inline                                                                 \
_bz_ArrayExpr<_bz_ArrayExprUnaryOp<IndexPlaceholder<N_index>,          \
    fnobj<int> > >                                                     \
fn(IndexPlaceholder<N_index> index)                                    \
{                                                                      \
    return _bz_ArrayExprUnaryOp<IndexPlaceholder<N_index>,             \
        fnobj<int> >(index);                                           \
}

BZ_ARRAY_DECLARE_UOP(operator!, LogicalNot)
BZ_ARRAY_DECLARE_UOP(operator~, BitwiseNot)
BZ_ARRAY_DECLARE_UOP(operator-, Negate)

/*
 * cast() functions, for explicit type casting
 */

template<class T_numtype, int N_rank, class T_cast>
inline                                                                 
_bz_ArrayExpr<_bz_ArrayExprUnaryOp<ArrayIterator<T_numtype,N_rank>,   
    Cast<T_numtype, T_cast> > >
cast(const Array<T_numtype,N_rank>& array, T_cast)
{                                                                      
    return _bz_ArrayExprUnaryOp<ArrayIterator<T_numtype,N_rank>,      
        Cast<T_numtype,T_cast> >(array.begin());                            
}                                                                      
                                                                       
template<class T_expr, class T_cast>
inline                                                                 
_bz_ArrayExpr<_bz_ArrayExprUnaryOp<_bz_ArrayExpr<T_expr>,              
    Cast<_bz_typename T_expr::T_numtype,T_cast> > >                          
cast(_bz_ArrayExpr<T_expr> expr, T_cast)
{                                                                      
    return _bz_ArrayExprUnaryOp<_bz_ArrayExpr<T_expr>,                 
        Cast<_bz_typename T_expr::T_numtype,T_cast> >(expr);                 
}                                                                      
                                                                       
template<int N_index, class T_cast>
inline                                                                 
_bz_ArrayExpr<_bz_ArrayExprUnaryOp<IndexPlaceholder<N_index>,          
    Cast<int,T_cast> > >                                                     
cast(IndexPlaceholder<N_index> index, T_cast)
{                                                                      
    return _bz_ArrayExprUnaryOp<IndexPlaceholder<N_index>,             
        Cast<int,T_cast> >(index);                                           
}

BZ_NAMESPACE_END

#endif // BZ_ARRAYMISC_CC

