/*
 * $Id: db_interface.h,v 1.4 1998/09/21 14:32:25 gregm Exp $
 * GXSNMP -- An snmp mangament application
 * Copyright (C) 1998 Gregory McLean
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc.,  59 Temple Place - Suite 330, Cambridge, MA 02139, USA.
 *
 * Abstract database interface api
 */
#ifndef __DB_INTERFACE_H__
#define __DB_INTERFACE_H__

/*
 * Generic database structure
 * For connections to the databases.
 */

typedef struct __db_conn__ {
  char     *db_host;                    /* Host that the database is on */
  char     *db_user;                    /* the username we should pass */
  char     *db_password;                /* password we should use */
  char     *db_options;                 /* Database specific options */
  char     *db_tty;                     /* Debugging terminal if appropriate */
  char     *db_name;                    /* Database name if applicable */
  int      db_port;                     /* tcp/ip port to connect on */
  gpointer db_handle;                   /* Generic pointer to database 
					   specific handle */
  gpointer db_henv;                     /* Pointer to database's host env
					   solid uses this. */
  gpointer db_hdbc;                     /* Another solid thing */
} db_conn;

/* 
 * The generic query structure
 * Used to smooth the diffrences in api between db's
 */
typedef struct __db_query__ {
  gpointer db_handle;                  /* Specific handle for db's */
  gint     num_rows;                   /* Rows returned from query */
  gint     num_cols;                   /* columns returned */
  gchar    *query_string;              /* The actual query */
  gpointer result;                     /* pointer to the result */
} db_query;


/*
 * Global generic db functions 
 */

gboolean       db_init               (void);
gboolean       db_connect            (db_conn *db_connection);

#endif

/* EOF */

