# Makefile for debian linux /usr/doc/git

srcdir		= .

SHELL		= /bin/sh
MAKEINFO	= makeinfo
TEXI2DVI	= texi2dvi
INSTALL		= /usr/bin/install -c
INSTALL_PROGRAM	= ${INSTALL}
INSTALL_DATA	= ${INSTALL} -m 644
HOST		= i386-unknown-linux

all:
	@echo "type \"make dvi\" or \"make info\""

dvi:	git.dvi

git.dvi: $(srcdir)/git.texinfo
	$(TEXI2DVI) $(srcdir)/git.texinfo

info:	git.info git.info-1 git.info-2 git.info-3

git.info: $(srcdir)/git.texinfo
	$(MAKEINFO) $(srcdir)/git.texinfo

git.info-1: $(srcdir)/git.texinfo
	$(MAKEINFO) $(srcdir)/git.texinfo

git.info-2: $(srcdir)/git.texinfo
	$(MAKEINFO) $(srcdir)/git.texinfo

git.info-3: $(srcdir)/git.texinfo
	$(MAKEINFO) $(srcdir)/git.texinfo

install:
	$(INSTALL_DATA) $(srcdir)/git.info   $(infodir)/git.info
	$(INSTALL_DATA) $(srcdir)/git.info-1 $(infodir)/git.info-1
	$(INSTALL_DATA) $(srcdir)/git.info-2 $(infodir)/git.info-2
	$(INSTALL_DATA) $(srcdir)/git.info-3 $(infodir)/git.info-3

uninstall:
	cd $(infodir) && rm -f git.info*

clean:
	rm -f *~ *.bak core* tutu* gogu*
	rm -f git.fns git.cps git.fn git.dvi git.cps git.cp
	rm -f git.aux git.log git.toc git.tp git.vr git.vrs
	rm -f git.pg git.ky git.kys git.ps

