/* u_probe.h		-*- C++ -*-
 *$Header: /al/acs/src/RCS/u_probe.h,v 9.21 95/10/21 18:11:21 al Exp $
 * single probe item
 */
#ifndef U_PROBE_H
#define U_PROBE_H
#include "util.h"
/*--------------------------------------------------------------------------*/
class CKT_BASE;
struct xprobe_t;
/*--------------------------------------------------------------------------*/
class PROBE {
private:
  char	    what[LABELEN+1];    
  int	    node;
  CKT_BASE* brh;
  double    low,high;
public:
	PROBE(const char *What="", int Node=0, CKT_BASE *Brh=NULL,
	      double Lo=0, double Hi=0.);
	void	  limit(double Lo,double Hi){low = Lo; high = Hi;}
	char*	  label()const;
	double	  value()const;
	char*	  svalue()const;
	xprobe_t  xvalue()const;
	CKT_BASE* object()const	{return brh;}
	double	  lo()const	{return low;}
	double	  hi()const	{return high;}
	double	  range()const	{return high-low;}
	int	  inrange()const{return inorder(low,value(),high);}
private:
	double	  probe_node()const;
	double	  trprobe_node()const;
	double	  acprobe_node()const;
};
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
#endif
