/* d_vccs.cc
 *$Header: /al/acs/src/RCS/d_vccs.cc,v 9.20 95/10/15 22:31:22 al Exp $
 * functions for vccs
 */
#include "ap.h"
#include "d_vccs.h"
#include "io.h"
/*--------------------------------------------------------------------------*/
//	void	DEV_VCCS::parse(CS&);
//	void	DEV_VCCS::print(int,int)const;
//	void	DEV_VCCS::expand();
// 	int	DEV_VCCS::dotr();
// 	void	DEV_VCCS::doac();
/*--------------------------------------------------------------------------*/
void DEV_VCCS::parse(CS& cmd)
{
  parselabel(cmd);
  parsenodes(cmd,NUMNODES);
  parseexpr(cmd);
}
/*--------------------------------------------------------------------------*/
void DEV_VCCS::print(int where, int detail)const
{
  printlabel(where);
  printnodes(where,NUMNODES);
  printexpr(where);
  mputc('\n', where);
}
/*--------------------------------------------------------------------------*/
void DEV_VCCS::expand()
{
  assert(loss == 0.);
  m0.f1 = y0.f1 = val;
  y0.f0 = LINEAR;
  m0.c0 = 0.;
  acg = ev = val;
}
/*--------------------------------------------------------------------------*/
int DEV_VCCS::dotr()
{
  if (trfun){
    trsetup();
    m0.x = volts_limited(n[IN1],n[IN2]);
    y0.x = m0.x;
    (*trfun)(this);
    m0.c0 = y0.f0 - y0.x * y0.f1;
    m0.f1 = y0.f1;
    return converged = conv_check();
  }else if (probes){
    trsetup();
    m0.x = n[IN1].v0() - n[IN2].v0();
    y0.x = m0.x;
    y0.f0 = y0.x * y0.f1;
    assert(y0.f1 == val);
    assert(m0.f1 == val);
    assert(m0.c0 == 0.);
    return converged = TRUE;
  }else{
    assert(m0.f1 == val);
    assert(m0.c0 == 0.);
    return converged = TRUE;
  }
}
/*--------------------------------------------------------------------------*/
void DEV_VCCS::doac()
{
  if (acfun){
    acbias = n[IN1].vdc() - n[IN2].vdc();
    ev = (*acfun)(this);
    acg = ev;
  }else if (trfun){
    acg = ev = y0.f1;
  }else{
    assert(acg == val);
  }
  acload_active(); 
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
