/* d_logic.h		-*- C++ -*-
 *$Header: /al/acs/src/RCS/d_logic.h,v 9.24 95/10/24 22:45:40 al Exp $
 * data structures and defaults for logic model.
 */
#ifndef D_LOGIC_H
#define D_LOGIC_H
#include "e_model.h"
#include "e_elemnt.h"
/*--------------------------------------------------------------------------*/
class MODEL_LOGIC : public MODEL_BASE {
friend class DEV_LOGIC;
friend	NODE*	tologic(const MODEL_LOGIC*,const node_t*);
friend	double	toanalog(const MODEL_LOGIC*,const node_t*);
public:
	MODEL_LOGIC(const char *name = "");
	MODEL_LOGIC(const MODEL_LOGIC& p){assert(!"copy-model??");}
	CARD*	clone()const{return new MODEL_LOGIC(*this);}
	void	parse(CS&);
 	void	print(int,int)const;
private:
				/* ----- digital mode ----- */
  double	delay;		/* propagation delay */
				/* -- conversion parameters both ways -- */
  double	vmax;		/* nominal volts for logic 1 */
  double	vmin;		/* nominal volts for logic 0 */
  double	range;		/* vmax - vmin */
  				/* ---- D to A conversion ---- */
  double	rise;		/* rise time (time in slope) */
  double	fall;		/* fall time (time in slope) */
  double	rs;		/* series resistance -- strong */
  double	rw;		/* series resistance -- weak */
  				/* ---- A to D conversion ---- */
  double	th1;		/* threshold for 1 as fraction of range */
  double	th0;		/* threshold for 0 as fraction of range */
  				/* ---- quality judgement parameters ---- */
  double	mr;		/* margin rise - how much worse rise can be */
  double	mf;		/* margin fall - how much worse fall can be */
  double	over;		/* overshoot limit - as fraction of range */
};
/*--------------------------------------------------------------------------*/
enum {PORTSPERGATE = 10};
enum gatetype_t {lNONE, lAND, lNAND, lOR, lNOR, lXOR, lINV};
/*--------------------------------------------------------------------------*/
struct logic {
   generic_t	*x;
   size_t	ssize;
   const MODEL_BASE *model;
   char 	modelname[LABELEN+1];
   node_t	n[PORTSPERGATE+1];	/* up to here must match subckt */
   					/* PORTSPERGATE <= PORTSPERSUBCKT */
   gatetype_t	type;			/* and, or, etc. */
   unsigned	incount;		/* count input nodes */
};
/*--------------------------------------------------------------------------*/
class DEV_LOGIC : public ELEMENT {
public:
	DEV_LOGIC();
	DEV_LOGIC(const DEV_LOGIC& p);
	~DEV_LOGIC(){--Count;}
	CARD*	clone()const{return new DEV_LOGIC(*this);}
	void	parse(CS&);
 	void	print(int,int)const;
	double	probe_tr_num(const char*)const;
	double	probe_ac_num(const char*)const;
	void	expand();
	int	dotr();
	void	trload();
	void	trunload();
	void	doac();
	double	tr_review();
static	int	count(){return Count;}
private:
  smode_t	gatemode;
  static int	Count;
};
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
#endif
