/* u_status.cc
 *$Header: /al/acs/src/RCS/c_status.cc,v 9.20 95/10/15 22:33:37 al Exp $
 * Displays the status of the system.  Makes all the calculations associated
 * with allocating memory but does not actually allocate it, unless necessary
 * to make the rest of the calculations.
 *
 *   If "allocate" is changed, this must also be changed.
 */
#include "io.h"
#include "m_matrix.h"
#include "c_comand.h"
#include "d_diode.h"
#include "d_logic.h"
#include "d_mos.h"
#include "d_subckt.h"
#include "u_status.h"
#include "s__.h"
/*--------------------------------------------------------------------------*/
//	void	CMD::status(CS&);
/*--------------------------------------------------------------------------*/
void CMD::status(CS& cmd)
{ 
  mprintf(IO::mstdout,"ACS   System status\n");
  SIM::init();
    
  STATUS::overhead = STATUS::total - STATUS::evaluate - STATUS::load
  	- STATUS::lud - STATUS::back - STATUS::output - STATUS::review;

  mprintf(IO::mstdout,
  "command      --------  last  --------    --------  total  --------\n");
  mprintf(IO::mstdout,
  "               user      sys    total       user      sys    total\n");
  STATUS::get.print();
  STATUS::op.print();
  STATUS::dc.print();
  STATUS::tran.print();
  STATUS::four.print();
  STATUS::ac.print();

  mprintf(IO::mstdout,
  "function     --------  last  --------    --------  total  --------\n");
  mprintf(IO::mstdout,
  "               user      sys    total       user      sys    total\n");
  STATUS::setup.print();
  STATUS::order.print();

  
  mprintf(IO::mstdout,
  "function     --------  last  --------    --------  total  --------\n");
  mprintf(IO::mstdout,
  "               user      sys    total       user      sys    total\n");
  STATUS::evaluate.print();
  STATUS::load.print();
  STATUS::lud.print();
  STATUS::back.print();
  STATUS::review.print();
  STATUS::output.print();
  STATUS::overhead.print();
  STATUS::total.print();

  mprintf(IO::mstdout,
	  "iterations: op=%d, dc=%d, tran=%d, fourier=%d, total=%d\n",
	  STATUS::iter[sOP], STATUS::iter[sDC], STATUS::iter[sTRAN],
	  STATUS::iter[sFOURIER], STATUS::iter[iTOTAL]);
  mprintf(IO::mstdout,
	  "nodes: user=%d, subckt=%d, model=%d, total=%d\n",
	  STATUS::user_nodes, STATUS::subckt_nodes, STATUS::model_nodes,
	  STATUS::total_nodes);
  mprintf(IO::mstdout,
	  "diodes=%d, bjts=%d, jfets=%d, mosfets=%d, gates=%d, subckts=%d\n",
	  DEV_DIODE::count(), 0, 0, DEV_MOS::count(),
	  DEV_LOGIC::count(), DEV_SUBCKT::count());
  mprintf(IO::mstdout,"density=%.1f%%\n", SIM::aa.density()*100.);
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
