/* u_prbcmd.cc
 *$Header: /al/acs/src/RCS/c_prbcmd.cc,v 9.24 95/10/24 22:43:50 al Exp $
 * probe and plot commands
 * set up print and plot (select points, maintain probe lists)
 * command line operations
 */
#include "ap.h"
#include "error.h"
#include "io.h"
#include "c_comand.h"
#include "u_probe.h"
#include "u_prblst.h"
#include "s__.h"
/*--------------------------------------------------------------------------*/
//	void	CMD::alarm(CS&);
//	void	CMD::plot(CS&);
//	void	CMD::print(CS&);
static	void	do_probe(CS&,PROBELIST*);
/*--------------------------------------------------------------------------*/
PROBELIST PROBE_LISTS::alarm[sCOUNT]; /* list of alarm points */
PROBELIST PROBE_LISTS::plot[sCOUNT];  /* list of plot points */
PROBELIST PROBE_LISTS::print[sCOUNT]; /* list of print points */
PROBELIST PROBE_LISTS::store[sCOUNT]; /* list of points to store for postproc */
/*--------------------------------------------------------------------------*/
void CMD::alarm(CS& cmd)
{
  do_probe(cmd,PROBE_LISTS::alarm);
}
/*--------------------------------------------------------------------------*/
void CMD::plot(CS& cmd)
{
  IO::plotset = TRUE;
  do_probe(cmd,PROBE_LISTS::plot);
}
/*--------------------------------------------------------------------------*/
void CMD::print(CS& cmd)
{
  IO::plotset = FALSE;
  do_probe(cmd,PROBE_LISTS::print);
}
/*--------------------------------------------------------------------------*/
static void do_probe(CS& cmd, PROBELIST *probes)
{
  enum {ADD, DELETE, NEW} action;
  int simtype = sNONE;

  if (cmd.match('-')){
    action = DELETE;
    cmd.skip();
  }else if (cmd.match('+')){
    action = ADD;
    cmd.skip();
  }else{
    action = NEW;
  }

  cmd.argparse(ONEPASS,
	"TRan",	   aENUM,   &simtype,	sTRAN,
	"AC",	   aENUM,   &simtype,	sAC,
	"DC",	   aENUM,   &simtype,	sDC,
	"OP",	   aENUM,   &simtype,	sOP,
	"FOurier", aENUM,   &simtype,	sFOURIER,
	"");
  if (!simtype){
    if (cmd.end()){
      probes[sTRAN].list("tran");
      probes[sAC].list("ac");
      probes[sDC].list("dc");
      probes[sOP].list("op");
      probes[sFOURIER].list("fourier");
    }else if (cmd.pmatch("CLEAR")){
      int ii;
      for (ii = sSTART;  ii < sCOUNT;  ++ii)
	probes[ii].clear();
    }else{
      cmd.warn(bERROR);
    }
  }else{
    if (cmd.end()){
      probes[simtype].list("");
    }else if (cmd.pmatch("CLEAR")){
      probes[simtype].clear();
    }else{
      SIM::init();
      if (cmd.match('-')){
	action = DELETE;
	cmd.skip();
      }else if (cmd.match('+')){
	action = ADD;
	cmd.skip();
      }
      if (action == NEW){
	probes[simtype].clear();
	action = ADD;
      }
      while (cmd.more()){
	if (cmd.match('-')){
	  action = DELETE;
	  cmd.skip();
	}else if (cmd.match('+')){
	  action = ADD;
	  cmd.skip();
	}
	if (action == DELETE){
	  probes[simtype] -= cmd;
	}else{
	  probes[simtype] += cmd;
	}
      }
    }
  }
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
