/* c_file.cc
 *$Header: /al/acs/src/RCS/c_file.cc,v 9.9 95/06/08 20:11:42 al Exp $
 * log and > commands
 * log == commands log to a file
 * >   == all output to a file (redirect stdout)
 * bare command closes the file
 * can be nested RECURSE deep
 */
#include "ap.h"
#include "error.h"
#include "io.h"
#include "c_comand.h"
#include "declare.h"	/* getcmd (self) */
/*--------------------------------------------------------------------------*/
//	void	CMD::logger(CS&);
//	void	CMD::file(CS&);
	char*	getcmd(const char*,char*,int);
/*--------------------------------------------------------------------------*/
static int   mout;		/* > file bitmap		*/
static int   mlog;		/* log file bitmap		*/
/*--------------------------------------------------------------------------*/
/* cmd_log: "log" command processing
 * open a file for logging (history)
 * arg is name of file
 * no arg closes the one most recently opened
 * the file will contain a list of commands executed, for use by "<"
 * multiple files can be open, they are nested, output to all.
 */
void CMD::logger(CS& cmd)
{
  static FILE *files[RECURSE];
  static int nest = 0;

  if (cmd.more()){			/* a file name .. open it */
    if (nest >= RECURSE){
      error(bWARNING, "too many files open\n");
    }else{
      const char *access;
      access = "w";
      while (cmd.match('>')){
	access = "a";
	cmd.skip();
	cmd.skipbl();
      }
      files[nest] = xopen(cmd,"",access);
      if (files[nest]){
	mlog |= 1<<fileno(files[nest]);
	nest++;
      }
    }
  }else{				/* empty command -- close a file */
    if (nest == 0){
      error(bWARNING, "no files open\n");
    }else{
      nest--;
      mlog &= ~(1<<fileno(files[nest]));
      fclose(files[nest]);
      files[nest] = (FILE*)NULL;
    }
  }
}
/*--------------------------------------------------------------------------*/
/* cmd_file: ">" command processing
 * open a file for all output
 * the file will contain a copy of all screen output.
 * arg is name of file
 * no arg closes it
 * the file will contain all that would go to stdout
 */
void CMD::file(CS& cmd)
{
  static FILE *files[RECURSE];
  static int nest = 0;
  
  if (cmd.more()){			/* a file name .. open it */
    if (nest >= RECURSE){
      error(bWARNING, "too many files open\n");
    }else{
      const char *access;
      access = "w";
      while (cmd.match('>')){
	access = "a";
	cmd.skip();
	cmd.skipbl();
      }
      files[nest] = xopen(cmd,"",access);
      if (files[nest]){
	mout        |= 1<<fileno(files[nest]);
	IO::mstdout |= 1<<fileno(files[nest]);
	nest++;
      }
    }
  }else{				/* empty command -- close a file */
    if (nest == 0){
      error(bWARNING, "no files open\n");
    }else{
      nest--;
      mout        &= ~(1<<fileno(files[nest]));
      IO::mstdout &= ~(1<<fileno(files[nest]));
      fclose(files[nest]);
      files[nest] = (FILE*)NULL;
    }
  }
}
/*--------------------------------------------------------------------------*/
/* getcmd: get a command.
 * if "fin" is stdin, display a prompt first.
 * Also, actually do logging, echo, etc.
 */
char *getcmd(const char *prompt, char *buffer, int buflen)
{
  pllocate();
  mputs( prompt, IO::mstdout );
  mputs( " \b",  IO::mstdout );		/* flush out buffer */
  if (!fgets(buffer, buflen, stdin)){
    error(bEXIT, "\n");
  }
  mputc('\r', IO::mstdout&~mout);	/* reset col counter */
  trim(buffer);
  mprintf(mlog | mout, "%s\n", buffer);
  return buffer;
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
