/* ap_skip.c
 *$Header: /al/acs/src/RCS/ap_skip.cc,v 8.1 95/04/23 18:19:25 al Exp $
 * collection of functions to skip input
 * all except skip1 skip leading whitespace, skip whatever is being skipped,
 * then skip trailing whitespace.
 */
#include "ap.h"
/*--------------------------------------------------------------------------*/
//	void	CS::skipbl();
//	int	CS::skip1b(const char*);
//	int	CS::skip1(const char*);
//	void	CS::skiparg();
/*--------------------------------------------------------------------------*/
/* skipbl: skip whitespace.  (any non-graphic character is ws)
 * =,(,) are also ws
 * update string pointer
 * pointer points to first non-space
 */
void CS::skipbl()
{
  while (peek()  &&  (!isgraph(peek())))
    skip();
}
/*--------------------------------------------------------------------------*/
int CS::skip1b(const char *t)
{
  skipbl();
  int s = skip1(t);
  skipbl();
  return s;
}
/*--------------------------------------------------------------------------*/
int CS::skip1(const char *t)
{
  if (match1(t)){
    skip();
    return 1;
  }else{
    return 0;
  }
}
/*--------------------------------------------------------------------------*/
void CS::skiparg()
{
  if (!skipcom()){
    if (peek())
      skip();
    while (is_alpha() || is_pfloat())
      skip();
    skipcom();
  }
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
