// This may look like C code, but it is really -*- C++ -*-

//<copyright>
//
// Copyright (c) 1993,94,95,96,97
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
//
// This file is part of VRweb.
//
// VRweb is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// VRweb is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with VRweb; see the file LICENCE. If not, write to the
// Free Software Foundation, Inc., 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// Note that the GNU General Public License does not permit incorporating
// the Software into proprietary or commercial programs. Such usage
// requires a separate license from IICM.
//
//</copyright>

//<file>
//
// Name:        hg3dvw.h
//
// Purpose:     interface to class HgIv3dViewer
//
// Created:     21 Jun 93   Michael Pichler
//
// Changed:     28 Apr 97   Michael Pichler
//
// $Id: hg3dvw.h,v 1.11 1997/04/30 10:33:07 mpichler Exp $
//
//</file>


#ifndef harmony_scene_hg3dvw_h
#define harmony_scene_hg3dvw_h


#include <hyperg/viewer/vwstuff.h>
// abstract viewer base class HgViewer

#include <hyperg/harmony/utils/dcconnect.h>
/* #include <hyperg/Dispatch/rpcservice.h> */
#include <hyperg/Dispatch/iocallback.h>
/* #include <hyperg/Dispatch/rpcbuf.h> */

#include <hyperg/utils/str.h>
class Object;

#include "imgserver.h"

#include <InterViews/enter-scope.h>
class Session;


//<class>
//
// Name: Hg3dViewer; abstract
//
// Purpose:
//
// Hyper-G 3d Viewer, independent of look and feel.
// Used to display 3d documents, stored in sdf format.
// Derived classes add a particular look and feel.
//
//</class>


class SceneWindow;
class Hg3dViewer;
declareIOCallback (Hg3dViewer)


// DcConnect replaces RpcService

class Hg3dViewer: public HgViewer, public DcConnect, public ImageServerCallback
{
  public:
    Hg3dViewer (HgViewerManager*, Session*);
    virtual ~Hg3dViewer ();

    // HgViewer
    virtual void load (                 // load document
      const char* doc,                  //   document info
      const char* anchors,              //   source anchors
      const char* info = 0              //   feedback for viewer manager
    );

//     virtual void flags (                // session manager state flags
//       int flags
//     );
// flag bits: HistoryBack, HistoryForward

    virtual int port () const;          // return document port

    virtual void browse (               // browse current document
      const char* dest = 0              //   optional destination anchor
    ) = 0;

    virtual void getPos (RString&);     // tell current position (for later browse)

    virtual void updateTitle ()  { }    // show title in message line
    virtual void getLangField (         // extract language dependent field
      const char* /*field*/, const Object& /*obj*/, RString& /*fstring*/
    )  { }

    // editing possibilities not yet supported (may be implemented in HgIv3dViewer
    // virtual void doEdit (const RString& /*object*/, const RString& /*anchors*/) {}
    // virtual void newDoc (int /*refno*/) {}

    virtual void cancelRequest (const char*);  // cancel (invalid) request

    void clearAllRequests ()  { imgserver_.clearAllRequests (); }

    void parseURL (const char* url, const char* docurl, RString& msg)
    { // parse URL into Hyper-G object
      RString absurl;
      imgserver_.parseURL (url, docurl, msg, absurl);
    }

    virtual void terminate ();          // terminate viewer

    // ImageServerCallback: reading data
    int readImage (Material* mat, QvTexture2* tex, const char* filename);
    int readInlineURL (QvWWWInline* nodeI, QvTexture2* nodeT, const char* filename, const char* absurl);

    // ImageServerCallback: feedback
    void requestImage (const char* texname);
    void requestURL (const char* url, int texture);
    void requestFinished ();

    // local
    const Object& docObj () const       // get whole document object
    { return docobj_; }
    const RString& objIdStr () const    // get current document ID: "0x8f"
    { return objidstr_; }
    const RString& docIdStr () const    // get current document ID: "ObjectID=0x8f\n"
    { return docidstr_; }
    const RString& docURL () const      // get current document URL
    { return docurl_; }
    const RString& lastURL () const     // get most recent document/inline URL
    { return lasturl_; }
    // const RString& sourceAnchors () const
    // { return srcanchstr_; }

    void storeSourceAnchors ();         // store source anchors (from load)

    void requestURLnode (QvWWWInline* nodeI, QvTexture2* nodeT, const char* url, const char* docurl)
    { imgserver_.requestURLdata (nodeI, nodeT, url, docurl); }

    void requestTextures ()  { imgserver_.handleRequests (1); }

  protected:
    SceneWindow* scene_;

  private:
    virtual void readingCompleted ()  { }  // readInput got whole document

    void createReader (int fd);
    int readInput (int fd);

    void storeanchor (Object&);         // store anchor definition

    IOCallback(Hg3dViewer) read_callback_;

    HgViewerManager* manager_;
    int terminated_;
    int pipe_port_;                     // document port number
    int to_close_;                      // document port to close
    Object docobj_;                     // the whole document object
    RString objidstr_;                  // object id string of current document
    RString docidstr_;                  // document info: "ObjectID=<objectidstring>\n"
    RString docurl_;                    // URL of current document
    RString lasturl_;                   // URL of most recent document/inline data
    RString srcanchstr_;                // source anchors (got from load)

    ImageServer imgserver_;

}; // Hg3dViewer


#endif
