// This may look like C code, but it is really -*- C++ -*-
// 
// <copyright> 
//  
//  Copyright (c) 1997
//  wer auch immer ...
//  
// </copyright> 
// 
// 
// <file> 
// 
// Name:        tcpmatch.h
// 
// Purpose:     
// 
// Created:     20 Feb 1997   Joerg Faschingbauer
// 
// Modified:    
// 
// Description: 
// 
// $Id: tcpmatch.h,v 1.4 1997/02/26 19:46:38 jfasch Exp $
// 
// $Log: tcpmatch.h,v $
// Revision 1.4  1997/02/26 19:46:38  jfasch
// acronym members
//
// Revision 1.3  1997/02/24 11:12:38  jfasch
// const inline member functions
//
// Revision 1.2  1997/02/21 14:06:54  jfasch
// copy enabled
//
// Revision 1.1  1997/02/21 12:39:59  jfasch
// Initial revision
//
// 
// </file> 
#ifndef hg_utils_tcpmatch_h
#define hg_utils_tcpmatch_h

#include "inetaddr.h"

class TCPMatch {
public:
   enum AddrOp {
     TA_NEG,
     TA_POS
   } ;
   enum PortOp {
     TP_G,
     TP_L,
     TP_GE,
     TP_EQ,
     TP_LE,
     TP_NE
   } ;
   
public:
   TCPMatch() : addrop_(TA_NEG), portop_(TP_NE) {} // match every address
   TCPMatch (const INETAddress&, in_addr mask, AddrOp, PortOp) ;
   TCPMatch (const TCPMatch&) ;

   const INETAddress& address() const { return addr_; }
   const in_addr& mask() const { return mask_; }
   AddrOp addrOp() const { return addrop_; }
   PortOp portOp() const { return portop_; }
   const char* addrOpAcronym() const { return addrOpAcronym(addrop_); }
   const char* portOpAcronym() const { return portOpAcronym(portop_); }

   TCPMatch& operator = (const TCPMatch&) ;
   
   bool match (const INETAddress&) const ;

   static const char* addrOpAcronym (AddrOp) ;
   static const char* portOpAcronym (PortOp) ;

private:
   INETAddress addr_ ;
   in_addr mask_ ;
   AddrOp addrop_ ;
   PortOp portop_ ;

public:
   static const char* version2 ;
} ;
static const char* TCPMatch_version = TCPMatch::version2 ;

inline TCPMatch& TCPMatch :: operator = (const TCPMatch& m) {
   addr_ = m.addr_ ;
   mask_ = m.mask_ ;
   addrop_ = m.addrop_ ;
   portop_ = m.portop_ ;
   return *this ;
}

inline TCPMatch :: TCPMatch (const TCPMatch& m) {
   operator = (m) ;
}

#endif
