;; font lock stuff
;; use this to transform code files into html with my font lock settings - davidw
;; $Id: font-lock-stuff.el,v 1.1.2.3 2000/03/03 15:20:10 davidw Exp $

(setq files-to-htmlize '("mod_dtcl.c" 
			 "two-mode-mode.el"
			 "dtcl.tcl"
			 "globalscript.tcl"
			 "infodebug.tcl"
			 "testdtcl.tcl"
			 "Makefile"))

(setq files-to-clean '("mod_dtcl.html" 
		       "two-mode-mode.html"
		       "dtcl.html"
		       "globalscript.html"
		       "infodebug.html"
		       "testdtcl.html"
		       "Makefile.html"))

(defun flscreate ()
  (interactive)
  (global-font-lock-mode t)
  (add-hook 'font-lock-mode-hook 
	    '(lambda ()
	       (setq font-lock-maximum-decoration t)
	       (set-face-foreground (quote font-lock-string-face) "DimGrey")
	     (set-face-foreground (quote font-lock-constant-face) "Violet")
	     (set-face-foreground (quote font-lock-variable-name-face) "ForestGreen")
	     (set-face-foreground (quote font-lock-type-face) "SteelBlue")))
  
  (load-file "htmlize.el")
  (htmlize-many-files files-to-htmlize))

(defun flsclean ()
  (interactive)
  (let ((lst files-to-clean))    
    (while lst
      (if (file-exists-p (car lst))
	  (delete-file (car lst)))
      (setq lst (cdr lst)))))
		   