// Copyright 1998 Zanshin Inc.                       <http://www.zanshin.com/>

// The contents of this file are subject to the Zanshin Public License Version
// 1.0 (the "License"); you may not use this file except in compliance with the
// License.  You should have received a copy of the License with Latte; see
// the file COPYING.  You may also obtain a copy of the License at
// <http://www.zanshin.com/ZPL.html>.
// 
// Software distributed under the License is distributed on an "AS IS" basis,
// WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
// for the specific language governing rights and limitations under the
// License.
// 
// The Original Code is Latte.
// 
// The Initial Developer of the Original Code is Zanshin, Inc.

#include <latte.h>

Latte_Activation::Latte_Activation(Latte_BindingEnv &env) :
  m_env(&env), m_outer(0)
{
}

Latte_Activation::Latte_Activation(Latte_BindingEnv &env,
				   Latte_Activation &outer) :
  m_env(&env), m_outer(&outer)
{
}

Refcounter<Latte_Obj> &
Latte_Activation::lookup(unsigned long depth,
			 unsigned long offset) const
{
  if (depth) {
    if (!m_outer.get())
      throw ImpossibleDepth();	// xxx should never occur?

    return m_outer->lookup(depth - 1, offset);
  }

  if (offset >= m_objs.size())
    mutate(m_objs).resize(offset + 1, latte_false());

  return *(mutate(m_objs).begin() + offset);
}

Refcounter<Latte_Obj> &
Latte_Activation::lookup(const shstring &name) const
{
  unsigned long depth;
  unsigned long offset;

  m_env->lookup(name, depth, offset);
  return lookup(depth, offset);
}

unsigned long
Latte_Activation::define(const shstring &name,
			 const Refcounter<Latte_Obj> &val)
{
  unsigned long offset = m_env->define(name);
  lookup(0, offset) = val;

  return offset;
}
