<?php
/*

 File: ldap.search.php3

 IMP: Copyright 1999, 2000 Charles J. Hagenbuch <chuck@horde.org>

 You should have received a copy of the GNU Public
 License along with this package; if not, write to the
 Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 Boston, MA 02111-1307, USA.

 */

require '../lib/horde.lib';
require './lib/imp.lib';
require './config/ldap.php3';
require './config/defaults.php3';
require './config/lang.php3';
require './config/html.php3';

$language = select_lang();
require './lib/postconf.php3';
require "./locale/$language/contacts.lang";
require './locale/local/contacts.lang';
$help_file = 'contacts.help';
require "./locale/defines/$help_file";

error_reporting(1);

$title            = '';
$sidebar          = false;

require "$default->include_dir/contacts/header.inc";

?>

<script language="JavaScript">


function AlertMissingParent() {
   alert('<?php echo addslashes($lang->alert_no_compose) ?>');
}


function ClearSelection() {
   window.document.f_ldap_result.collect_results.value = "";
}


function AddSelection() {
   var prefix = "";
   
   for (i=0 ; i < document.f_ldap_result.addr_selection.length ; i++) {
      if ( document.f_ldap_result.addr_selection[i].selected) {
         if ( window.document.f_ldap_result.collect_results.value ) {
            prefix=", ";
         }
	 window.document.f_ldap_result.collect_results.value = window.document.f_ldap_result.collect_results.value + prefix + document.f_ldap_result.addr_selection[i].value;
      }
   }
}

function setFields_ins_ldap () {

   for (i=0 ; i < document.f_ldap_result.addr_selection.length ; i++) {
      if ( document.f_ldap_result.addr_selection[i].selected) {
   window.document.f_ldap_result.collect_results.value = document.f_ldap_result.addr_selection[i].value;
      }                
   }

}


function InsertLDAPto() {
   
   var prefix = "";
   var t_parent = typeof parent.opener;
   
   var t_compose = typeof parent.opener.document.compose;
   
   if ( t_compose != "undefined" ) {
      if ( parent.opener.document.compose.to.value ) {
         if ( window.document.f_ldap_result.collect_results.value ) {
	   prefix = ", ";
         }
      }
      parent.opener.document.compose.to.value = parent.opener.document.compose.to.value + prefix + window.document.f_ldap_result.collect_results.value
	window.document.f_ldap_result.collect_results.value = "";
   } else {
      AlertMissingParent();
   }
   
}

function InsertLDAPcc() {
  
   var prefix = "";
   var t_parent = typeof parent.opener;
  
   var t_compose = typeof parent.opener.document.compose;

   if ( t_compose != "undefined" ) {
      if ( parent.opener.document.compose.cc.value ) {
         if ( window.document.f_ldap_result.collect_results.value ) {
           prefix = ", ";
         }
      }
      parent.opener.document.compose.cc.value = parent.opener.document.compose.cc.value + prefix + window.document.f_ldap_result.collect_results.value
        window.document.f_ldap_result.collect_results.value = "";
   } else {
      AlertMissingParent();
   }

}

function InsertLDAPbcc() {
 
   var prefix = "";
   var t_parent = typeof parent.opener;
 
   var t_compose = typeof parent.opener.document.compose;

   if ( t_compose != "undefined" ) {
      if ( parent.opener.document.compose.bcc.value ) {
         if ( window.document.f_ldap_result.collect_results.value ) {
           prefix = ", ";
         }
      }
      parent.opener.document.compose.bcc.value = parent.opener.document.compose.bcc.value + prefix + window.document.f_ldap_result.collect_results.value
        window.document.f_ldap_result.collect_results.value = "";
   } else {
      AlertMissingParent();
   }

}

function InsertLDAPaddr() {

    if ( window.document.f_ldap_result.collect_results.value ) {
        re = /(.*\S)\s*<(.*)>/;
        res = /(.*)@(.*)/;
        rest = /"(.*)"/;
        temp = window.document.f_ldap_result.collect_results.value;
        newemail=temp.replace(re, "$2");
        tempname=temp.replace(rest, "$1");
        newname=tempname.replace(re, "$1");
        newnick=newemail.replace(res, "$1");
        parent.insert.document.addressbook.new_address.value = newemail;
        parent.insert.document.addressbook.new_fullname.value = newname;
        parent.insert.document.addressbook.new_nickname.value = newnick;
        window.document.f_ldap_result.collect_results.value = "";
    }

}


</script>

<?php

    echo "<font size=-1>";

if ($ldap_options) {
   switch ($ldap_options) {
    case 'begins':
      $str_prefix = '';
      $str_postfix = '*';
      break;
    case 'contains':
      $str_prefix = '*';
      $str_postfix = '*';
      break;
    case 'ends':
      $str_prefix = '*';
      $str_postfix = '';
      break;
    case 'is_strict':
      $str_prefix = '';
      $str_postfix = '';
      break;
    case 'sounds':
      $str_prefix = '';
      $str_postfix = '';
      $sounds = true;
      break;
    default:
      $str_prefix = '*';
      $str_postfix = '*';
      $text_array = explode(' ', $s_text);
   }

} else {
   $str_prefix = '*';
   $str_postfix = '*';
   $text_array = explode(' ', $s_text);
}


if ($attr_type) {
  switch ($attr_type) {
  case 'uid':
    $str_search = 'uid';
    break;
  case 'mail':
    $str_search = 'mail';
    break;
  case 'sn':
    $str_search = 'sn';
    break;
  case 'givenname':
    $str_search = 'givenname';
    break;
  case 'ou':
    $str_search = 'ou';
    break;
  case 'mailalternateaddress':
    $str_search = 'mailalternateaddress';
    break;
  default:
    $str_search = 'cn';
  }
} else {
  $str_search = 'cn';
}

if (isset($ldap_serv) && $ldap_serv) $lserver = $LDAPServers[$ldap_serv];
else {
   echo $lang->no_ldap_server;
   exit;
}

$str_serv  = $lserver->server;
$str_root = $lserver->root;
$str_sn   = $lserver->sn;
$str_emailattr = $lserver->emailattr;

$ds = ldap_connect($str_serv);

if ($ds) $r = ldap_bind($ds);
else {
   echo $lang->no_ldap_connection;
   exit;
}

if ($r) {
   $normerr = error_reporting();
   error_reporting(0);
   if (count($text_array) == 2 && ( $str_search == 'uid' || $str_search == 'cn' || $str_search == 'sn' || $str_search == 'givenname' ) ) {
      if  ( $str_search == 'cn' ) {
	 $filter = "(|(&($str_search=$text_array[0]*)(sn=$text_array[1]*))(&($str_search=$text_array[1]*)(sn=$text_array[0]*)))";
      } else {
	 $filter = "(|(&($str_search=$text_array[0]*)(cn=$text_array[1]*))(&($str_search=$text_array[1]*)(cn=$text_array[0]*)))";
      }
   } elseif ( $sounds ) {
      if ( ! $ldap_options ) {
         $str_prefix = '*';
         $str_postfix = '*';
      }
      $filter = "$str_search~=$str_prefix$s_text$str_postfix";
   } else {
      $filter = "(&($str_emailattr=*)($str_search=$str_prefix$s_text$str_postfix))";
   }
   $sr=ldap_search($ds,$str_root,$filter);
   $normerr = error_reporting ($normerr);
} else {
   echo $lang->no_ldap_bind;
   exit;
}

if ( $sr ) {
   $info = ldap_get_entries($ds, $sr);
} else {
   echo $lang->too_many_results;
   exit;
}

if ( count($info) >= 2 ) {
   
  
   $addr_list[0] = Array();
   $addr_list[1] = Array();
   $addr_list[2] = Array();
   while ( list( $key, $val ) = each( $info ) ) {
      if ( gettype($val) == 'array' && $val[$str_emailattr][0] ) {
	 
	 if ( $val[$str_sn][0] ) {
	    $addr_list[0][] = $val[$str_sn][0].', ' .$val['givenname'][0]. ' &lt;' .$val[$str_emailattr][0]. '&gt;';
	 } else {
	    $addr_list[0][] = '';
	 }
  	 $addr_list[1][] = $val['ou'][0];
	 // $addr_list[2][] = $val['cn'][0]. ' &lt;' .$val[$str_emailattr][0]. '&gt;';
	 $addr_list[2][] = $val[$str_emailattr][0];
	 $addr_list[3][] = $val['cn'][0];
      }
   }
   asort($addr_list[0]);

   
   while ( list( $key_addr, $val_addr ) = each ( $addr_list[0] ) ) {
      if ( $addr_list[0][$key_addr] ) $not_empty = true ;
   }
   reset($addr_list[0]);

   if ( $not_empty ) {
      echo '<center>';
      echo '<font size=-1>';
      echo '<table border=0 align=center width=95% cellpadding=0 cellspacing=0>';
      echo '<form name="f_ldap_result" action="insert_result" method="post" target="main">';
      echo '<tr>';
      echo "<td colspan=3 bgcolor=\"" .$default->dark_bg. "\" align=\"left\">";
?>
      <?php $default->text_on_dark->start(); ?> <b><?php echo $lang->ldapresults ?> </b></font>  
<?php
      echo '</td></tr>';
      echo "<tr><td align=right><font size=-1><INPUT type=\"button\" Value=\"" . $lang->select .  "\" onClick=\"AddSelection()\">&nbsp;</font></td>";
      echo "<td align=left bgcolor=\"" .$default->item_bg. "\"><font size=-1>";
      echo '<select name="addr_selection" onchange="setFields_ins_ldap()">';
 
      while ( list( $key_addr, $val_addr ) = each ( $addr_list[0] ) ) {
	if ( $addr_list[0][$key_addr] ) {
	  $email = explode('@', $addr_list[2][$key_addr]);
	  $addr = htmlentities(imap_rfc822_write_address($email[0], $email[1], $addr_list[3][$key_addr]));
	  echo "\n<option value=\"" . $addr . '">' . $addr . '</option>';
	}
      }
   
   
   
      echo "</SELECT></font>";
      echo "</td><td bgcolor=\"" . $default->item_bg . "\" rowspan=\"2\" align=\"right\">";
      echo $help->link(CONTACTS_HELP_RESULTS, $help_file, 'imp');
      echo "</td></tr><tr><td align=right><font size=-1>";
      echo "<INPUT type=\"button\" Value=\"" .$lang->ldap_clear. "\" onClick=\"ClearSelection()\">&nbsp;</font>";
      echo "</td><td align=left bgcolor=\"" .$default->item_bg. "\"><font size=-1>";
      echo "<INPUT type=\"text\" SIZE=\"50\" Name=\"collect_results\"></font>";
      echo "</td></tr><tr><td align=center colspan=\"2\"><font size=-1>";
      echo "&nbsp;<INPUT type=\"button\" Value=\"" .$lang->insert_into_to. "\" onClick=\"InsertLDAPto()\">";
      echo "&nbsp;<INPUT type=\"button\" Value=\"" .$lang->insert_into_cc. "\" onClick=\"InsertLDAPcc()\">";
      echo "&nbsp;<INPUT type=\"button\" Value=\"" .$lang->insert_into_bcc. "\" onClick=\"InsertLDAPbcc()\">";
      if ($default->user_use_addressbook) {
	echo "&nbsp;<INPUT type=\"button\" Value=\"" .$lang->ldap_insertaddr. "\" onClick=\"InsertLDAPaddr()\">";
      }
      echo "</font></td></tr></table>";
      echo "</FORM>";
      echo "</CENTER>";
   } else {
     echo $lang->ldap_no_results;
     exit;
   }
} else {
   echo $lang->ldap_no_results;
   exit;
}

if (isset($ds) && $ds) {
   ldap_close($ds);
}

echo "</font>";

require "$default->include_dir/generic-footer.inc";

?>
