/*
 * The contents of this file are subject to the AOLserver Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://aolserver.com/.
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is AOLserver Code and related documentation
 * distributed by AOL.
 * 
 * The Initial Developer of the Original Code is America Online,
 * Inc. Portions created by AOL are Copyright (C) 1999 America Online,
 * Inc. All Rights Reserved.
 *
 * Alternatively, the contents of this file may be used under the terms
 * of the GNU General Public License (the "GPL"), in which case the
 * provisions of GPL are applicable instead of those above.  If you wish
 * to allow use of your version of this file only under the terms of the
 * GPL and not to allow others to use your version of this file under the
 * License, indicate your decision by deleting the provisions above and
 * replace them with the notice and other provisions required by the GPL.
 * If you do not delete the provisions above, a recipient may use your
 * version of this file under either the License or the GPL.
 */



/*
** exutils.h
**
** Header file which contains the defines and prototypes for the utility
** functions in exutils.c
** 
*/

/* Sccsid %Z% %M% %I% %G% */

/*****************************************************************************
** 
** defines and typedefs used 
** 
*****************************************************************************/

#ifndef MAX
#define MAX(X,Y)	(((X) > (Y)) ? (X) : (Y))
#endif

#ifndef MIN
#define MIN(X,Y)	(((X) < (Y)) ? (X) : (Y))
#endif

/*
** Maximum character buffer for displaying a column
*/
#define MAX_CHAR_BUF	(4 * 1024 * 1024)

/*
** Define structure where row data is bound.
*/
typedef struct _ex_column_data
{
	CS_SMALLINT	indicator;
	CS_CHAR		*value;
	CS_INT		valuelen;
} SYB_COLUMN_DATA;

/*****************************************************************************
** 
** protoypes for all public functions 
** 
*****************************************************************************/
/* exutils.c */
extern CS_INT CS_PUBLIC ex_display_dlen PROTOTYPE((
	CS_DATAFMT *column
	));
extern CS_RETCODE CS_PUBLIC ex_display_header PROTOTYPE((
	CS_INT numcols,
	CS_DATAFMT columns[]
	));
extern CS_RETCODE CS_PUBLIC ex_display_column PROTOTYPE((
	CS_CONTEXT *context,
	CS_DATAFMT *colfmt,
	CS_VOID *data,
	CS_INT datalength,
	int indicator
	));
extern CS_VOID CS_PUBLIC ex_panic PROTOTYPE((
	char *msg
	));
extern CS_VOID CS_PUBLIC ex_error PROTOTYPE((
	char *msg
	));
extern CS_RETCODE CS_PUBLIC ex_clientmsg_cb PROTOTYPE((
	CS_CONTEXT *context,
	CS_CONNECTION *connection,
	CS_CLIENTMSG *errmsg
	));
extern CS_RETCODE CS_PUBLIC ex_servermsg_cb PROTOTYPE((
	CS_CONTEXT *context,
	CS_CONNECTION *connection,
	CS_SERVERMSG *srvmsg
	));
extern CS_RETCODE CS_PUBLIC ex_init PROTOTYPE((
	CS_CONTEXT **context
	));
extern CS_RETCODE CS_PUBLIC ex_connect PROTOTYPE((
	CS_CONTEXT *context,
	CS_CONNECTION **connection,
	CS_CHAR *appname,
	CS_CHAR *username,
	CS_CHAR *password,
	CS_CHAR *server
	));
extern CS_RETCODE CS_PUBLIC ex_con_cleanup PROTOTYPE((
	CS_CONNECTION *connection,
	CS_RETCODE status
	));
extern CS_RETCODE CS_PUBLIC ex_ctx_cleanup PROTOTYPE((
	CS_CONTEXT *context,
	CS_RETCODE status
	));
extern CS_RETCODE CS_PUBLIC ex_execute_cmd PROTOTYPE((
	CS_CONNECTION *connection,
	CS_CHAR *cmdbuf
	));
extern CS_RETCODE CS_PUBLIC ex_fetch_data PROTOTYPE((
	CS_COMMAND *cmd
	));
extern CS_RETCODE CS_PUBLIC ex_create_db PROTOTYPE((
	CS_CONNECTION *connection,
	char *dbname
	));
extern CS_RETCODE ex_remove_db PROTOTYPE((
	CS_CONNECTION *connection,
	char *dbname
	));
extern CS_RETCODE ex_use_db PROTOTYPE((
	CS_CONNECTION *connection,
	char *dbname
	));
