/*--------------------------------------------------------------*
 *                                                              *
 *         SUFARY --- Suffix Array ΤΥ饤֥       *
 *                                                              *
 *  file.c - եγĽ                               *
 *                                                              *
 *--------------------------------------------------------------*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/fcntl.h>
#include <sys/stat.h>
#include "sufary.h"

/* %%%%% ؿƱΤδط %%%%%
   sa_openfiles() 
   +- sa_opentextfile()
   +- sa_openarrayfile()
   sa_cloasefiles() 
   +- sa_closetextfile()
   +- sa_closearrayfile()
   %%%%%%%%%%%%%%%%%%%%%%%% */
SUFARY *sa_openfiles(char *s, char *t);
eresult sa_opentextfile(SUFARY *ary, char *s);
eresult sa_openarrayfile(SUFARY *ary, char *s);
void sa_closefiles(SUFARY *ary);
void sa_closetextfile(SUFARY *ary);  /* ƥȥեΥ */
void sa_closearrayfile(SUFARY *ary); /* array եΥ */

DID *sa_opendid(char *fn);
void sa_closedid(DID *d);

/**********************************************
 *        SUFARY *sa_openfiles(char *s, char *t);
 *
 * purpose
 *   ꤵ줿ƥȥե(s)arrayե(t)򳫤
 *   arrayե̾NULL˻ꤹСƥȥե̾
 *   '.ary' ղäΤarrayե̾ˤʤ롣
 *
 * parameters
 *   t : arrayե̾
 *   s : ƥȥե̾
 *
 * return value
 *   줿SUFARYѿ
 **********************************************/
SUFARY *sa_openfiles(char *s, char *t)
{
  SUFARY *newary;
  int tfd, afd;
  char *aryname;

  newary = (SUFARY *)calloc(sizeof(SUFARY), 1);
  if (!newary){
    /* ݼ */
    fprintf(stderr,"new array allocation failed.\n");
    exit (1);
    /* return NULL; */
  }

  /* ե̾γǼ 980126 */
  strcpy(newary->filename,s);

  if (t == NULL){ 
    /*  1 : array file ꤵƤʤ */
    if (sa_opentextfile(newary, s) == ERROR){
      /* ץ󥨥顼 */
      free(newary);
      return NULL;
    }
    /* ary Υե̾ */
    /* t = malloc(strlen(s) + 4); */
    /* allocaϤδؿǤΤͭmallocư˴롣 */
    aryname = (char *)alloca(strlen(s) + 4);
    if ( aryname == NULL ){
      fprintf(stderr,"array filename allocation failed.\n");
      exit(1);
    }
    sprintf(aryname, "%s.ary", s); /* (Rel1.4: .pat -> .ary) */
    if (sa_openarrayfile(newary, aryname) == ERROR){
      sa_closetextfile(newary);
      free(newary);
      return NULL;
    }
    /* free(t); */
  } else {
    if (sa_opentextfile(newary, s) == ERROR){
      free(newary);
      return NULL;
    }
    if (sa_openarrayfile(newary, t) == ERROR){
      sa_closetextfile(newary); /* ? */
      free(newary);
      return NULL;
    }
  }
  return newary;
}


/**********************************************
 *        eresult sa_opentextfile(SUFARY *ary,char *s);
 *
 * purpose
 *   ƥȥե򳫤
 *
 * parameters
 *   ary : ե(ʤ)ǼSUFARYѿ
 *   s   : ƥȥե̾
 * 
 * return value
 *    /  (eresult)
 **********************************************/
eresult sa_opentextfile(SUFARY *ary, char *s)
{
  off_t sz;  /* ե륵 */
  struct stat st;
  int fd;
  caddr_t map;
  
  /* ˥ץ󤵤ƤΤХ */
  if (ary->txtfd > 0 || ary->txtmap){
    sa_closetextfile(ary);
  }

  /* եΥץ */
  if ((fd = open(s, O_RDONLY)) < 0){
    printf("cannot open text file '%s'.\n",s);
    return ERROR;
  }

  fstat(fd, &st);
  sz = st.st_size;

  /* ޥå  use mmap */
  if ((map = mmap((caddr_t)0, sz, PROT_READ, MAP_SHARED, fd, 0))
      == (caddr_t)-1 ){
    printf ("file mapping error. '%s'\n",s);
    return ERROR;
  }

  /* ΤǥǡǼreturn */
  ary->txtfd  = fd;
  ary->txtsz  = sz;
  ary->txtmap = map;

  return CONT;
}

/**********************************************
 *       eresult sa_openarrayfile(SUFARY *ary, char *s);
 *
 * purpose
 *   Array ե򳫤
 *
 * parameters
 *   ary : ե(ʤ)ǼSUFARYѿ
 *   s : Array ե̾
 *
 * return value
 *    /  (eresult)
 **********************************************/
eresult sa_openarrayfile(SUFARY *ary, char *s)
{
  off_t sz;  /* ե륵 */
  FILE *patfile;
  struct stat st;
  int fd;
  caddr_t map;

  /* ˥ץ󤵤ƤΤХ */
  if (ary->aryfd > 0 || ary->arymap){
    sa_closearrayfile(ary);
  }

  if ((fd = open(s, O_RDONLY)) < 0){
    printf("cannot open array file '%s'.\n",s);
    return ERROR;
  }

  fstat(fd, &st);
  sz = st.st_size;

  /* ޥå */
  if ((map = mmap((caddr_t)0, sz, PROT_READ, MAP_SHARED, fd, 0))
      == (caddr_t)-1 ){
    printf ("file mapping error. '%s'\n",s);
    return ERROR;
  }

  /* arrayեΥΤ뤿ν */
  /* Ĥäfdopen()ˤǤʤΤʡ tomoak-i */
  if ((patfile = fopen(s, "r")) == NULL){
    printf("cannot open array file '%s'.\n",s);
    return ERROR;
  }

  fseek(patfile, 0L, 2);
  ary->arraysize = ftell(patfile) / sizeof(long); /* 970715 */

  /* Ĥ */
  fclose(patfile);

  ary->aryfd = fd;
  ary->arysz = sz;
  ary->arymap = ary->aryorig = map;
  ary->left = 0;
  ary->right = ary->arraysize - 1;

  /* left, right ϸϰϤ¦ؤ  980319 */  
  return CONT;
}


/**********************************************
 *       void sa_closefiles(SUFARY *ary);
 *
 * purpose
 *   ꤵ줿եĤ
 * 
 * parameters
 *   ary : Ĥե˴ؤSUFARYѿ
 *
 * return value
 *   ʤ
 *
 * description
 *   ƥȥեarrayեƱĤ
 **********************************************/
void sa_closefiles(SUFARY *ary)
{
  sa_closetextfile(ary);
  sa_closearrayfile(ary);
  free(ary);
  ary = NULL;
  return;
}

/**********************************************
 *        void sa_closetextfile(SUFARY *ary);
 *
 * purpose
 *   ꤵ줿ƥȥեĤ
 * 
 * parameters
 *   ary : Ĥե˴ؤSUFARYѿ
 *
 * return value
 *   ʤ
 **********************************************/
void sa_closetextfile(SUFARY *ary)
{
  if (ary->txtfd != -1){
    /* mmap β */
    munmap(ary->txtmap, ary->txtsz);
    close(ary->txtfd);
  }
  ary->txtmap = NULL;
  ary->txtfd = -1;
  ary->txtsz = 0;
  return;
}

/**********************************************
 *        void sa_closearrayfile(void);
 *
 * purpose
 *   ꤵ줿arrayեĤ륯
 *
 * parameters
 *   ary : Ĥե˴ؤSUFARYѿ
 *
 * return value
 *   ʤ
 **********************************************/
void sa_closearrayfile(SUFARY *ary)
{
  /* ⡧mmap Ĥɬפ뤫 */
  if (ary->aryfd != -1){
    /* mmap β */
    munmap(ary->arymap, ary->arysz);
    close(ary->aryfd);
  }
  ary->arymap = NULL;
  ary->aryorig = NULL;
  ary->aryfd = -1;
  ary->arysz = 0;
  ary->arraysize = 0;
  ary->left = 0;
  ary->right = 0;

  return;
}


/**********************************************
 * DID *sa_opendid(char *fn);
 *
 * purpose
 *   ɥʬ־ե򳫤
 * parameters
 *   fn : ե̾
 * return value
 *    ץ³⡼
 * description
 **********************************************/
DID *sa_opendid(char *fn)
{
  DID *newdid;
  struct stat stat_buf;
  int fd;
  size_t N;
  caddr_t map;

  newdid = (DID *)calloc(sizeof(DID), 1);
  if (!newdid){
    /* ݼ */
    fprintf(stderr,"new did allocation failed.\n");
    exit (1);
  }

  if ((fd = open(fn, O_RDONLY)) < 0){ /* ϥե */
    fprintf(stderr,"ե \"%s\" ץޤ\n", fn);
    exit (1);
  }

  (void)fstat(fd, &stat_buf);
  N = (size_t)stat_buf.st_size;

  if((map = mmap((caddr_t)0, N, PROT_READ, MAP_SHARED, fd, 0))
     == (caddr_t)-1){
    fprintf(stderr,"ERROR: file mapping error. [%s]\n", fn);
    exit(1);
  }
  newdid->didfd = fd;
  newdid->didmap = map;
  newdid->docid = (long *)map;
  newdid->didsize = N / sizeof(long);
  newdid->didsz = N;
  return newdid;
}

void sa_closedid(DID *d)
{
  if (d->didfd != -1){
    /* mmap β */
    munmap(d->didmap, d->didsz);
    close(d->didfd);
  }
  d->didmap = NULL;
  d->didfd = -1;
  d->didsz = 0;
  return;
}

