/*
 * Copyright (C) 1984-1999  Mark Nudelman
 *
 * You may distribute under the terms of either the GNU General Public
 * License or the Less License, as specified in the README file.
 *
 * For more information about less, or for information on how to 
 * contact the author, see the README file.
 */


/*
 * Silly little program to generate the help.c source file
 * from the less.hlp text file.
 * help.c just contains a char array whose contents are 
 * the contents of less.hlp.
 */

#include <stdio.h>

	int
main(argc, argv)
	int argc;
	char *argv[];
{
	int ch;
	int prevch;

	printf("/* This file was generated by mkhelp from less.hlp */\n");
	printf("#include \"less.h\"\n");
	printf("constant char helpdata[] = {\n");
	ch = 0;
	while (prevch = ch, (ch = getchar()) != EOF)
	{
		switch (ch)
		{
		case '\'':
			printf("'\\'',");
			break;
		case '\\':
			printf("'\\\\',");
			break;
		case '\b':
			printf("'\\b',");
			break;
		case '\t':
			printf("'\\t',");
			break;
		case '\n':
			if (prevch != '\r') 
				printf("'\\n',\n");
			break;
		case '\r':
			if (prevch != '\n') 
				printf("'\\n',\n");
			break;
		default:
			if (ch >= ' ' && ch < 0x7f)
				printf("'%c',", ch);
			else
				printf("0x%02x,", ch);
			break;
		}
	}
	/* Add an extra null char to avoid having a trailing comma. */
	printf(" 0 };\n");
	printf("constant int size_helpdata = sizeof(helpdata) - 1;\n");
	return (0);
}
