#include <stdio.h>
#include <unistd.h>
#include <pwd.h>
#include <sys/types.h>

#include "suerr.h"

/* $Id: surm.c,v 1.1 1999/11/27 21:41:00 mag Exp $ */

/*
 * Removes file argv[1] from barracuda home (database)
 */
 
int main(int argc, char **argv)
{	int i;
	struct passwd *barracuda_user, *curr_user;

	/* Proper number of params */
	if (argc<2) exit(ERR_PARAMS_NUM);
	
	/* Running user exists and match */
	if ((curr_user=getpwuid(getuid()))==NULL) exit(ERR_NO_SRCUSER);
	if (strcmp(HTTPD_USER, curr_user->pw_name)) exit(ERR_USER_MISMATCH);
	
	/* Read file name should contain only [a-z][A-Z][0-9].- */
	for (i=0; argv[1][i]; i++)	{
		int c;
		
		c=argv[1][i];
		if ((c>='a' && c<='z') ||
			(c>='A' && c<='Z') ||
			(c>='0' && c<='9') ||
			(c=='.' && argv[1][i+1]!='.') ||
			c=='-'
		) continue;
		else exit(ERR_FILENAME);
	}

	/* Going to barracuda */
	if ((barracuda_user=getpwnam(BARRACUDA_USER))==NULL) exit(ERR_NO_DESTUSER);
	if (setgid(barracuda_user->pw_gid)) exit(ERR_SETGID_FAILS);
	if (setuid(barracuda_user->pw_uid)) exit(ERR_SETUID_FAILS);

	umask(0077);
	if (chdir(barracuda_user->pw_dir)) exit(ERR_CHDIR_FAILS);

	if (remove(argv[1])) exit(ERR_REMOVE_FAILS);
	
	/* Normal termination */
	exit(0);
}
