/*
 * Copyright (c) 1997 Stanford University
 *
 * The use of this software for revenue-generating purposes may require a
 * license from the owners of the underlying intellectual property.
 * Specifically, the SRP protocol may not be used for revenue-generating
 * purposes without license.
 *
 * Within that constraint, permission to use, copy, modify, and distribute
 * this software and its documentation for any purpose is hereby granted
 * without fee, provided that the above copyright notices and this permission
 * notice appear in all copies of the software and related documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT ADVISED OF
 * THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY, ARISING OUT
 * OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef T_SERVER_H
#define T_SERVER_H

#include "t_sha.h"

#if     !defined(P)
#ifdef  __STDC__
#define P(x)    x
#else
#define P(x)    ()
#endif
#endif

#define BLEN 32

struct t_server {
  struct t_num n;
  struct t_num g;
  struct t_num v;
  struct t_num s;

  struct t_num b;
  struct t_num B;

  SHA1_CTX oldhash, hash, oldckhash, ckhash;

  unsigned char session_key[SESSION_KEY_LEN];
  unsigned char session_response[RESPONSE_LEN];

  unsigned char nbuf[MAXPARAMLEN], gbuf[MAXPARAMLEN], vbuf[MAXPARAMLEN];
  unsigned char saltbuf[MAXSALTLEN], bbuf[BLEN], Bbuf[MAXPARAMLEN];
};

/*
 * SRP server-side negotiation
 *
 * This code negotiates the server side of an SRP exchange.
 * "t_serveropen" accepts a username (sent by the client), a pointer
 *   to an open password file, and a pointer to an open configuration
 *   file.  The server should then call...
 * "t_servergenexp" will generate a random 256-bit exponent and
 *   raise g (from the configuration file) to that power, returning
 *   the result.  This result should be sent to the client as y(p).
 * "t_servergetkey" accepts the exponential w(p), which should be
 *   sent by the client, and computes the 256-bit session key.
 *   This data should be saved before the session is closed.
 * "t_serverresponse" computes the session key proof as SHA(w(p), K).
 * "t_serverclose" closes the session and frees its memory.
 *
 * Note that authentication is not performed per se; it is up
 * to either/both sides of the protocol to now verify securely
 * that their session keys agree in order to establish authenticity.
 * One possible way is through "oracle hashing"; one side sends
 * r, the other replies with H(r,K), where H() is a hash function.
 */
extern struct t_server *
  t_serveropen P((const char *, struct t_pw *, struct t_conf *));
extern struct t_server *
  t_serveropen_s P((const char *));	/* To be implemented */
extern struct t_num * t_servergenexp P((struct t_server *));
extern unsigned char * t_servergetkey P((struct t_server *, struct t_num *));
extern int t_serververify P((struct t_server *, unsigned char *));
extern unsigned char * t_serverresponse P((struct t_server *));
extern void t_serverclose P((struct t_server *));

#endif
