/*
 * This source code is part of my universal C library "libch".
 * Copyright (C) 1998,99  Christian Hammers <ch@westend.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "libch.h"

int	ch_inet_error;

int ch_inet_gethost(char *src, char *dst, int maxlen) {
	char    *last3,*last2,*last1, *t;
	string  tmp;

	strncpy(tmp,src,sizeof(tmp)-1);
 	/* I really don't know why this works and strtok(s,...) don't :-( */

        last1=NULL; last2=NULL; last3=NULL;
        t=strtok(tmp,".");
        while (t!=NULL) {
        	last3=last2; last2=last1; last1=t;
                t=strtok(NULL,".");
        }
	if (last3==NULL) {
		ch_inet_error=CH_INET_HOST_NUMDOTS;
		return 0;
	}
	strncpy(dst,last3,maxlen);

	return 1;
}

int ch_inet_getdomain(char *src, char *dst, int maxlen) {
	char    *last2, *last1, *t;
	string  tmp;

	strncpy(tmp,src,sizeof(tmp)-1);
 	/* I really don't know why this works and strtok(s,...) don't :-( */

        last1=NULL; last2=NULL;
        t=strtok(tmp,".");
        while (t!=NULL) {
        	last2=last1; last1=t;
                t=strtok(NULL,".");
        }
	if (last2==NULL) {
		ch_inet_error=CH_INET_DOMAIN_NUMDOTS;
		return 0;
	}
	strncpy(dst,last2,maxlen);

	return 1;
}

int ch_inet_gettld(char *src, char *dst, int maxlen) {
	if (rindex(src,'.')==NULL) {
		ch_inet_error=CH_INET_TLD_NUMDOTS;
		strcpy(dst,"");
		return 0;
	}
	strncpy(dst,rindex(src,'.')+1,maxlen);

	return 1;
}

int ch_inet_validhost(char *domain) {
	if ((strlen(domain)==0) || (strlen(domain)>CH_INET_HOST_MAXLEN)) {
		ch_inet_error=CH_INET_HOST_INVLEN;
		return 0;
	}
	if (*domain=='-') {
		ch_inet_error=CH_INET_HOST_LEADDASH;
		return 0;
	}
	while (*domain!='\0') {
		if ( ((*domain<'a') || (*domain>'z')) &&
		     ((*domain<'A') || (*domain>'Z')) &&
		     ((*domain<'0') || (*domain>'9')) &&
		     (*domain!='-') ) {
		     ch_inet_error=CH_INET_HOST_INVALIDCHAR;
		     return 0;
		}
		domain++;
	}	
	return 1;
}

int ch_inet_validdomain(char *domain) {
	if (strlen(domain)<2) {
		ch_inet_error=CH_INET_DOMAIN_INVLEN;
		return 0;
	}
	if (*domain=='-') {
		ch_inet_error=CH_INET_DOMAIN_LEADDASH;
		return 0;
	}
	while (*domain!='\0') {
		if ( ((*domain<'a') || (*domain>'z')) &&
		     ((*domain<'A') || (*domain>'Z')) &&
		     ((*domain<'0') || (*domain>'9')) &&
		     (*domain!='-') ) {
		     ch_inet_error=CH_INET_DOMAIN_INVALIDCHAR;
		     return 0;
		}
		domain++;
	}	
	return 1;
}

int ch_inet_validtld(char *tld) {
	if ((strlen(tld)<2) || (strlen(tld)>4)) {
		ch_inet_error=CH_INET_TLD_INVLEN;
		return 0;
	}
	while (*tld!='\0') {
		if ( ((*tld<'a') || (*tld>'z')) &&
		     ((*tld<'A') || (*tld>'Z')) ) {
		     ch_inet_error=CH_INET_TLD_INVALIDCHAR;
		     return 0;
		}
		tld++;
	}	
	return 1;
}

int ch_inet_checkfqdn(char *s) {
	string	host,domain,tld;

	if (strlen(s)>sizeof(host)+sizeof(domain)+sizeof(tld)-3) {
		ch_inet_error=CH_INET_BUFFEROVERFLOW;
		return 0;
	}
	if (!ch_inet_gethost(s,host,sizeof(host)-1)) return 0;
	if (!ch_inet_getdomain(s,domain,sizeof(domain)-1)) return 0;
	if (!ch_inet_gettld(s,tld,sizeof(tld)-1)) return 0;
	if (!ch_inet_validhost(host)) return 0;
	if (!ch_inet_validdomain(domain)) return 0;
	if (!ch_inet_validtld(tld)) return 0;
	if (!strcmp(tld,"de") && (strlen(domain)<3)) {
		ch_inet_error=CH_INET_DOMAIN_INVLEN;
		return 0;
	}
	return 1;
}

int ch_inet_checkdomain(char *s) {
	string	domain,tld;

	if (strlen(s)>sizeof(domain)+sizeof(tld)) {
		ch_inet_error=CH_INET_BUFFEROVERFLOW;
		return 0;
	}
	if (!ch_inet_getdomain(s,domain,sizeof(domain)-1)) return 0;
	if (!ch_inet_gettld(s,tld,sizeof(tld)-1)) return 0;
	if (!ch_inet_validdomain(domain)) return 0;
	if (!ch_inet_validtld(tld)) return 0;
	return 1;
}

int ch_inet_checkdedomain(char *s) {
	string 	domain,tld;

	if (strlen(s)>sizeof(domain)+sizeof(tld)) {
		ch_inet_error=CH_INET_BUFFEROVERFLOW;
		return 0;
	}
	if (!ch_inet_getdomain(s,domain,sizeof(domain)-1)) return 0;
	if (!ch_inet_gettld(s,tld,sizeof(tld)-1)) return 0;
	if (!ch_inet_validdomain(domain)) return 0;
	if (!ch_inet_validtld(tld)) return 0;
	if (strlen(domain)<3) {
		ch_inet_error=CH_INET_DOMAIN_INVLEN;
		return 0;
	}
	if (strcmp(tld,"de")) {
		ch_inet_error=CH_INET_TLD_NODE;
		return 0;
	}
	return 1;
}

int ch_inet_checkcomdomain(char *s) {
	string 	domain,tld;

	if (strlen(s)>sizeof(domain)+sizeof(tld)) {
		ch_inet_error=CH_INET_BUFFEROVERFLOW;
		return 0;
	}
	if (!ch_inet_getdomain(s,domain,sizeof(domain)-1)) return 0;
	if (!ch_inet_gettld(s,tld,sizeof(tld)-1)) return 0;
	if (!ch_inet_validdomain(domain)) return 0;
	if (!ch_inet_validtld(tld)) return 0;
	if (strcmp(tld,"com")) {
		ch_inet_error=CH_INET_TLD_NOCOM;
		return 0;
	} 
	return 1;
}

int ch_inet_validip(char *ip) {
	char	tmp[16];
	char	*s;
	int	i;
	char	*endptr;
	long 	l;

	if (strlen(ip)>15) { ch_inet_error=CH_INET_IP_INVLEN; return 0; }
	if (ip[strlen(ip)-1]=='.') { ch_inet_error=CH_INET_IP_INVLEN; return 0; }
	strncpy(tmp,ip,sizeof(tmp)-1);
	s=strtok(tmp,".");
	for (i=0; i<4; i++) {
		if (!s) { ch_inet_error=CH_INET_IP_INVLEN; return 0; }
		l=strtol(s,&endptr,10);
		if (*endptr) { ch_inet_error=CH_INET_IP_INVALIDCHAR; return 0; }
		if ((l<0) || (l>255)) { ch_inet_error=CH_INET_IP_INVALIDNUMBER; return 0;}
		s=strtok(NULL,".");
	}
	if (s) { ch_inet_error=CH_INET_IP_INVLEN; return 0; }
	return 1;
}
