#! /usr/local/bin/ruby

## Video List Processer
## 1998 by yoshidam
##

require 'parsearg'
require 'xmlparser'
require 'uconv'
require 'nkf'

class XMLRetry<Exception; end

def volumelist(file = nil, date = nil)

  ## file open
  if !file
    f = $stdin
  else
    begin
      f = open(file, "r")
    rescue
      $stderr.print "#{$0}: #{$!}\n";
      return
    end
  end


  ## read body
  xml = f.read
  f.close

  ## dummy default handler
  parser = XMLParser.new
  def parser.unknownEncoding(e)
    raise XMLRetry, e
  end
  def parser.default
  end

  ## start to parse
  volume = 0
  element = ''
  pdate = ''
  pname = ''
  ptitle = ''
  visible = if date.nil?; true else false; end
  vlist = []
  plines = 0
  begin
    parser.parse(xml) do |type, name, data|
      case type
      when XMLParser::START_ELEM
        element = name
        case name
        when 'volume'
          volume += 1
          vlist = []
        when 'program'
          pdate = ''
          pname = ''
          ptitle = ''
        when 'date'
        else
        end
      when XMLParser::END_ELEM
        case name
        when 'volume'
          if visible
            if plines + vlist.length + 2 > 66
              print "\f"
              plines = 0
            end
            plines += vlist.length + 2
            vlist.each do |volume|
              print format("%-8s%-32s%-32s\n", volume[0], volume[1], volume[2])
            end
            print "\n\n"
          end
        when 'program'
          if !visible && !date.nil? && pdate =~ /^\d{6}$/ &&
              pdate >= date
            visible = true
          end
          vlist.push([pdate, pname, ptitle])
        end
      when XMLParser::CDATA
        next if data =~ /^\s*$/;
        data = Uconv.u8toeuc(data)
        case element
        when 'date'
          pdate << data
        when 'name'
          pname << data
        when 'title'
          ptitle << data
        end
      when XMLParser::PI
      else
      end
    end
  rescue XMLRetry
    newencoding = nil
    e = $!.to_s
    if e =~ /^iso-2022-jp$/i
      xml = NKF.nkf("-Je", xml)
      newencoding = "EUC-JP"
    end
    parser = XMLParser.new(newencoding)
    def parser.default; end
    retry
  rescue XMLParserError
    line = parser.line
    print "#{$0}: #{$!} (#{file}:#{line})\n"
  end
end

def usage
  $stderr.print "Usage: #{$0} [-d <date>] <file>\n"
  exit 1
end

parseArgs(0, nil, nil, "d:")
if (ARGV.length == 0)
  usage
end

volumelist(ARGV[0], $OPT_d)

__END__
## Local variables:
## mode: ruby
## End:
