
/* shameless stolen from netscape :-) */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>

#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xmu/WinUtil.h>	/* for XmuClientWindow() */

/* vroot.h is a header file which lets a client get along with `virtual root'
   window managers like swm, tvtwm, olvwm, etc.  If you don't have this header
   file, you can find it at "http://home.netscape.com/newsref/std/vroot.h".
   If you don't care about supporting virtual root window managers, you can
   comment this line out.
 */
#include "vroot.h"

#include "ipc.h"

Atom            xpcd_ver = 0;
Atom            xpcd_cmd = 0;
Atom            xpcd_gate = 0;
Atom            client_box = 0;
Atom            client_name = 0;
Atom            client_class = 0;
Atom            wm_close = 0;

void
ipc_init_atoms(Display * dpy)
{
    xpcd_ver = XInternAtom(dpy, "_XPCD_VER", False);
    xpcd_cmd = XInternAtom(dpy, "_XPCD_CMD", False);
    xpcd_gate = XInternAtom(dpy, "_XPCD_GATE", False);
    client_box = XInternAtom(dpy, "WM_CLIENT_MACHINE", False);
    client_name = XInternAtom(dpy, "WM_NAME", False);
    client_class = XInternAtom(dpy, "WM_CLASS", False);
    wm_close = XInternAtom(dpy, "WM_DELETE_WINDOW", False);
}

Window
ipc_find_window(Display * dpy, Atom atom)
{
    int             i;
    Window          root = RootWindowOfScreen(DefaultScreenOfDisplay(dpy));
    Window          root2, parent, *kids;
    unsigned int    nkids;
    Window          result = 0;

    if (!XQueryTree(dpy, root, &root2, &parent, &kids, &nkids)) {
	fprintf(stderr, "XQueryTree failed on display %s\n",
		DisplayString(dpy));
	exit(2);
    }
    /* root != root2 is possible with virtual root WMs. */

    if (!(kids && nkids)) {
	fprintf(stderr, "root window has no children on display %s\n",
		DisplayString(dpy));
	exit(2);
    }
    for (i = nkids - 1; i >= 0; i--) {
	Atom            type;
	int             format;
	unsigned long   nitems, bytesafter;
	unsigned char  *ver = NULL, *box = NULL;

	Window          w = XmuClientWindow(dpy, kids[i]);

	XGetWindowProperty(dpy, w, atom,
			   0, (65536 / sizeof(long)),
			   False, XA_STRING,
			   &type, &format, &nitems, &bytesafter,
			   &ver);

	if (!ver)
	    continue;
	XFree(ver);

	XGetWindowProperty(dpy, w, client_box,
			   0, (65536 / sizeof(long)),
			   False, XA_STRING,
			   &type, &format, &nitems, &bytesafter,
			   &box);

	if (box) {
	    /* check against _my_ hostname */
	    XFree(box);
	}
	result = w;
	break;
    }
    return result;
}

void
ipc_pass_cmd(Display * dpy, Window win, char *cmd, int argc, char **argv)
{
    char           cwd[256];
    int            i, len;
    char           *pass;

    getcwd(cwd,255);
    for (len = 0, i = argc - 1; i >= 0; i--) {
	len += strlen(argv[i]) + 1;
	if (argv[i][0] != '/') {
	    len += strlen(cwd) + 1;
	}
    }
    pass = malloc(len + strlen(cmd) + 1);
    strcpy(pass, cmd);
    for (len = strlen(pass) + 1, i = argc - 1; i >= 0; i--) {
	if (argv[i][0] != '/') {
	    len += sprintf(pass+len,"%s/%s",cwd,argv[i]) + 1;
	} else {
	    strcpy(pass + len, argv[i]);
	    len += strlen(argv[i]) + 1;
	}
    }
    XChangeProperty(dpy, win,
		    xpcd_cmd, XA_STRING,
		    8, PropModeReplace,
		    pass, len);
    free(pass);
}
