
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>

#include "cfgfile.h"

void
config_read(char *own, char *all, struct CONFIG_FILE *cfg)
{
    int             i, n;
    FILE           *fp;
    char            fn[256];
    char            line[256], tag[32], val[256];

    int            *intval;
    char          **strval;

    strcpy(fn, getenv("HOME"));
    strcat(fn, "/");
    strcat(fn, own);
    if (NULL == (fp = fopen(fn, "r"))) {
	strcpy(fn, all);
	if (NULL == (fp = fopen(all, "r")))
	    return;
    }
    while (NULL != fgets(line, 255, fp)) {

	/* comments & empty lines */
	if ('#' == line[0] || '%' == line[0] || '\n' == line[0])
	    continue;

	if (2 != sscanf(line, " %31[^ \t=] = %255[^\n]", tag, val)) {
	    fprintf(stderr, "%s: parse error: %s\n", fn, line);
	    continue;
	}
	for (i = 0; cfg[i].what != CFG_LAST; i++) {
	    if (0 != strcasecmp(cfg[i].tag, tag))
		continue;
	    switch (cfg[i].what & CFG_TYPEMASK) {
	    case CFG_BOOL:
		intval = cfg[i].data;
		if (atoi(val) ||
		    0 == strcasecmp("yes", val) ||
		    0 == strcasecmp("true", val) ||
		    0 == strcasecmp("off", val))
		    *intval = 1;
		else
		    *intval = 0;
		break;
	    case CFG_INT:
		intval = cfg[i].data;
		n = atoi(val);
		if (n >= cfg[i].low && n <= cfg[i].high)
		    *intval = n;
		else
		    fprintf(stderr, "%s: %s (%d) out of range [%d,%d]\n",
			    fn, tag, n, cfg[i].low, cfg[i].high);
		break;
	    case CFG_STRING:
		strval = cfg[i].data;
		*strval = strcpy(malloc(strlen(val) + 1), val);
		break;
	    case CFG_CALLBACK:
		if (cfg[i].cb)
		    cfg[i].cb(val);
		break;
	    }
	    break;
	}
	if (cfg[i].what == CFG_LAST) {
	    fprintf(stderr, "%s: unknown tag: %s\n", fn, tag);
	}
    }
    fclose(fp);
}

void
config_write(char *own, char *all, struct CONFIG_FILE *cfg)
{
    int             i;
    char            fn[256], fntmp[256];
    char            line[256], tag[32];
    FILE           *in, *out;

    int            *intval;
    char          **strval;

    strcpy(fn, getenv("HOME"));
    strcat(fn, "/");
    strcat(fn, own);
    strcpy(fntmp, fn);
    strcat(fntmp, "~");

    if (0 == rename(fn, fntmp))
	in = fopen(fntmp, "r");
    else
	in = fopen(all, "r");

    if (NULL == (out = fopen(fn, "w")))
	return;

    /* unflag all */
    for (i = 0; cfg[i].what != CFG_LAST; i++) {
	cfg[i].flag = 0;
    }

    /* copy/modify old config file */
    if (in != NULL) {
	while (NULL != fgets(line, 255, in)) {

	    /* comments & empty lines */
	    if ('#' == line[0] || '%' == line[0] || '\n' == line[0]) {
		fputs(line, out);
		continue;
	    }
	    if (1 != sscanf(line, " %31[^ \t=] =", tag)) {
		/* can't parse: hmm, just copy line */
		fputs(line, out);
		continue;
	    }
	    for (i = 0; cfg[i].what != CFG_LAST; i++) {
		if (0 != strcasecmp(cfg[i].tag, tag))
		    continue;
		if (cfg[i].what & CFG_RDONLY ||
		    (cfg[i].what & CFG_TYPEMASK) == CFG_CALLBACK) {
		    /* this entry is read-only, copy... */
		    fputs(line, out);
		    break;
		}
		switch (cfg[i].what & CFG_TYPEMASK) {
		case CFG_BOOL:
		    intval = cfg[i].data;
		    sprintf(line, "%s = %s\n", cfg[i].tag,
			    *intval ? "yes" : "no");
		    break;
		case CFG_INT:
		    intval = cfg[i].data;
		    sprintf(line, "%s = %d\n", cfg[i].tag, *intval);
		    break;
		case CFG_STRING:
		    strval = cfg[i].data;
		    sprintf(line, "%s = %s\n", cfg[i].tag,
			    *strval ? *strval : "");
		    break;
		}
		fputs(line, out);
		cfg[i].flag = 1;	/* flag */
		break;
	    }
	    if (cfg[i].what == CFG_LAST) {
		/* unknown tag: hmm, just copy line */
		fputs(line, out);
	    }
	}
	fclose(in);
    } else {
	fputs("# this is a comment\n\n", out);
    }

    /* save all unflagged */
    for (i = 0; cfg[i].what != CFG_LAST; i++) {
	if (cfg[i].flag)
	    continue;
	if (cfg[i].what & CFG_RDONLY ||
	    (cfg[i].what & CFG_TYPEMASK) == CFG_CALLBACK)
	    continue;
	switch (cfg[i].what & CFG_TYPEMASK) {
	case CFG_BOOL:
	    intval = cfg[i].data;
	    sprintf(line, "%s = %s\n", cfg[i].tag,
		    *intval ? "yes" : "no");
	    break;
	case CFG_INT:
	    intval = cfg[i].data;
	    sprintf(line, "%s = %d\n", cfg[i].tag, *intval);
	    break;
	case CFG_STRING:
	    strval = cfg[i].data;
	    sprintf(line, "%s = %s\n", cfg[i].tag,
		    *strval ? *strval : "");
	    break;
	}
	fputs(line, out);
    }
    fclose(out);
    unlink(fntmp);		/* $HOME/.xpcdrc~ */
}
