// This file is part of Moonlight Creator
//   Copyright (C) 1996-1998  Stephane Rehel
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/*
   Array1.h

   Creation: SR, February 9th, 1996
   Revisions:
*/

#ifndef __Array1_h
#define __Array1_h

#include <assert.h>
#include "boolean.h"

/////////////////////////////////////////////////////////////////////////////

template<class T>
class Array1
{
protected:
  int n;
  T* array;

public:
  Array1();

  virtual ~Array1()
    {
    clear();
    }

  void clear();

  void alloc( int _n );

  boolean allocated() const
    {
    return array != 0;
    }

  int getSize() const
    {
    return n;
    }

  int length() const
    {
    return n;
    }

  // 1 <= i <= n
  T get( int i ) const;

  // 1 <= i <= n
  T& operator [] ( int i );

  boolean inArray( int i ) const
    {
    return i >= 1 && i <= n;
    }

  void fillRegion( int n1, int n2, const T t );

  void fill( const T t )
    {
    assert( array != 0 );
    fillRegion( 1, n, t );
    }
};

/////////////////////////////////////////////////////////////////////////////

template<class T>
inline
Array1<T>::Array1()
{
  array= 0;
  n= 0;
}

/////////////////////////////////////////////////////////////////////////////

template<class T>
inline
void Array1<T>::clear()
{
  if( array == 0 )
    return;

  delete [] array;
  array= 0;
  n= 0;
}

/////////////////////////////////////////////////////////////////////////////

template<class T>
inline
void Array1<T>::alloc( int _n )
{
  clear();

  if( _n < 1 )
    _n= 1;

  n= _n;

  array= new T [ n ];
}

/////////////////////////////////////////////////////////////////////////////

// 0 <= i < n
template<class T>
inline
T Array1<T>::get( int i ) const
{
  assert( i >= 1 );
  assert( i <= n );
  assert( array != 0 );

  return array[i-1];
}

/////////////////////////////////////////////////////////////////////////////

// 0 <= i < n
template<class T>
inline
T& Array1<T>::operator [] ( int i )
{
  assert( i >= 1 );
  assert( i <= n );
  assert( array != 0 );

  return array[i-1];
}

/////////////////////////////////////////////////////////////////////////////

template<class T>
inline
void Array1<T>::fillRegion( int n1, int n2, const T t )
{
  if( array == 0 )
    return;

  if( n1 < 1 )
    n1= 1;
  if( n2 > n )
    n2= n;

  register T* array_i= array + n1 - 1;
  for( register int i= n2-n1+1; i; --i, ++array_i )
    *array_i= t;
}

/////////////////////////////////////////////////////////////////////////////

#endif // ifndef __Array1_h
