#ifndef CWSIGNALDATA_HH
#define CWSIGNALDATA_HH

#include "STDTypes.hh"
#include "TaggedRecord.hh"
#include <stdlib.h>

struct CWSignalData : public VHDLData {
  TaggedRecord *val;

  virtual ~CWSignalData();

  virtual VHDLData::UniversalType get_universal_kind() const{
    return CLASS_WIDE;
  }

  // All of these constructors should malloc enough space for largest signal
  // in certain cases. If we are constructing a class wide signal for an rval
  // of an assignment statement then the fore mentioned need not be considered.
  // If we are actually constructing a class wide signal, it is definitely a
  // consideration

  CWSignalData();
  CWSignalData(const TaggedRecord& t);
  CWSignalData(const CWSignalData& c);

  // constructor needed here with memory allocation

  VHDLData& operator=(const VHDLData& d);

  virtual int getSize() const {
    return sizeof(*this);
  }

  void print(ostream& os) const;

  bool operator!=(const VHDLData&) const;

  VHDLData *clone() const {
    return new CWSignalData(*this);
  }

  
};  

#endif
